/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.output.ProfList;
import pyrosim.legacy_2012_1.domain.output.ProfRec;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class ProfParser
extends AFDS5Parser {
    public ProfParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("PROF");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        FDSArray fDSArray;
        UnitPoint3D unitPoint3D;
        IQuantity iQuantity;
        int n = 0;
        if (!fDSParseRecord.contains("IOR")) {
            n |= 2;
        }
        if (!fDSParseRecord.contains("QUANTITY")) {
            n |= 4;
        }
        if (!fDSParseRecord.contains("XYZ")) {
            n |= 8;
        }
        String string = Intl.intl("PROF Record Ignored");
        if ((n & 2) > 0) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process PROF record: IOR missing"), string);
        }
        if ((n & 4) > 0) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process PROF record: QUANTITY missing"), string);
        }
        if ((n & 8) > 0) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process PROF record: XYZ missing"), string);
        }
        if (n > 0) {
            return false;
        }
        String string2 = (String)fDSParseRecord.get("ID");
        if (string2 == null || string2.trim().equals("")) {
            string2 = Util.getUniqueName(this.getContainer().getProfList(), Intl.intl("PROF"));
        }
        if ((iQuantity = this.parseQuantity(fDSParseRecord, "QUANTITY", null, null, null, null, null, 256, string, true, false)) == null) {
            return false;
        }
        int n2 = fDSParseRecord.getInteger("IOR");
        ProfRec profRec = new ProfRec(string2, n2, iQuantity, unitPoint3D = new UnitPoint3D((UnitDouble)(fDSArray = fDSParseRecord.getArray("XYZ", true)).get(0), (UnitDouble)fDSArray.get(1), (UnitDouble)fDSArray.get(2)));
        int n3 = this.existsStatus(fDSParseRecord, profRec, ProfRec.class);
        if (n3 != 0) {
            return this.convertToReturn(n3);
        }
        ProfList profList = this.getContainer().getProfList();
        profList.add(profRec);
        this.flagObjectAdded(profRec);
        return true;
    }
}

