/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.quantity.VelocitySign;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;

public class Plot3dParser
extends AFDS5Parser {
    public Plot3dParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("DUMP");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        FDSArray fDSArray = fDSParseRecord.getArray("PLOT3D_QUANTITY", true);
        if (fDSArray == null) {
            return true;
        }
        FDSArray fDSArray2 = fDSParseRecord.getArray("PLOT3D_SPEC_ID", true);
        FDSArray fDSArray3 = fDSParseRecord.getArray("PLOT3D_PART_ID", true);
        FDSArray fDSArray4 = fDSParseRecord.getArray("PLOT3D_VELO_INDEX", true);
        ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>(5);
        VelocitySign velocitySign = VelocitySign.ALWAYS_POSITIVE;
        for (int i = 0; i < Math.min(fDSArray.getTotalLength(), 5); ++i) {
            String string = (String)fDSArray.get(i);
            if (string == null) continue;
            String string2 = fDSArray2 != null ? (String)fDSArray2.get(i) : null;
            String string3 = fDSArray3 != null ? (String)fDSArray3.get(i) : null;
            Integer n = fDSArray4 != null ? (Integer)fDSArray4.get(i) : null;
            IQuantity iQuantity = this.getQuantityMap().parseQuantity(this.getParsingInfo(), fDSParseRecord, string, string3, string2, null, null, null);
            if (iQuantity == null) continue;
            if (!QuantityUtil.canOutputAll(iQuantity.get(), 64)) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Quantity %s is invalid for Plot3D output."), string), Intl.intl("Quantity ignored"));
                continue;
            }
            arrayList.add(iQuantity);
            if (!iQuantity.get().equals((Object)Quantity.VELOCITY)) continue;
            velocitySign = this.parseVelocitySign(fDSParseRecord, n);
        }
        Plot3d plot3d = this.getContainer().getPlot3d();
        plot3d.setQuantities(arrayList);
        plot3d.setVelocitySign(velocitySign);
        this.flagObjectAdded(plot3d);
        return true;
    }
}

