/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.evac.Pers;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class PersParser
extends AFDS5Parser {
    public PersParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Serializable serializable;
        HashMap<String, Object> hashMap;
        String string;
        boolean bl = false;
        boolean bl2 = false;
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process PERS record: ID missing"), Intl.intl("PERS Record Ignored"));
            return false;
        }
        PersList persList = this.getContainer().getPersList();
        if (persList.get(string = fDSParseRecord.getString("ID")) != null) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process PERS record: Duplicate ID"), Intl.intl("PERS Record Ignored"));
            return false;
        }
        String string2 = null;
        Pers pers = null;
        if (fDSParseRecord.contains("DEFAULT_PROPERTIES")) {
            string2 = fDSParseRecord.getString("DEFAULT_PROPERTIES");
            pers = PersList.PREDEFINED.get(string2);
            if (pers == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Unknown default properties type: %s"), string2), Intl.intl("Default properties reset to null."));
            }
            bl2 = true;
        }
        if ((hashMap = new HashMap<String, Object>(fDSParseRecord.getProperties())).containsKey("AVATAR_COLOR")) {
            serializable = this.parseColor(fDSParseRecord, "AVATAR_RGB", "AVATAR_COLOR", null, false);
            hashMap.remove("AVATAR_RGB");
            hashMap.put("AVATAR_COLOR", serializable);
        }
        if (hashMap.containsKey("DEAD_COLOR")) {
            serializable = this.parseColor(fDSParseRecord, "DEAD_RGB", "DEAD_COLOR", null, false);
            hashMap.remove("DEAD_RGB");
            hashMap.put("DEAD_COLOR", serializable);
        }
        serializable = this.getContainer().getSimParams().getPersGlobals();
        HashSet hashSet = new HashSet();
        for (Object object : hashMap.keySet()) {
            if (hashSet.contains(object)) continue;
            ((Pers)serializable).setProp((String)object, hashMap.get(object));
            bl = true;
            this.flagObjectAdded(this.getContainer().getSimParams());
            this.flagEvac();
        }
        Pers pers2 = new Pers(string, pers);
        if (hashMap.containsKey("FYI")) {
            pers2.setProp("FYI", hashMap.get("FYI"));
            bl2 = true;
        }
        for (String string3 : hashMap.keySet()) {
            if (!hashSet.contains(string3) || theUtil.equal(string3, "ID") || theUtil.equal(string3, "FYI") || theUtil.equal(string3, "DEFAULT_PROPERTIES")) continue;
            pers2.setProp(string3, hashMap.get(string3));
            bl2 = true;
        }
        if (!bl || bl2) {
            persList.add(pers2);
            this.flagObjectAdded(pers2);
            this.flagEvac();
        }
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("PERS");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }
}

