/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.particle.ConstColoring;
import pyrosim.legacy_2012_1.domain.particle.DropletColoring;
import pyrosim.legacy_2012_1.domain.particle.FuelPartDesc;
import pyrosim.legacy_2012_1.domain.particle.FuelPyrolysis;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IColoring;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.Output;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.particle.Pyrolysis;
import pyrosim.legacy_2012_1.domain.particle.SizeDistribution;
import pyrosim.legacy_2012_1.domain.particle.ThermalProps;
import pyrosim.legacy_2012_1.domain.particle.TracerPartDesc;
import pyrosim.legacy_2012_1.domain.particle.WaterPartDesc;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParseWarning;
import pyrosim.legacy_2012_1.io.fds.FDSParsingInfo;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.common.ParticleQuantityMap;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class ParticleParser
extends AFDS5Parser {
    private final PinConnParser d_pinConns;

    public ParticleParser(FDS5ParsingInfo fDS5ParsingInfo, PinConnParser pinConnParser) {
        super(fDS5ParsingInfo);
        this.d_pinConns = pinConnParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("PART");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
        set.add("HORIZONTAL_VELOCITY");
        set.add("VERTICAL_VELOCITY");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("ID", false);
        if (!this.checkName(fDSParseRecord, string)) {
            return false;
        }
        IParticleDesc iParticleDesc = ParticleParser.parsePartDesc(this.getParsingInfo(), fDSParseRecord);
        Particle particle = new Particle(string, iParticleDesc);
        particle.setFYI(fDSParseRecord.getString("FYI", false));
        particle.setCustomFDSProps(this.getCustomVals(fDSParseRecord));
        int n = this.existsStatus(fDSParseRecord, particle, Particle.class);
        if (n != 0) {
            return this.convertToReturn(n);
        }
        this.getContainer().getPartList().add(particle);
        this.flagObjectAdded(particle);
        ParticleParser.markSingleInputForRetrieval(fDSParseRecord, particle, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return true;
    }

    public static IParticleDesc parsePartDesc(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        TracerPartDesc tracerPartDesc = ParticleParser.parseTracer(fDSParsingInfo, fDSParseRecord);
        if (tracerPartDesc != null) {
            return tracerPartDesc;
        }
        WaterPartDesc waterPartDesc = ParticleParser.parseWater(fDSParsingInfo, fDSParseRecord);
        if (waterPartDesc != null) {
            return waterPartDesc;
        }
        FuelPartDesc fuelPartDesc = ParticleParser.parseFuel(fDSParsingInfo, fDSParseRecord);
        if (fuelPartDesc != null) {
            return fuelPartDesc;
        }
        return ParticleParser.parseGeneric(fDSParsingInfo, fDSParseRecord);
    }

    private static TracerPartDesc parseTracer(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (!fDSParseRecord.getBoolean("MASSLESS", true).booleanValue()) {
            return null;
        }
        Color color = ParticleParser.parseColor(fDSParsingInfo, fDSParseRecord, "RGB", "COLOR", null, true);
        Output output = ParticleParser.parseOutput(fDSParseRecord, 1);
        return new TracerPartDesc(color, output);
    }

    private static WaterPartDesc parseWater(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (!fDSParseRecord.getBoolean("WATER", true).booleanValue()) {
            return null;
        }
        return new WaterPartDesc(ParticleParser.parseThermalPropsWater(fDSParseRecord), ParticleParser.parsePyrolysisWater(fDSParseRecord), ParticleParser.parseSizeDist(fDSParsingInfo, fDSParseRecord), ParticleParser.parseOutput(fDSParseRecord, 10), ParticleParser.parseColoring(fDSParsingInfo, fDSParseRecord), fDSParseRecord.getInteger("DROPLETS_PER_SECOND", true));
    }

    private static FuelPartDesc parseFuel(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (!fDSParseRecord.getBoolean("FUEL", true).booleanValue()) {
            return null;
        }
        return new FuelPartDesc(ParticleParser.parseThermalProps(fDSParseRecord), ParticleParser.parseFuelPyrolysis(fDSParseRecord), ParticleParser.parseSizeDist(fDSParsingInfo, fDSParseRecord), ParticleParser.parseOutput(fDSParseRecord, 10), ParticleParser.parseColoring(fDSParsingInfo, fDSParseRecord), (int)fDSParseRecord.getInteger("DROPLETS_PER_SECOND", true));
    }

    private static GenericPartDesc parseGeneric(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        return new GenericPartDesc(ParticleParser.parseThermalProps(fDSParseRecord), ParticleParser.parseGenericPyrolysis(fDSParsingInfo, fDSParseRecord), ParticleParser.parseSizeDist(fDSParsingInfo, fDSParseRecord), ParticleParser.parseOutput(fDSParseRecord, 10), ParticleParser.parseColoring(fDSParsingInfo, fDSParseRecord), fDSParseRecord.getInteger("DROPLETS_PER_SECOND", true));
    }

    private static ThermalProps parseThermalProps(FDSParseRecord fDSParseRecord) {
        return new ThermalProps(fDSParseRecord.getUnitDouble("DENSITY", true), fDSParseRecord.getUnitDouble("SPECIFIC_HEAT", true), fDSParseRecord.getUnitDouble("INITIAL_TEMPERATURE", true));
    }

    private static ThermalProps parseThermalPropsWater(FDSParseRecord fDSParseRecord) {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("SPECIFIC_HEAT");
        if (unitDouble == null) {
            unitDouble = new UnitDouble(4.184, SI.KILO(SI.JOULE).divide(SI.KILOGRAM.multiply(SI.KELVIN)));
        }
        return new ThermalProps(fDSParseRecord.getUnitDouble("DENSITY", true), unitDouble, fDSParseRecord.getUnitDouble("INITIAL_TEMPERATURE", true));
    }

    private static Pyrolysis parseGenericPyrolysis(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord) {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("MELTING_TEMPERATURE", true);
        boolean bl = fDSParseRecord.getBoolean("EVAPORATE", true);
        if (bl) {
            String string = fDSParseRecord.getString("SPEC_ID", false);
            ExSpec exSpec = null;
            if (string != null && (exSpec = fDSParsingInfo.findObject(ExSpec.class, string)) == null) {
                fDSParsingInfo.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find SPEC with ID \"%s.\""), string), Intl.intl("Ignoring vaporization species."));
            }
            return Pyrolysis.evapOn(unitDouble, fDSParseRecord.getUnitDouble("VAPORIZATION_TEMPERATURE", true), fDSParseRecord.getUnitDouble("HEAT_OF_VAPORIZATION", true), exSpec);
        }
        return Pyrolysis.evapOff(unitDouble);
    }

    private static Pyrolysis parsePyrolysisWater(FDSParseRecord fDSParseRecord) {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("MELTING_TEMPERATURE");
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("HEAT_OF_VAPORIZATION");
        UnitDouble unitDouble3 = fDSParseRecord.getUnitDouble("VAPORIZATION_TEMPERATURE");
        if (unitDouble == null) {
            unitDouble = new UnitDouble(0.0, SI.CELSIUS);
        }
        if (unitDouble2 == null) {
            unitDouble2 = new UnitDouble(2259.0, SI.KILO(SI.JOULE).divide(SI.KILOGRAM));
        }
        if (unitDouble3 == null) {
            unitDouble3 = new UnitDouble(100.0, SI.CELSIUS);
        }
        return Pyrolysis.evapOn(unitDouble, unitDouble3, unitDouble2, null);
    }

    private static Pyrolysis parsePyrolysisFuel(FDSParseRecord fDSParseRecord) {
        return Pyrolysis.evapOn(fDSParseRecord.getUnitDouble("MELTING_TEMPERATURE", false), fDSParseRecord.getUnitDouble("VAPORIZATION_TEMPERATURE", false), fDSParseRecord.getUnitDouble("HEAT_OF_VAPORIZATION", false), null);
    }

    private static FuelPyrolysis parseFuelPyrolysis(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("HEAT_OF_COMBUSTION", true);
        if (unitDouble == null) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Fuel particles must specify a heat of combustion."));
        }
        Pyrolysis pyrolysis = ParticleParser.parsePyrolysisFuel(fDSParseRecord);
        return new FuelPyrolysis(pyrolysis.d_meltingTemp, pyrolysis.d_vapTemp, pyrolysis.d_heatOfVap, unitDouble);
    }

    private static IColoring parseColoring(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord) {
        if (fDSParseRecord.contains("QUANTITIES")) {
            List list = fDSParseRecord.getList("QUANTITIES", false);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
            for (String string : list) {
                Integer n = ParticleQuantityMap.getPyroVal(string);
                if (n == null) {
                    fDSParsingInfo.addWarning(fDSParseRecord, String.format(Intl.intl("Unknown particle coloring quantity, %s."), string), Intl.intl("Ignoring coloring quantity."));
                    continue;
                }
                arrayList.add(n);
            }
            return new DropletColoring(arrayList);
        }
        Color color = ParticleParser.parseColor(fDSParsingInfo, fDSParseRecord, "RGB", "COLOR", null, false);
        if (color != null) {
            return new ConstColoring(color);
        }
        return null;
    }

    private static SizeDistribution parseSizeDist(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord) {
        SizeDistribution.Type type;
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("DIAMETER", true);
        boolean bl = (Boolean)fDSParseRecord.get("MONODISPERSE", true);
        if (bl) {
            type = new SizeDistribution.Constant();
        } else {
            UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("MINIMUM_DIAMETER", true);
            UnitDouble unitDouble3 = (UnitDouble)fDSParseRecord.get("MAXIMUM_DIAMETER", true);
            if (unitDouble2.getValue(SI.METER) > unitDouble3.getValue(SI.METER)) {
                fDSParsingInfo.addWarning(new FDSParseWarning(fDSParseRecord, String.format(Intl.intl("The maximum diameter is less than the minimum diameter (min=%1$s, max=%2$s)."), unitDouble2.toString(), unitDouble3.toString()), Intl.intl("Switching minimum and maximum diameters.")));
                UnitDouble unitDouble4 = unitDouble2;
                unitDouble2 = unitDouble3;
                unitDouble3 = unitDouble4;
            }
            double d = (Double)fDSParseRecord.get("GAMMA_D", true);
            Double d2 = fDSParseRecord.getDouble("SIGMA_D", true);
            type = new SizeDistribution.RosinRammler(d, unitDouble2, unitDouble3, d2);
        }
        return new SizeDistribution(unitDouble, type);
    }

    private static Output parseOutput(FDSParseRecord fDSParseRecord, int n) {
        int n2 = fDSParseRecord.getInteger("SAMPLING_FACTOR", true);
        if (n2 == -1) {
            n2 = n;
        }
        return new Output(fDSParseRecord.getUnitDouble("AGE", true), fDSParseRecord.getUnitDouble("DT_INSERT", true), n2);
    }
}

