/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Collection;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.tasks.FillGridsWithPartsTask;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;

public class PartCloudParser
extends AFDS5Parser {
    private Set<Particle> d_staticParticles = new IdentityHashSet<Particle>();

    public PartCloudParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("PART");
        set.add("INIT");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public void process(Collection<FDSParseRecord> collection, Collection<FDSParseRecord> collection2) throws FDSRecordFormatException {
        for (FDSParseRecord fDSParseRecord : collection) {
            String string;
            Particle particle;
            boolean bl;
            if (!fDSParseRecord.getType().equals("PART") || !(bl = fDSParseRecord.getBoolean("STATIC", true).booleanValue()) || (particle = (string = fDSParseRecord.getString("ID")) != null ? this.getParsingInfo().findObject(Particle.class, string) : null) == null) continue;
            this.d_staticParticles.add(particle);
        }
        super.process(collection, collection2);
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (fDSParseRecord.getType().equals("PART")) {
            return this.processAsPart(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("INIT")) {
            return this.processAsInit(fDSParseRecord);
        }
        return false;
    }

    protected boolean processAsPart(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("ID");
        return this.parsePartCloud(fDSParseRecord, string, "NUMBER_INITIAL_DROPLETS", "MASS_PER_VOLUME", null, null, "XB");
    }

    protected boolean processAsInit(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = fDSParseRecord.getString("PART_ID");
        return this.parsePartCloud(fDSParseRecord, string, "NUMBER_INITIAL_DROPLETS", "MASS_PER_VOLUME", "DT_INSERT", "MASS_PER_TIME", "XB");
    }

    protected boolean parsePartCloud(FDSParseRecord fDSParseRecord, String string, String string2, String string3, String string4, String string5, String string6) throws FDSRecordFormatException {
        int n = (Integer)fDSParseRecord.get(string2, true);
        if (n == 0) {
            return true;
        }
        Particle particle = this.findParticle(fDSParseRecord, string);
        if (particle == null) {
            return true;
        }
        String string7 = fDSParseRecord.getComment().trim();
        if (string7 == null || string7.isEmpty()) {
            string7 = string.contains(Intl.intl("Cloud")) ? string : String.format(Intl.intl("%s Cloud"), string);
        }
        boolean bl = this.d_staticParticles.contains(particle);
        PartCloud.ConstDropletCount constDropletCount = new PartCloud.ConstDropletCount(n);
        PartCloud.IInsertion iInsertion = this.parseInsertion(fDSParseRecord, string3, string4, string5);
        if (fDSParseRecord.contains(string6)) {
            AABoxGeom aABoxGeom = PartCloudParser.parseXBGeom(fDSParseRecord, fDSParseRecord.getType(), string6, true);
            PartCloud partCloud = new PartCloud(string7, particle, aABoxGeom);
            partCloud.setInsertion(iInsertion);
            partCloud.setInitDrops(constDropletCount);
            partCloud.setStatic(bl);
            this.getContainer().getObstructions().add(partCloud);
            this.flagObjectAdded(partCloud);
        } else {
            FillGridsWithPartsTask fillGridsWithPartsTask = new FillGridsWithPartsTask(this.getContainer(), string7, this.getContainer().getGridManager().flatten(), particle, constDropletCount, iInsertion, bl, false);
            fillGridsWithPartsTask.run();
            this.flagObjectsAdded(fillGridsWithPartsTask.getAddedObjects());
        }
        return true;
    }

    protected Particle findParticle(FDSParseRecord fDSParseRecord, String string) {
        if (string == null) {
            this.addWarning(fDSParseRecord, Intl.intl("Missing PART_ID for initial droplets."), Intl.intl("Ignoring initial droplets."));
            return null;
        }
        Particle particle = this.getParsingInfo().findObject(Particle.class, string);
        if (particle == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find particle, %s, for initial droplets."), string), Intl.intl("Ignoring initial droplets."));
            return null;
        }
        return particle;
    }

    protected PartCloud.IInsertion parseInsertion(FDSParseRecord fDSParseRecord, String string, String string2, String string3) {
        boolean bl = string2 == null || !fDSParseRecord.contains(string2);
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble(string, bl);
        if (unitDouble != null) {
            return new PartCloud.InsertOnce(unitDouble);
        }
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble(string2);
        assert (unitDouble2 != null);
        UnitDouble unitDouble3 = fDSParseRecord.getUnitDouble(string3, true);
        return new PartCloud.InsertPeriodically(unitDouble2, unitDouble3);
    }
}

