/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDSObjParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.SimParamsParser;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class ObstParser
extends AFDSObjParser {
    private final SimParamsParser d_spParser;
    private final PinConnParser d_pinConns;

    public ObstParser(FDS5ParsingInfo fDS5ParsingInfo, PinConnParser pinConnParser, SimParamsParser simParamsParser) {
        super(fDS5ParsingInfo);
        this.d_pinConns = pinConnParser;
        this.d_spParser = simParamsParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("OBST");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
        set.add("BNDF_FACE");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = this.generateName(fDSParseRecord, Intl.intl("Obstruction"));
        AABoxGeom aABoxGeom = ObstParser.parseXBGeom(fDSParseRecord, "OBST", "XB", true);
        Surface[] surfaceArray = this.getSurfs(fDSParseRecord);
        Obstruction obstruction = new Obstruction(string, aABoxGeom, surfaceArray);
        Color color = this.parseColor(fDSParseRecord, "RGB", "COLOR", "TRANSPARENCY", false);
        if (color == INVISIBLE_COLOR) {
            obstruction.setVisible(false);
            obstruction.setColors(new Color[]{null});
        } else {
            obstruction.setColors(color);
        }
        obstruction.setEvac(this.parseEvac(fDSParseRecord, "EVACUATION", "MESH_ID"));
        this.parseOption(fDSParseRecord, obstruction, 1, "THICKEN");
        this.parseOption(fDSParseRecord, obstruction, 16, "BNDF_OBST");
        obstruction.setOptions(2, fDSParseRecord.getBoolean("SAWTOOTH", true) == false);
        obstruction.setOptions(4, fDSParseRecord.getBoolean("PERMIT_HOLE", true));
        obstruction.setOptions(8, fDSParseRecord.getBoolean("ALLOW_VENT", true));
        obstruction.setOptions(32, fDSParseRecord.getBoolean("OUTLINE", true));
        obstruction.setOptions(64, fDSParseRecord.getBoolean("REMOVABLE", true));
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("BULK_DENSITY", true);
        if (unitDouble.getValueNoUnit() > 0.0) {
            obstruction.setBulkDensity(unitDouble);
        }
        TexOrigin texOrigin = ObstParser.parseTexLoc(fDSParseRecord, aABoxGeom.min, "OBST", "TEXTURE_ORIGIN");
        obstruction.setTextureOrigin(texOrigin);
        ObstParser.markSingleInputForRetrieval(fDSParseRecord, obstruction, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        Pair<String, List<Obstruction>> pair = this.applyMult(fDSParseRecord, "MULT_ID", obstruction);
        this.addObjects((String)pair.v1, (List)pair.v2);
        return true;
    }

    private void parseOption(FDSParseRecord fDSParseRecord, IObstruction iObstruction, int n, String string) {
        Boolean bl = fDSParseRecord.getBoolean(string, false);
        if (bl == null) {
            boolean bl2 = (this.d_spParser.getObstDefaults() & n) == n;
            iObstruction.setOptions(n, bl2);
        } else {
            iObstruction.setOptions(n, bl);
        }
    }

    private Surface[] getSurfs(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Serializable serializable;
        IObjectFilter<Surface> iObjectFilter = Obstruction.getSurfaceFilter();
        Surface[] surfaceArray = null;
        if (fDSParseRecord.contains("SURF_ID")) {
            serializable = this.getSurfaceSafe(fDSParseRecord, fDSParseRecord.getString("SURF_ID", false), iObjectFilter);
            surfaceArray = new Surface[]{serializable};
        } else if (fDSParseRecord.contains("SURF_IDS")) {
            serializable = fDSParseRecord.getArray("SURF_IDS", false);
            surfaceArray = new Surface[]{this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(1), iObjectFilter), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(1), iObjectFilter), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(1), iObjectFilter), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(1), iObjectFilter), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(2), iObjectFilter), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(0), iObjectFilter)};
        } else if (fDSParseRecord.contains("SURF_ID6")) {
            serializable = fDSParseRecord.getArray("SURF_ID6", false);
            surfaceArray = new Surface[]{this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(0), iObjectFilter), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(1), iObjectFilter), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(2), iObjectFilter), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(3), iObjectFilter), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(4), iObjectFilter), this.getSurfaceSafe(fDSParseRecord, (String)((FDSArray)serializable).get(5), iObjectFilter)};
        } else {
            serializable = this.getDefaultMat();
            surfaceArray = new Surface[]{serializable};
        }
        if (surfaceArray.length > 1 && GeomUtil.isUniform(surfaceArray)) {
            surfaceArray = new Surface[]{surfaceArray[0]};
        }
        if (surfaceArray.length == 1) {
            return surfaceArray;
        }
        serializable = new Surface[]{surfaceArray[0], surfaceArray[1], surfaceArray[2], surfaceArray[3], surfaceArray[4], surfaceArray[5]};
        return serializable;
    }
}

