/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.Multiplier;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class MultParser
extends AFDS5Parser {
    public MultParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("MULT");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = fDSParseRecord.getString("ID");
        if (string == null) {
            this.addWarning(fDSParseRecord, Intl.intl("MULT record does not have an ID."), Intl.intl("Adding to the additional records section."));
            return false;
        }
        FDSArray fDSArray = fDSParseRecord.getArray("DXB", true);
        assert (fDSArray.getTotalLength() >= 6);
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("DX0", true);
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("DY0", true);
        UnitDouble unitDouble3 = fDSParseRecord.getUnitDouble("DZ0", true);
        Multiplier multiplier = new Multiplier(string, new UnitPoint3D(unitDouble, unitDouble2, unitDouble3), new UnitDouble[]{(UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1)}, new UnitDouble[]{(UnitDouble)fDSArray.get(2), (UnitDouble)fDSArray.get(3)}, new UnitDouble[]{(UnitDouble)fDSArray.get(4), (UnitDouble)fDSArray.get(5)}, fDSParseRecord.getUnitDouble("DX", true), fDSParseRecord.getUnitDouble("DY", true), fDSParseRecord.getUnitDouble("DZ", true), new int[]{fDSParseRecord.getInteger("I_LOWER", true), fDSParseRecord.getInteger("I_UPPER", true)}, new int[]{fDSParseRecord.getInteger("J_LOWER", true), fDSParseRecord.getInteger("J_UPPER", true)}, new int[]{fDSParseRecord.getInteger("K_LOWER", true), fDSParseRecord.getInteger("K_UPPER", true)}, new int[]{fDSParseRecord.getInteger("N_LOWER", true), fDSParseRecord.getInteger("N_UPPER", true)});
        this.getParsingInfo().addMultipler(multiplier);
        return true;
    }
}

