/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.IHeatBasedValue;
import pyrosim.legacy_2012_1.domain.boundcond.mat.IPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps;
import pyrosim.legacy_2012_1.domain.ramp.IRampInput;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class MaterialParser
extends AFDS5Parser {
    private final Map<String, Material> d_matPlaceholderMap = new HashMap<String, Material>();
    private final Map<String, FDSParseRecord> d_placeholderRefMap = new HashMap<String, FDSParseRecord>();
    private final List<Pair<Material, FDSParseRecord>> d_parsedMats = new ArrayList<Pair<Material, FDSParseRecord>>();

    public MaterialParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("MATL");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public void done() throws FDSRecordFormatException {
        for (Map.Entry<String, FDSParseRecord> object : this.d_placeholderRefMap.entrySet()) {
            Material material = this.getParsingInfo().findObject(Material.class, object.getKey());
            if (material != null) continue;
            throw new FDSRecordFormatException(object.getValue(), String.format(Intl.intl("Could not find MATL %s."), object.getKey()));
        }
        for (Pair pair : this.d_parsedMats) {
            if (((Material)pair.v1).hasValidResidues()) continue;
            throw new FDSRecordFormatException((FDSParseRecord)pair.v2, Intl.intl("Material contains a residue cycle."));
        }
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string;
        String string2 = (String)fDSParseRecord.get("ID", false);
        if (!this.checkName(fDSParseRecord, string2)) {
            return false;
        }
        Material material = this.d_matPlaceholderMap.get(string2);
        if (material == null) {
            material = new Material(string2);
        }
        if ((string = (String)fDSParseRecord.get("FYI")) != null) {
            material.setFYI(string);
        }
        material.setThermalProps(this.getThermalProps(fDSParseRecord));
        material.setPyrolysis(this.getPyrolysis(fDSParseRecord));
        material.setCustomFDSProps(this.getCustomVals(fDSParseRecord));
        int n = this.existsStatus(fDSParseRecord, material, Material.class);
        if (n != 0) {
            return this.convertToReturn(n);
        }
        this.getContainer().getMaterialMgr().add(material);
        this.flagObjectAdded(material);
        this.d_parsedMats.add(new Pair<Material, FDSParseRecord>(material, fDSParseRecord));
        return true;
    }

    private ThermalProps getThermalProps(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        IHeatBasedValue iHeatBasedValue = this.getRampableValue(fDSParseRecord, "CONDUCTIVITY", "CONDUCTIVITY_RAMP", RampInputs.HEAT, 19);
        IHeatBasedValue iHeatBasedValue2 = this.getRampableValue(fDSParseRecord, "SPECIFIC_HEAT", "SPECIFIC_HEAT_RAMP", RampInputs.HEAT, 11);
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("DENSITY", true);
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("ABSORPTION_COEFFICIENT", true);
        double d = fDSParseRecord.getDouble("EMISSIVITY", true);
        return new ThermalProps(iHeatBasedValue, unitDouble, iHeatBasedValue2, d, unitDouble2);
    }

    private IPyrolysis getPyrolysis(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        LiquidPyrolysis liquidPyrolysis = this.getLiquidPyrolysis(fDSParseRecord);
        if (liquidPyrolysis != null) {
            return liquidPyrolysis;
        }
        return this.getSolidPyrolysis(fDSParseRecord);
    }

    private LiquidPyrolysis getLiquidPyrolysis(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("BOILING_TEMPERATURE", false);
        if (unitDouble == null) {
            return null;
        }
        Integer n = fDSParseRecord.getInteger("N_REACTIONS", false);
        if (n != null && n != 1) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Liquid materials must have one reaction."));
        }
        LiquidReaction.Rate rate = new LiquidReaction.Rate(unitDouble);
        List<ReacByproducts> list = this.getReacByproducts(fDSParseRecord, 1);
        if (list.get((int)0).d_heat == null) {
            serializable3 = SIUS.newud(0.0, 46);
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Liquid materials should specify %s."), "HEAT_OF_REACTION"), String.format(Intl.intl("Assuming a %1$s of %2$s."), "HEAT_OF_REACTION", Global.format(serializable3)));
            serializable2 = list.get(0);
            serializable = new ReacByproducts(((ReacByproducts)serializable2).d_nuFuel, ((ReacByproducts)serializable2).d_nuWater, ((ReacByproducts)serializable2).d_nuResidue, ((ReacByproducts)serializable2).getResidue(), (UnitDouble)serializable3);
            list = Arrays.asList(serializable);
        }
        serializable3 = new LiquidReaction(rate, list.get(0));
        serializable2 = fDSParseRecord.getUnitDouble("HEAT_OF_COMBUSTION", false);
        serializable = fDSParseRecord.getUnitDouble("INITIAL_VAPOR_FLUX", true);
        return new LiquidPyrolysis((UnitDouble)serializable2, (UnitDouble)serializable, (LiquidReaction)serializable3);
    }

    private SolidPyrolysis getSolidPyrolysis(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("HEAT_OF_COMBUSTION", true);
        Integer n = fDSParseRecord.getInteger("N_REACTIONS", true);
        List<ReacByproducts> list = this.getReacByproducts(fDSParseRecord, n);
        List<SolidReaction.Rate> list2 = this.getSolidRates(fDSParseRecord, n);
        ArrayList<SolidReaction> arrayList = new ArrayList<SolidReaction>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new SolidReaction(list2.get(i), list.get(i)));
        }
        return new SolidPyrolysis(unitDouble, arrayList);
    }

    private List<ReacByproducts> getReacByproducts(FDSParseRecord fDSParseRecord, int n) throws FDSRecordFormatException {
        ArrayList<ReacByproducts> arrayList = new ArrayList<ReacByproducts>(n);
        List list = fDSParseRecord.getList("NU_FUEL", n, true);
        List list2 = fDSParseRecord.getList("NU_WATER", n, true);
        List list3 = fDSParseRecord.getList("NU_RESIDUE", n, true);
        List list4 = fDSParseRecord.getList("RESIDUE", n, true);
        List list5 = fDSParseRecord.getList("HEAT_OF_REACTION", n, true);
        for (int i = 0; i < n; ++i) {
            double d;
            double d2;
            double d3;
            double d4 = (Double)list3.get(i);
            Material material = null;
            if (d4 > 0.0) {
                String string = (String)list4.get(i);
                if (string == null) {
                    throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("A residue fraction was specified for reaction %d, but no residue material was specified."), i));
                }
                material = this.getResidueMat(fDSParseRecord, string);
            }
            if ((d3 = ((Double)list.get(i)).doubleValue()) + (d2 = ((Double)list2.get(i)).doubleValue()) + (d = ((Double)list3.get(i)).doubleValue()) > 1.0) {
                this.addWarning(fDSParseRecord, Intl.intl("The total yield for a reaction must be less than or equal to 1."), Intl.intl("None"));
            }
            arrayList.add(new ReacByproducts((Double)list.get(i), (Double)list2.get(i), d4, material, (UnitDouble)list5.get(i)));
        }
        return arrayList;
    }

    private List<SolidReaction.Rate> getSolidRates(FDSParseRecord fDSParseRecord, int n) throws FDSRecordFormatException {
        List list = fDSParseRecord.getList("N_T", n, true);
        List list2 = fDSParseRecord.getList("N_S", n, true);
        List list3 = fDSParseRecord.getList("THRESHOLD_TEMPERATURE", n, true);
        List<SolidReaction.Rate.ISpecification> list4 = this.getSolidRateSpecs(fDSParseRecord, n);
        ArrayList<SolidReaction.Rate> arrayList = new ArrayList<SolidReaction.Rate>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new SolidReaction.Rate((Double)list2.get(i), (Double)list.get(i), (UnitDouble)list3.get(i), list4.get(i)));
        }
        return arrayList;
    }

    private List<SolidReaction.Rate.ISpecification> getSolidRateSpecs(FDSParseRecord fDSParseRecord, int n) throws FDSRecordFormatException {
        ArrayList<SolidReaction.Rate.ISpecification> arrayList = new ArrayList<SolidReaction.Rate.ISpecification>(n);
        List list = fDSParseRecord.getList("A", n, true);
        List list2 = fDSParseRecord.getList("E", n, false);
        List list3 = fDSParseRecord.getList("REFERENCE_TEMPERATURE", n, false);
        List list4 = fDSParseRecord.getList("HEATING_RATE", n, true);
        List list5 = fDSParseRecord.getList("PYROLYSIS_RANGE", n, true);
        for (int i = 0; i < n; ++i) {
            UnitDouble unitDouble = (UnitDouble)list2.get(i);
            if (unitDouble != null) {
                arrayList.add(new SolidReaction.Rate.AESpec((UnitDouble)list.get(i), unitDouble));
                continue;
            }
            UnitDouble unitDouble2 = (UnitDouble)list3.get(i);
            if (unitDouble2 != null) {
                arrayList.add(new SolidReaction.Rate.RefSpec(unitDouble2, (UnitDouble)list5.get(i), (UnitDouble)list4.get(i)));
                continue;
            }
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Material is missing A and E parameters for reaction %d."), i + 1));
        }
        return arrayList;
    }

    private Material getResidueMat(FDSParseRecord fDSParseRecord, String string) {
        Material material = this.getParsingInfo().findObject(Material.class, string);
        if (material == null) {
            material = new Material(string);
            this.d_matPlaceholderMap.put(string, material);
            this.d_placeholderRefMap.put(string, fDSParseRecord);
        }
        return material;
    }

    private IHeatBasedValue getRampableValue(FDSParseRecord fDSParseRecord, String string, String string2, IRampInput iRampInput, int n) throws FDSRecordFormatException {
        IHeatBasedValue iHeatBasedValue;
        String string3 = fDSParseRecord.getString(string2);
        if (string3 != null) {
            Ramp ramp = this.getParsingInfo().getRamp(string3, iRampInput, n, true);
            if (ramp == null) {
                throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Invalid ramp specified."));
            }
            iHeatBasedValue = new IHeatBasedValue.Custom(ramp);
        } else {
            UnitDouble unitDouble = fDSParseRecord.getUnitDouble(string, true);
            iHeatBasedValue = unitDouble != null ? new IHeatBasedValue.Constant(unitDouble) : null;
        }
        return iHeatBasedValue;
    }
}

