/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.VelocitySign;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class IsofParser
extends AFDS5Parser {
    public IsofParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("ISOF");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "QUANTITY", null, "SPEC_ID", null, null, null, 32, Intl.intl("ISOF ignored"), true, false);
        if (iQuantity == null) {
            return false;
        }
        Unit unit = SIUS.unit(iQuantity.get().unitType);
        List<UnitDouble> list = fDSParseRecord.getUnitDoubleList("VALUE", unit, false);
        if (list == null) {
            this.addWarning(fDSParseRecord, Intl.intl("No values specified for ISOF record."), Intl.intl("ISOF record ignored"));
            return false;
        }
        Isosurface isosurface = this.getContainer().getIsofList().getIso(iQuantity);
        if (isosurface == null) {
            isosurface = new Isosurface(iQuantity, list);
            this.getContainer().getIsofList().add(isosurface);
        } else {
            list.addAll(isosurface.getContours());
            isosurface.setContours(list);
        }
        if (iQuantity.get().equals((Object)Quantity.VELOCITY)) {
            int n = fDSParseRecord.getInteger("VELO_INDEX", true);
            VelocitySign velocitySign = this.parseVelocitySign(fDSParseRecord, n);
            isosurface.setVelocitySign(velocitySign);
        }
        this.flagObjectAdded(isosurface);
        return true;
    }
}

