/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.geom.InitRegion;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDSObjParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ExSpecParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class InitParser
extends AFDSObjParser {
    private final ExSpecParser d_exSpecs;

    public InitParser(FDS5ParsingInfo fDS5ParsingInfo, ExSpecParser exSpecParser) {
        super(fDS5ParsingInfo);
        this.d_exSpecs = exSpecParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("INIT");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Pair<String, List<Cloneable>> pair;
        Cloneable cloneable;
        AABoxGeom aABoxGeom;
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("DENSITY");
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("TEMPERATURE");
        List list = fDSParseRecord.getList("MASS_FRACTION", false);
        if (unitDouble == null && unitDouble2 == null && list == null) {
            return true;
        }
        String string = fDSParseRecord.getComment().trim();
        if (string == null || string.isEmpty()) {
            string = Intl.intl("Init Region");
        }
        if ((aABoxGeom = InitParser.parseXBGeom(fDSParseRecord, "INIT", "XB", false)) == null) {
            cloneable = new AABox();
            for (Grid grid : this.getParsingInfo().getContainer().getGridManager().flatten()) {
                ((AABox)cloneable).add(grid.getBounds());
            }
            aABoxGeom = new AABoxGeom((AABox)cloneable);
        }
        cloneable = new InitRegion(string, aABoxGeom);
        ((InitRegion)cloneable).setDensity(unitDouble);
        ((InitRegion)cloneable).setTemperature(unitDouble2);
        if (list != null) {
            pair = new IdentityHashMap(list.size());
            for (int i = 0; i < list.size(); ++i) {
                UnitDouble unitDouble3 = (UnitDouble)list.get(i);
                if (unitDouble3 == null || unitDouble3.getValueNoUnit() == 0.0) continue;
                ExSpec exSpec = this.d_exSpecs.getSpec(i);
                if (exSpec == null) {
                    String string2 = String.format(Intl.intl("Extra species %d could not be found."), i + 1);
                    String string3 = String.format(Intl.intl("Ignoring extra species %d."), i + 1);
                    this.addWarning(fDSParseRecord, string2, string3);
                    continue;
                }
                pair.put((ExSpec)exSpec, (UnitDouble)unitDouble3);
            }
            ((InitRegion)cloneable).setExtraSpecies((Map<ExSpec, UnitDouble>)((Object)pair));
        }
        pair = this.applyMult(fDSParseRecord, "MULT_ID", cloneable);
        this.addObjects((String)pair.v1, (List)pair.v2);
        return true;
    }
}

