/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.hvac.HvacAircoil;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.domain.hvac.HvacDuct;
import pyrosim.legacy_2012_1.domain.hvac.HvacFan;
import pyrosim.legacy_2012_1.domain.hvac.HvacFilter;
import pyrosim.legacy_2012_1.domain.hvac.HvacList;
import pyrosim.legacy_2012_1.domain.hvac.HvacNode;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.VentParser;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class HvacParser
extends AFDS5Parser {
    private Map<FDSParseRecord, HvacAircoil> d_aircoilMap = new HashMap<FDSParseRecord, HvacAircoil>();
    private Map<FDSParseRecord, HvacDuct> d_ductMap = new HashMap<FDSParseRecord, HvacDuct>();
    private Map<FDSParseRecord, HvacFan> d_fanMap = new HashMap<FDSParseRecord, HvacFan>();
    private Map<FDSParseRecord, HvacNode> d_nodeMap = new HashMap<FDSParseRecord, HvacNode>();
    private Map<FDSParseRecord, HvacNode> d_nodesWithVents = new HashMap<FDSParseRecord, HvacNode>();
    private Map<HvacComponent, String> d_renames = new HashMap<HvacComponent, String>();
    private PinConnParser d_pinConns;
    private VentParser d_ventParser;

    public HvacParser(FDS5ParsingInfo fDS5ParsingInfo, PinConnParser pinConnParser, VentParser ventParser) {
        super(fDS5ParsingInfo);
        this.d_pinConns = pinConnParser;
        this.d_ventParser = ventParser;
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        HvacComponent hvacComponent;
        if (System.getProperty("HVAC") == null) {
            this.addWarning(fDSParseRecord, Intl.intl("HVAC not supported"), Intl.intl("Added to Additional Records"));
            return false;
        }
        if (!fDSParseRecord.contains("TYPE_ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: Type ID missing"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: ID missing"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        HvacList hvacList = this.getContainer().getHvacList();
        String string = fDSParseRecord.getString("TYPE_ID");
        String string2 = fDSParseRecord.getString("ID");
        if (string.equals("AIRCOIL")) {
            hvacComponent = new HvacAircoil(string2);
            this.d_aircoilMap.put(fDSParseRecord, (HvacAircoil)hvacComponent);
            if (!this.parseAircoil(fDSParseRecord, hvacComponent)) {
                return false;
            }
        } else if (string.equals("DUCT")) {
            hvacComponent = new HvacDuct(string2);
            this.d_ductMap.put(fDSParseRecord, (HvacDuct)hvacComponent);
            if (!this.parseDuct(fDSParseRecord, hvacComponent)) {
                return false;
            }
        } else if (string.equals("FAN")) {
            hvacComponent = new HvacFan(string2);
            this.d_fanMap.put(fDSParseRecord, (HvacFan)hvacComponent);
            if (!this.parseFan(fDSParseRecord, hvacComponent)) {
                return false;
            }
        } else if (string.equals("FILTER")) {
            hvacComponent = new HvacFilter(string2);
            if (!this.parseFilter(fDSParseRecord, hvacComponent)) {
                return false;
            }
        } else if (string.equals("NODE")) {
            hvacComponent = new HvacNode(string2);
            this.d_nodeMap.put(fDSParseRecord, (HvacNode)hvacComponent);
            if (!this.parseNode(fDSParseRecord, hvacComponent)) {
                return false;
            }
        } else {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: Invalid type"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (hvacList.get(string2) != null) {
            String string3;
            String string4 = string3 = String.format("%s-%s", string.toLowerCase(), string2);
            int n = 0;
            while (hvacList.get(string4) != null) {
                string4 = String.format("%s-%s", string3, n);
            }
            this.addWarning(fDSParseRecord, Intl.intl("Duplicate ID in HVAC Record"), String.format(Intl.intl("HVAC record ID changed to %s."), string4));
            this.d_renames.put(hvacComponent, string4);
        }
        hvacList.add(hvacComponent);
        this.flagObjectAdded(hvacComponent);
        return true;
    }

    private boolean parseAircoil(FDSParseRecord fDSParseRecord, HvacComponent hvacComponent) {
        int n = 0;
        if (fDSParseRecord.contains("COOLANT_CP")) {
            hvacComponent.setProp("COOLANT_CP", fDSParseRecord.getUnitDouble("COOLANT_CP"));
            ++n;
        }
        if (fDSParseRecord.contains("COOLANT_MDOT")) {
            hvacComponent.setProp("COOLANT_MDOT", fDSParseRecord.getUnitDouble("COOLANT_MDOT"));
            ++n;
        }
        if (fDSParseRecord.contains("COOLANT_TEMPERATURE")) {
            hvacComponent.setProp("COOLANT_TEMPERATURE", fDSParseRecord.getUnitDouble("COOLANT_TEMPERATURE"));
            ++n;
        }
        if (fDSParseRecord.contains("EFFICIENCY")) {
            hvacComponent.setProp("EFFICIENCY", fDSParseRecord.getUnitDouble("EFFICIENCY"));
            ++n;
        }
        if (n > 0 && n < 4) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: COOLANT_CP, COOLANT_MDOT, COOLANT_TEMPERATURE, and EFFICIENTY must be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (n > 0 && fDSParseRecord.contains("FIXED_Q")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: Only one of FIXED_Q and COOLANT properies may be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (fDSParseRecord.contains("FIXED_Q")) {
            hvacComponent.setProp("FIXED_Q", fDSParseRecord.getUnitDouble("FIXED_Q"));
            hvacComponent.setProp("opt_aircoil_model", HvacAircoil.AIRCOIL_MODEL_FIXEDQ);
        }
        HvacParser.markSingleInputForRetrieval(fDSParseRecord, (HvacAircoil)hvacComponent, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return true;
    }

    private boolean parseDuct(FDSParseRecord fDSParseRecord, HvacComponent hvacComponent) {
        Object object;
        if (fDSParseRecord.contains("AIRCOIL_ID")) {
            hvacComponent.setProp("AIRCOIL_ID", fDSParseRecord.getString("AIRCOIL_ID"));
        }
        if (fDSParseRecord.contains("AREA")) {
            hvacComponent.setProp("AREA", fDSParseRecord.getUnitDouble("AREA"));
            hvacComponent.setProp("opt_area_diameter", "AREA");
        } else if (fDSParseRecord.contains("DIAMETER")) {
            hvacComponent.setProp("DIAMETER", fDSParseRecord.getUnitDouble("DIAMETER"));
            hvacComponent.setProp("opt_area_diameter", "DIAMETER");
        } else {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: Either area or diameter must be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (fDSParseRecord.contains("DAMPER") && fDSParseRecord.contains("FAN_ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: Only one of DAMPER and FAN_ID can be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (fDSParseRecord.contains("DAMPER")) {
            hvacComponent.setProp("DAMPER", fDSParseRecord.getBoolean("DAMPER"));
            hvacComponent.setProp("opt_none_damper_fan", "airflow_damper");
        } else if (fDSParseRecord.contains("FAN_ID")) {
            hvacComponent.setProp("FAN_ID", fDSParseRecord.getString("FAN_ID"));
            hvacComponent.setProp("opt_none_damper_fan", "airflow_fan");
            if (fDSParseRecord.contains("VOLUME_FLOW")) {
                this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: VOLUME_FLOW cannot be used with FAN_ID."), Intl.intl("Ignoring VOLUME_FLOW"));
            }
        } else if (fDSParseRecord.contains("VOLUME_FLOW")) {
            hvacComponent.setProp("VOLUME_FLOW", fDSParseRecord.getUnitDouble("VOLUME_FLOW"));
            hvacComponent.setProp("RAMP_ID", fDSParseRecord.getString("RAMP_ID"));
            hvacComponent.setProp("TAU_VF", fDSParseRecord.getUnitDouble("TAU_VF"));
            ((HvacDuct)hvacComponent).d_func = this.parseTimeFunction(fDSParseRecord, "TAU_VF", "RAMP_ID");
        }
        if (!fDSParseRecord.contains("VOLUME_FLOW") && fDSParseRecord.contains("TAU_VF")) {
            this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC record: TAU_VF can only be used with VOLUME_FLOW."), Intl.intl("Ignoring TAU_VF"));
        }
        if (fDSParseRecord.contains("LENGTH")) {
            hvacComponent.setProp("use_length", true);
            hvacComponent.setProp("LENGTH", fDSParseRecord.getUnitDouble("LENGTH"));
        }
        if (fDSParseRecord.contains("LOSS")) {
            object = (FDSArray)fDSParseRecord.get("LOSS");
            UnitDouble unitDouble = (UnitDouble)((FDSArray)object).get(0, 0);
            UnitDouble unitDouble2 = (UnitDouble)((FDSArray)object).get(1, 0);
            if (unitDouble != null && unitDouble2 != null) {
                hvacComponent.setProp("LOSS", Arrays.asList(unitDouble, unitDouble2));
            } else if (unitDouble != null && unitDouble2 == null) {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC entry: DUCT LOSS is a pair of real numbers."), Intl.intl("Using first entry for both values."));
                hvacComponent.setProp("LOSS", Arrays.asList(unitDouble, new UnitDouble(unitDouble.getValueNoUnit(), unitDouble.getUnit())));
            } else {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC entry: DUCT LOSS is a pair of real numbers."), Intl.intl("Using default values."));
            }
        }
        if (fDSParseRecord.contains("NODE_ID")) {
            object = fDSParseRecord.getList("NODE_ID", false);
            ((HvacDuct)hvacComponent).d_n1 = (String)object.get(0);
            ((HvacDuct)hvacComponent).d_n2 = (String)object.get(1);
        }
        if (fDSParseRecord.contains("REVERSE")) {
            hvacComponent.setProp("REVERSE", fDSParseRecord.getBoolean("REVERSE"));
        }
        if (fDSParseRecord.contains("ROUGHNESS")) {
            hvacComponent.setProp("ROUGHNESS", fDSParseRecord.getUnitDouble("ROUGHNESS"));
        }
        HvacParser.markSingleInputForRetrieval(fDSParseRecord, (HvacDuct)hvacComponent, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return true;
    }

    private boolean parseFan(FDSParseRecord fDSParseRecord, HvacComponent hvacComponent) {
        Serializable serializable;
        if (fDSParseRecord.contains("TAU_FAN")) {
            hvacComponent.setProp("TAU_FAN", fDSParseRecord.getUnitDouble("TAU_FAN"));
            ((HvacFan)hvacComponent).d_tauFunc = AFDS5Parser.parseTCurve(fDSParseRecord, "TAU_FAN");
        }
        if (fDSParseRecord.contains("LOSS")) {
            FDSArray fDSArray = (FDSArray)fDSParseRecord.get("LOSS");
            serializable = (UnitDouble)fDSArray.get(0, 0);
            if (serializable != null) {
                hvacComponent.setProp("LOSS", Arrays.asList(serializable));
            } else {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC entry: FAN LOSS"), Intl.intl("Using default."));
            }
        }
        int n = 0;
        if (fDSParseRecord.contains("VOLUME_FLOW")) {
            hvacComponent.setProp("VOLUME_FLOW", fDSParseRecord.getUnitDouble("VOLUME_FLOW"));
            hvacComponent.setProp("opt_fan_model", HvacFan.FAN_MODEL_VOLFLOW);
            ++n;
        }
        if (fDSParseRecord.contains("MAX_FLOW") && fDSParseRecord.contains("MAX_PRESSURE")) {
            hvacComponent.setProp("MAX_FLOW", fDSParseRecord.getUnitDouble("MAX_FLOW"));
            hvacComponent.setProp("MAX_PRESSURE", fDSParseRecord.getUnitDouble("MAX_PRESSURE"));
            hvacComponent.setProp("opt_fan_model", HvacFan.FAN_MODEL_QUADRATIC);
            ++n;
        }
        if (fDSParseRecord.contains("RAMP_ID")) {
            serializable = this.getParsingInfo().getRamp(fDSParseRecord.getString("RAMP_ID"), RampInputs.PRESSURE, 24, true);
            ((HvacFan)hvacComponent).d_fanRamp = serializable;
            hvacComponent.setProp("RAMP_ID", fDSParseRecord.getString("RAMP_ID"));
            hvacComponent.setProp("opt_fan_model", HvacFan.FAN_MODEL_PRESDROP);
            ++n;
        }
        if (n > 1) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC FAN record: Only one of VOLUME_FLOW, MAX_FLOW + MAX_PRESSURE, and RAMP_ID can be defined"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        return true;
    }

    private boolean parseFilter(FDSParseRecord fDSParseRecord, HvacComponent hvacComponent) {
        if (fDSParseRecord.contains("CLEAN_LOSS")) {
            hvacComponent.setProp("CLEAN_LOSS", fDSParseRecord.getUnitDouble("CLEAN_LOSS"));
        }
        if (fDSParseRecord.contains("EFFICIENCY")) {
            hvacComponent.setProp("EFFICIENCY", fDSParseRecord.getArray("EFFICIENCY", false));
        }
        if (fDSParseRecord.contains("LOADING")) {
            hvacComponent.setProp("LOADING", fDSParseRecord.getList("LOADING", false));
        }
        if (fDSParseRecord.contains("LOADING_MULTIPLIER")) {
            hvacComponent.setProp("LOADING_MULTIPLIER", fDSParseRecord.getList("LOADING_MULTIPLIER", false));
        }
        if (fDSParseRecord.contains("SPEC_ID")) {
            hvacComponent.setProp("SPEC_ID", Arrays.asList(fDSParseRecord.getString("SPEC_ID")));
        }
        if (fDSParseRecord.contains("LOSS") && fDSParseRecord.contains("RAMP_ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process HVAC record: Only one of LOSS and RAMP_ID may be specified"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (fDSParseRecord.contains("LOSS")) {
            FDSArray fDSArray = (FDSArray)fDSParseRecord.get("LOSS");
            UnitDouble unitDouble = (UnitDouble)fDSArray.get(0, 0);
            if (unitDouble != null) {
                hvacComponent.setProp("LOSS", Arrays.asList(unitDouble));
            } else {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC entry: FILTER LOSS"), Intl.intl("Using default."));
            }
            hvacComponent.setProp("opt_loss_ramp", "LOSS");
        } else if (fDSParseRecord.contains("RAMP_ID")) {
            hvacComponent.setProp("RAMP_ID", fDSParseRecord.getString("RAMP_ID"));
            hvacComponent.setProp("opt_loss_ramp", "RAMP_ID");
        }
        return true;
    }

    private boolean parseNode(FDSParseRecord fDSParseRecord, HvacComponent hvacComponent) {
        Object object;
        FDSArray<UnitDouble> fDSArray;
        if (fDSParseRecord.contains("AMBIENT")) {
            hvacComponent.setProp("AMBIENT", fDSParseRecord.getBoolean("AMBIENT"));
        }
        int n = 0;
        List list = new ArrayList();
        if (fDSParseRecord.contains("DUCT_ID")) {
            list = (List)fDSParseRecord.get("DUCT_ID");
            n = list.size();
            if (n < 10) {
                hvacComponent.setProp("DUCT_ID", list);
            } else {
                this.addWarning(fDSParseRecord, Intl.intl("List exceeds limit: DUCT_ID"), Intl.intl("Ignoring tailing entries"));
                list = list.subList(0, 9);
                hvacComponent.setProp("DUCT_ID", list);
            }
        }
        if (fDSParseRecord.contains("LOSS")) {
            fDSArray = (FDSArray<UnitDouble>)fDSParseRecord.get("LOSS");
            if (fDSArray != null) {
                object = new UnitDouble[fDSArray.getTotalLength()];
                object = fDSArray.toFlatArray((T[])object);
                hvacComponent.setProp("LOSS", Arrays.asList(object));
            } else {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC entry: NODE LOSS"), Intl.intl("Using default."));
            }
        }
        if (fDSParseRecord.contains("VENT_ID") && fDSParseRecord.contains("XYZ")) {
            this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC record: Only one of VENT_ID and XYZ may be specified"), Intl.intl("XYZ will be ignored."));
        }
        if (fDSParseRecord.contains("VENT_ID")) {
            this.d_nodesWithVents.put(fDSParseRecord, (HvacNode)hvacComponent);
            hvacComponent.setProp("opt_vent_xyz", "VENT_ID");
        } else if (fDSParseRecord.contains("XYZ")) {
            fDSArray = fDSParseRecord.getArray("XYZ", false);
            object = new UnitPoint3D(((UnitDouble)fDSArray.get(0)).getValueNoUnit(), ((UnitDouble)fDSArray.get(1)).getValueNoUnit(), ((UnitDouble)fDSArray.get(2)).getValueNoUnit(), ((UnitDouble)fDSArray.get(0)).getUnit());
            hvacComponent.setProp("XYZ", object);
            hvacComponent.setProp("opt_vent_xyz", "XYZ");
        } else {
            this.addWarning(fDSParseRecord, Intl.intl("Invalid HVAC record: NODE XYZ not specified"), Intl.intl("Using default location (0,0,0)"));
        }
        return true;
    }

    private static final <T> T findById(Map<FDSParseRecord, T> map, String string) {
        for (FDSParseRecord fDSParseRecord : map.keySet()) {
            if (!fDSParseRecord.contains("ID") || !fDSParseRecord.getString("ID").equals(string)) continue;
            return map.get(fDSParseRecord);
        }
        return null;
    }

    @Override
    public void done() {
        HvacComponent hvacComponent;
        Object object;
        Object object2;
        HvacComponent hvacComponent2;
        for (FDSParseRecord fDSParseRecord : this.d_ductMap.keySet()) {
            Object object3;
            hvacComponent2 = this.d_ductMap.get(fDSParseRecord);
            object2 = new String[]{((HvacDuct)hvacComponent2).d_n1, ((HvacDuct)hvacComponent2).d_n2};
            if (object2 != null) {
                object = HvacParser.findById(this.d_nodeMap, object2[0]);
                object3 = HvacParser.findById(this.d_nodeMap, (String)object2[1]);
                if (object == null) {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find NODE for DUCT (NODE_ID=%s)."), object), Intl.intl("Creating invalid HVAC DUCT"));
                }
                if (object3 == null) {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find NODE for DUCT (NODE_ID=%s)."), object3), Intl.intl("Creating invalid HVAC DUCT."));
                }
                hvacComponent2.setProp("NODE_ID", Arrays.asList(object, object3));
            }
            if ((object = (String)hvacComponent2.getProp("FAN_ID")) != null) {
                object3 = HvacParser.findById(this.d_fanMap, (String)object);
                if (object3 == null) {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find FAN for DUCT (FAN_ID=%s)."), object), Intl.intl("Creating invalid HVAC DUCT."));
                }
                hvacComponent2.setProp("FAN_ID", object3);
            }
            if ((object3 = (String)hvacComponent2.getProp("AIRCOIL_ID")) == null) continue;
            hvacComponent = HvacParser.findById(this.d_aircoilMap, (String)object3);
            if (hvacComponent == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find AIRCOIL for DUCT (AIRCOIL_ID=%s)."), object3), Intl.intl("Creating invalid HVAC DUCT."));
            }
            hvacComponent2.setProp("AIRCOIL_ID", hvacComponent);
        }
        for (FDSParseRecord fDSParseRecord : this.d_nodeMap.keySet()) {
            hvacComponent2 = this.d_nodeMap.get(fDSParseRecord);
            object2 = (List)hvacComponent2.getProp("DUCT_ID");
            if (object2 == null) continue;
            object = new ArrayList(10);
            for (int i = 0; i < object2.size(); ++i) {
                hvacComponent = HvacParser.findById(this.d_ductMap, (String)object2.get(i));
                if (hvacComponent == null) {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Unable to find DUCT for NODE (DUCT_ID=%s)."), object2.get(i)), Intl.intl("Missing DUCT record will be ignored."));
                }
                object.add(hvacComponent);
            }
            hvacComponent2.setProp("DUCT_ID", object);
        }
    }

    @Override
    public void postProcess() {
        Map<FDSParseRecord, Vent> map = this.d_ventParser.getVentMap();
        for (FDSParseRecord cloneable : this.d_nodesWithVents.keySet()) {
            String string;
            if (!cloneable.contains("VENT_ID") || (string = cloneable.getString("VENT_ID")) == null) continue;
            Vent vent = HvacParser.findById(map, string);
            HvacNode hvacNode = this.d_nodesWithVents.get(cloneable);
            if (vent != null) {
                hvacNode.setProp("VENT_ID", vent);
                continue;
            }
            hvacNode.setProp("VENT_ID", null);
            this.addWarning(cloneable, String.format(Intl.intl("VENT id=%s not found."), string), Intl.intl("VENT_ID will not be set."));
        }
        for (HvacComponent hvacComponent : this.d_renames.keySet()) {
            hvacComponent.setName(this.d_renames.get(hvacComponent));
        }
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("HVAC");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }
}

