/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.geom.Hole;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDSObjParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;

public class HoleParser
extends AFDSObjParser {
    private final PinConnParser d_pinConns;

    public HoleParser(FDS5ParsingInfo fDS5ParsingInfo, PinConnParser pinConnParser) {
        super(fDS5ParsingInfo);
        this.d_pinConns = pinConnParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("HOLE");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = this.generateName(fDSParseRecord, Intl.intl("Hole"));
        AABoxGeom aABoxGeom = HoleParser.parseXBGeom(fDSParseRecord, "HOLE", "XB", true);
        Hole hole = new Hole(string, aABoxGeom);
        Color color = this.parseColor(fDSParseRecord, "RGB", "COLOR", "TRANSPARENCY", false);
        if (color == INVISIBLE_COLOR) {
            hole.setVisible(false);
            hole.setColors(new Color[]{null});
        } else {
            hole.setColors(color);
        }
        hole.setEvac(this.parseEvac(fDSParseRecord, "EVACUATION", "MESH_ID"));
        HoleParser.markSingleInputForRetrieval(fDSParseRecord, hole, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        this.addObject(hole);
        return true;
    }
}

