/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class GridParser
extends AFDS5Parser {
    private final List<TempGridInfo> d_gridInfos = new ArrayList<TempGridInfo>();
    private final Map<Integer, TransformInfo> d_xformInfos = new HashMap<Integer, TransformInfo>();
    private boolean d_syncSpecifiedPerMesh = false;
    private static final String s_defGridName = "Mesh";

    public GridParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("TIME");
        set.add("MESH");
        set.add("TRNX");
        set.add("TRNY");
        set.add("TRNZ");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (fDSParseRecord.getType().equals("TIME")) {
            return this.processTimeRec(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("MESH")) {
            return this.processMeshRec(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("TRNX")) {
            return this.processTRN(fDSParseRecord, 0);
        }
        if (fDSParseRecord.getType().equals("TRNY")) {
            return this.processTRN(fDSParseRecord, 1);
        }
        if (fDSParseRecord.getType().equals("TRNZ")) {
            return this.processTRN(fDSParseRecord, 2);
        }
        assert (false);
        return false;
    }

    private boolean processTimeRec(FDSParseRecord fDSParseRecord) {
        if (fDSParseRecord.contains("SYNCHRONIZE")) {
            this.d_syncSpecifiedPerMesh = fDSParseRecord.getBoolean("SYNCHRONIZE", false) == false;
        }
        return true;
    }

    private boolean processMeshRec(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        boolean bl = (Boolean)fDSParseRecord.get("CYLINDRICAL", true);
        if (bl) {
            this.addWarning(fDSParseRecord, Intl.intl("PyroSim does not currently support cylindrical grids."), Intl.intl("Adding record to \"Additional Records\" section."));
            return false;
        }
        TempGridInfo tempGridInfo = new TempGridInfo(fDSParseRecord);
        String string = (String)fDSParseRecord.get("ID");
        if (string != null && !string.equals("")) {
            tempGridInfo.d_gridName = string;
        }
        tempGridInfo.d_fyi = fDSParseRecord.getString("FYI", false);
        tempGridInfo.d_sync = (Boolean)fDSParseRecord.get("SYNCHRONIZE", false);
        tempGridInfo.d_color = this.parseColor(fDSParseRecord, "RGB", "COLOR", "TRANSPARENCY", false);
        UnitPoint3D[] unitPoint3DArray = GridParser.parseXB(fDSParseRecord, "MESH", "XB", true);
        tempGridInfo.d_min = unitPoint3DArray[0];
        tempGridInfo.d_max = unitPoint3DArray[1];
        FDSArray fDSArray = fDSParseRecord.getArray("IJK", true);
        tempGridInfo.d_div = new int[]{(Integer)fDSArray.get(0), (Integer)fDSArray.get(1), (Integer)fDSArray.get(2)};
        tempGridInfo.d_evacuation = fDSParseRecord.getBoolean("EVACUATION");
        tempGridInfo.d_evacHumans = fDSParseRecord.getBoolean("EVAC_HUMANS");
        tempGridInfo.d_evacZOffset = fDSParseRecord.getUnitDouble("EVAC_Z_OFFSET");
        this.d_gridInfos.add(tempGridInfo);
        return true;
    }

    private boolean processTRN(FDSParseRecord fDSParseRecord, int n) throws FDSRecordFormatException {
        TRNCard tRNCard = new TRNCard(fDSParseRecord);
        int n2 = fDSParseRecord.contains("MESH_NUMBER") ? fDSParseRecord.getInteger("MESH_NUMBER") - 1 : this.d_gridInfos.size();
        int n3 = tRNCard.d_ideriv = fDSParseRecord.contains("IDERIV") ? fDSParseRecord.getInteger("IDERIV", false) : 0;
        if (!fDSParseRecord.contains("CC") || !fDSParseRecord.contains("PC")) {
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Each Mesh transformation must specify %1$s and %2$s."), "CC", "PC"));
        }
        tRNCard.cc = (UnitDouble)fDSParseRecord.get("CC", false);
        tRNCard.pc = (UnitDouble)fDSParseRecord.get("PC", false);
        TransformInfo transformInfo = this.d_xformInfos.get(n2);
        if (transformInfo == null) {
            transformInfo = new TransformInfo();
            this.d_xformInfos.put(n2, transformInfo);
        }
        transformInfo.d_trn[n].add(tRNCard);
        return true;
    }

    @Override
    public void done() throws FDSRecordFormatException {
        this.createGrids();
    }

    private void createGrids() throws FDSRecordFormatException {
        GridList gridList = this.getContainer().getGridManager();
        for (int i = 0; i < this.d_gridInfos.size(); ++i) {
            TempGridInfo tempGridInfo = this.d_gridInfos.get(i);
            TransformInfo transformInfo = this.d_xformInfos.get(i);
            Grid grid = transformInfo == null ? new Grid(tempGridInfo.d_gridName, tempGridInfo.d_min, tempGridInfo.d_max, tempGridInfo.d_div[0], tempGridInfo.d_div[1], tempGridInfo.d_div[2]) : this.createTransformedGrid(tempGridInfo, transformInfo);
            grid.setFYI(tempGridInfo.d_fyi);
            grid.setColor(tempGridInfo.d_color);
            boolean bl = true;
            if (this.d_syncSpecifiedPerMesh) {
                bl = tempGridInfo.d_sync != null ? tempGridInfo.d_sync : false;
            }
            grid.setSyncTimeStep(bl);
            if (tempGridInfo.d_evacuation != null) {
                grid.setEvacuation(tempGridInfo.d_evacuation);
            }
            if (tempGridInfo.d_evacHumans != null) {
                grid.setEvacHumans(tempGridInfo.d_evacHumans);
            }
            if (tempGridInfo.d_evacZOffset != null) {
                grid.setEvacZOffset(tempGridInfo.d_evacZOffset);
            }
            HashSet<String> hashSet = new HashSet<String>();
            Pair<String, List<Grid>> pair = this.applyMult(tempGridInfo.rec, "MULT_ID", grid);
            if (((List)pair.v2).isEmpty()) continue;
            for (Grid grid2 : (List)pair.v2) {
                Util.autoRename(gridList, grid2, hashSet);
                hashSet.add(grid2.getName());
                this.flagObjectAdded(grid);
            }
            if (((List)pair.v2).size() == 1) {
                gridList.add((IPyroObject)((List)pair.v2).get(0));
                continue;
            }
            GridList gridList2 = new GridList((String)pair.v1);
            gridList2.addAll((Collection)pair.v2);
            gridList.add(gridList2);
        }
    }

    private Grid createTransformedGrid(TempGridInfo tempGridInfo, TransformInfo transformInfo) throws FDSRecordFormatException {
        UnitDouble[][] unitDoubleArrayArray = new UnitDouble[3][];
        UnitDouble[] unitDoubleArray = new UnitDouble[]{tempGridInfo.d_min.xu(), tempGridInfo.d_min.yu(), tempGridInfo.d_min.zu()};
        UnitDouble[] unitDoubleArray2 = new UnitDouble[]{tempGridInfo.d_max.xu(), tempGridInfo.d_max.yu(), tempGridInfo.d_max.zu()};
        for (int i = 0; i < 3; ++i) {
            unitDoubleArrayArray[i] = !transformInfo.d_trn[i].isEmpty() ? this.applyTransform(transformInfo.d_trn[i], tempGridInfo.d_div[i], unitDoubleArray[i], unitDoubleArray2[i]) : Grid.makeUniformDivisions(tempGridInfo.d_div[i], unitDoubleArray[i], unitDoubleArray2[i]);
        }
        return new Grid(tempGridInfo.d_gridName, tempGridInfo.d_min, tempGridInfo.d_max, unitDoubleArrayArray[0], unitDoubleArrayArray[1], unitDoubleArrayArray[2]);
    }

    private UnitDouble[] applyTransform(List<TRNCard> list, int n, UnitDouble unitDouble, UnitDouble unitDouble2) throws FDSRecordFormatException {
        BaseUnit baseUnit = SI.METER;
        UnitDouble unitDouble3 = null;
        UnitDouble unitDouble4 = null;
        for (TRNCard tRNCard : list) {
            if (tRNCard.d_ideriv != 0) {
                this.addWarning(tRNCard.d_rec, Intl.intl("PyroSim only supports piece-wise linear mesh transformations."), Intl.intl("Treating transformation as a piece-wise linear coordinate."));
            }
            if (tRNCard.cc.compareTo(unitDouble) < 0 || tRNCard.cc.compareTo(unitDouble2) > 0 || tRNCard.pc.compareTo(unitDouble) < 0 || tRNCard.pc.compareTo(unitDouble2) > 0) {
                throw new FDSRecordFormatException(tRNCard.d_rec, String.format(Intl.intl("%1$s and %2$s must be between %3$g and %4$g inclusive."), "CC", "PC", unitDouble.getValue(baseUnit), unitDouble2.getValue(baseUnit)));
            }
            if (unitDouble3 != null && tRNCard.cc.compareTo(unitDouble3) <= 0 || unitDouble4 != null && tRNCard.pc.compareTo(unitDouble4) <= 0) {
                throw new FDSRecordFormatException(tRNCard.d_rec, String.format(Intl.intl("%1$s and %2$s must be specified in increasing order."), new Object[0]));
            }
            unitDouble3 = tRNCard.cc;
            unitDouble4 = tRNCard.pc;
        }
        Object[] objectArray = new UnitDouble[n];
        int n2 = 0;
        double d = unitDouble.getValue(baseUnit);
        double d2 = unitDouble2.getValue(baseUnit);
        double d3 = d;
        double d4 = d;
        double d5 = (double)n / (d2 - d);
        for (TRNCard tRNCard : list) {
            double d6 = tRNCard.cc.getValue(baseUnit);
            double d7 = tRNCard.pc.getValue(baseUnit);
            int n3 = (int)Math.round((d6 - d4) * d5);
            double d8 = (d7 - d3) / (double)n3;
            Arrays.fill(objectArray, n2, n2 + n3, new UnitDouble(d8, baseUnit));
            d3 = d7;
            d4 = d6;
            n2 += n3;
        }
        int n4 = n - n2;
        double d9 = (d2 - d3) / (double)n4;
        Arrays.fill(objectArray, n2, n2 + n4, new UnitDouble(d9, baseUnit));
        return objectArray;
    }

    private static class TRNCard {
        public final FDSParseRecord d_rec;
        public int d_ideriv;
        public UnitDouble cc;
        public UnitDouble pc;

        public TRNCard(FDSParseRecord fDSParseRecord) {
            this.d_rec = fDSParseRecord;
        }
    }

    private static class TransformInfo {
        public List<TRNCard>[] d_trn = new ArrayList[3];

        public TransformInfo() {
            this.d_trn[0] = new ArrayList<TRNCard>();
            this.d_trn[1] = new ArrayList<TRNCard>();
            this.d_trn[2] = new ArrayList<TRNCard>();
        }
    }

    private static class TempGridInfo {
        public final FDSParseRecord rec;
        public String d_gridName;
        public String d_fyi;
        public Boolean d_sync;
        public Color d_color;
        public UnitPoint3D d_min;
        public UnitPoint3D d_max;
        public int[] d_div;
        public Boolean d_evacuation;
        public Boolean d_evacHumans;
        public UnitDouble d_evacZOffset;

        public TempGridInfo(FDSParseRecord fDSParseRecord) {
            this.rec = fDSParseRecord;
            this.d_gridName = GridParser.s_defGridName;
        }
    }
}

