/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.controls.Util;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.io.fds.FDSParseException;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParser;
import pyrosim.legacy_2012_1.io.fds.FDSParsingInfo;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.FDSRecordSpec;
import pyrosim.legacy_2012_1.io.fds.IFDSRecordParser;
import pyrosim.legacy_2012_1.io.fds.v5.FDS5Const;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.BoundaryParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ControlParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.CorrParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.DeviceParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.DoorParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.EntrParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.EvacParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.EvhoParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.EvssParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ExSpecParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ExitParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.GridParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.HoleParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.HvacParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.InitParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.IsofParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.MaterialParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.MultParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ObstParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PartCloudParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ParticleParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PersParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnFinisher;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.Plot3dParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ProfParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PropParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.RampFinisher;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.RampParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ReactionParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.SimParamsParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.SliceParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.StatisticsParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.SurfaceParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.TableParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.VentParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ZoneParser;

public class FDS5Parser
extends FDSParser {
    @Override
    protected List<? extends IFDSRecordParser> createParsers(FDSParsingInfo fDSParsingInfo) {
        FDS5ParsingInfo fDS5ParsingInfo = (FDS5ParsingInfo)fDSParsingInfo;
        ExSpecParser exSpecParser = new ExSpecParser(fDS5ParsingInfo);
        PinConnParser pinConnParser = new PinConnParser(fDS5ParsingInfo);
        ControlParser controlParser = new ControlParser(fDS5ParsingInfo, pinConnParser);
        PropParser propParser = new PropParser(fDS5ParsingInfo);
        ZoneParser zoneParser = new ZoneParser(fDS5ParsingInfo);
        SimParamsParser simParamsParser = new SimParamsParser(fDS5ParsingInfo);
        VentParser ventParser = new VentParser(fDS5ParsingInfo, pinConnParser, exSpecParser);
        return Arrays.asList(new MultParser(fDS5ParsingInfo), new GridParser(fDS5ParsingInfo), zoneParser, new RampParser(fDS5ParsingInfo), new TableParser(fDS5ParsingInfo), exSpecParser, new InitParser(fDS5ParsingInfo, exSpecParser), new ParticleParser(fDS5ParsingInfo, pinConnParser), new PartCloudParser(fDS5ParsingInfo), new MaterialParser(fDS5ParsingInfo), new SurfaceParser(fDS5ParsingInfo, exSpecParser, zoneParser), new ReactionParser(fDS5ParsingInfo), new HvacParser(fDS5ParsingInfo, pinConnParser, ventParser), controlParser, propParser, new DeviceParser(fDS5ParsingInfo, pinConnParser, propParser), simParamsParser, new ObstParser(fDS5ParsingInfo, pinConnParser, simParamsParser), new HoleParser(fDS5ParsingInfo, pinConnParser), ventParser, new ProfParser(fDS5ParsingInfo), new IsofParser(fDS5ParsingInfo), new Plot3dParser(fDS5ParsingInfo), new BoundaryParser(fDS5ParsingInfo, propParser), new SliceParser(fDS5ParsingInfo), new StatisticsParser(fDS5ParsingInfo), new PersParser(fDS5ParsingInfo), new EvssParser(fDS5ParsingInfo), new ExitParser(fDS5ParsingInfo), new EntrParser(fDS5ParsingInfo), new CorrParser(fDS5ParsingInfo), new DoorParser(fDS5ParsingInfo), new EvacParser(fDS5ParsingInfo), new EvhoParser(fDS5ParsingInfo), pinConnParser, new PinConnFinisher(fDS5ParsingInfo, pinConnParser, controlParser), new RampFinisher(fDS5ParsingInfo, pinConnParser), new TailParser());
    }

    @Override
    protected FDSParsingInfo createParsingInfo(String string, PyroMod pyroMod, PyroMod pyroMod2) {
        return new FDS5ParsingInfo(string, pyroMod, pyroMod2);
    }

    @Override
    protected Map<String, FDSRecordSpec> getRecordSpecs() {
        return FDS5Const.getRecordSpecs();
    }

    @Override
    protected String getFinishRecType() {
        return "TAIL";
    }

    @Override
    protected void parseRecords(List<FDSParseRecord> list, String string, FDSParsingInfo fDSParsingInfo) throws IOException, FDSParseException {
        super.parseRecords(list, string, fDSParsingInfo);
        for (IPyroObject iPyroObject : fDSParsingInfo.getParseResult().extractedObjs) {
            if (!(iPyroObject instanceof ISignalSink)) continue;
            Util.deleteNoops(((ISignalSink)iPyroObject).getInputPin());
        }
    }

    private static class TailParser
    implements IFDSRecordParser {
        private TailParser() {
        }

        @Override
        public void getRecordTypes(Set<String> set) {
            set.add("TAIL");
        }

        @Override
        public void process(Collection<FDSParseRecord> collection, Collection<FDSParseRecord> collection2) throws FDSRecordFormatException {
        }

        @Override
        public void getUnsupportedFields(String string, Set<String> set) {
        }

        @Override
        public void postProcess() {
        }
    }
}

