/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.io.Serializable;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.evac.Exit;
import pyrosim.legacy_2012_1.domain.evac.ExitList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class ExitParser
extends AFDS5Parser {
    public ExitParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Serializable serializable;
        String string;
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process EXIT record: ID missing"), Intl.intl("EXIT Record Ignored"));
            return false;
        }
        ExitList exitList = this.getContainer().getExitList();
        if (exitList.get(string = fDSParseRecord.getString("ID")) != null) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process EXIT record: Duplicate ID"), Intl.intl("EXIT Record Ignored"));
            return false;
        }
        Exit exit = new Exit(string);
        exit.setProp("FYI", fDSParseRecord.get("FYI"));
        if (fDSParseRecord.contains("XB")) {
            serializable = fDSParseRecord.getArray("XB", false);
            exit.setProp("XB", ((FDSArray)serializable).toFlatArray(new UnitDouble[((FDSArray)serializable).getTotalLength()]));
        }
        if (fDSParseRecord.contains("XYZ")) {
            serializable = fDSParseRecord.getArray("XYZ", false);
            exit.setProp("XYZ", ((FDSArray)serializable).toFlatArray(new UnitDouble[((FDSArray)serializable).getTotalLength()]));
        }
        exit.setProp("IOR", fDSParseRecord.get("IOR"));
        exit.setProp("COUNT_ONLY", fDSParseRecord.get("COUNT_ONLY"));
        serializable = this.getContainer().getGridManager();
        if (fDSParseRecord.contains("MESH_ID")) {
            exit.setProp("MESH_ID", ((Composite)serializable).get(fDSParseRecord.getString("MESH_ID")));
        }
        if (fDSParseRecord.contains("VENT_FFIELD")) {
            exit.setProp("VENT_FFIELD", ((Composite)serializable).get(fDSParseRecord.getString("VENT_FFIELD")));
        }
        if (fDSParseRecord.contains("FLOW_FIELD_ID")) {
            exit.setProp("FLOW_FIELD_ID", ((Composite)serializable).get(fDSParseRecord.getString("FLOW_FIELD_ID")));
        }
        exit.setProp("RGB", this.parseColor(fDSParseRecord, "RGB", "COLOR", null, false));
        exit.setProp("TIME_OPEN", fDSParseRecord.get("TIME_OPEN"));
        exit.setProp("TIME_CLOSE", fDSParseRecord.get("TIME_CLOSE"));
        exitList.add(exit);
        this.flagObjectAdded(exit);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("EXIT");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }
}

