/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class ExSpecParser
extends AFDS5Parser {
    private int d_specIx = 0;
    private final List<ExSpec> d_parsedSpecs = new ArrayList<ExSpec>();

    public ExSpecParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("SPEC");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    public ExSpec getSpec(int n) {
        if (n >= this.d_parsedSpecs.size()) {
            return null;
        }
        return this.d_parsedSpecs.get(n);
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process SPEC record: ID missing"), Intl.intl("SPEC Record Ignored"));
            return false;
        }
        ExSpecList exSpecList = this.getContainer().getExSpecList();
        String string = fDSParseRecord.getString("ID");
        boolean bl = ExSpecList.isPredefinedSpecies(string);
        if (exSpecList.get(string) != null) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process SPEC record: Duplicate ID"), Intl.intl("SPEC Record Ignored"));
            return false;
        }
        ExSpec exSpec = bl ? new ExSpec(ExSpecList.getPredefinedSpecies(string)) : new ExSpec(string, false);
        exSpec.setFYI(fDSParseRecord.getString("FYI", false));
        if (fDSParseRecord.contains("MASS_FRACTION_0")) {
            exSpec.setMassFraction0(fDSParseRecord.getDouble("MASS_FRACTION_0"));
        }
        if (bl) {
            this.addSpec(exSpec);
            return true;
        }
        if (fDSParseRecord.contains("MW")) {
            exSpec.setMolWt(fDSParseRecord.getUnitDouble("MW"));
        }
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("MASS_EXTINCTION_COEFFICIENT", true);
        exSpec.setMassExtinctionCoeff(unitDouble);
        if (!(!fDSParseRecord.contains("SIGMALJ") && !fDSParseRecord.contains("EPSILONKLJ") || fDSParseRecord.contains("SIGMALJ") && fDSParseRecord.contains("EPSILONKLJ"))) {
            this.addWarning(fDSParseRecord, Intl.intl("Incorrect specification of Leonard-Jones DNS parameters"), Intl.intl("DNS Parameters Ignored"));
        }
        if (fDSParseRecord.contains("SIGMALJ") && fDSParseRecord.contains("EPSILONKLJ")) {
            exSpec.setDNSLJ(fDSParseRecord.getUnitDouble("SIGMALJ"), fDSParseRecord.getUnitDouble("EPSILONKLJ"));
        }
        if (!(!fDSParseRecord.contains("VISCOSITY") && !fDSParseRecord.contains("CONDUCTIVITY") && !fDSParseRecord.contains("DIFFUSIVITY") || fDSParseRecord.contains("VISCOSITY") && fDSParseRecord.contains("CONDUCTIVITY") && fDSParseRecord.contains("DIFFUSIVITY"))) {
            this.addWarning(fDSParseRecord, Intl.intl("Incorrect specification of DNS parameters."), Intl.intl("DNS Parameters Ignored"));
        }
        if (fDSParseRecord.contains("VISCOSITY") && fDSParseRecord.contains("CONDUCTIVITY") && fDSParseRecord.contains("DIFFUSIVITY")) {
            exSpec.setDNSAlt(fDSParseRecord.getUnitDouble("VISCOSITY"), fDSParseRecord.getUnitDouble("CONDUCTIVITY"), fDSParseRecord.getUnitDouble("DIFFUSIVITY"));
        }
        if (fDSParseRecord.contains("ABSORBING")) {
            exSpec.setAbsorb(fDSParseRecord.getBoolean("ABSORBING"));
        }
        this.addSpec(exSpec);
        return true;
    }

    private void addSpec(ExSpec exSpec) {
        ExSpecList exSpecList = this.getContainer().getExSpecList();
        exSpecList.add(exSpec);
        this.flagObjectAdded(exSpec);
        this.d_parsedSpecs.add(exSpec);
    }
}

