/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.evac.Evss;
import pyrosim.legacy_2012_1.domain.evac.EvssList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class EvssParser
extends AFDS5Parser {
    public EvssParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Object object;
        String string;
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process EVSS record: ID missing"), Intl.intl("EVSS Record Ignored"));
            return false;
        }
        EvssList evssList = this.getContainer().getEvssList();
        if (evssList.get(string = fDSParseRecord.getString("ID")) != null) {
            int n = 1;
            object = string;
            while (evssList.get(string = String.format("%s[%d]", object, n)) != null) {
            }
            this.addWarning(fDSParseRecord, Intl.intl("Invalid EVSS record: Duplicate ID"), String.format(Intl.intl("ID changed from \"%s\"to \"%s\""), object, string));
        }
        GridList gridList = this.getContainer().getGridManager();
        object = new Evss(string);
        ((Evss)object).setProp("FYI", fDSParseRecord.get("FYI"));
        if (fDSParseRecord.contains("XB")) {
            FDSArray<UnitDouble> fDSArray = fDSParseRecord.getArray("XB", false);
            ((Evss)object).setProp("XB", fDSArray.toFlatArray(new UnitDouble[fDSArray.getTotalLength()]));
        }
        ((Evss)object).setProp("IOR", fDSParseRecord.get("IOR", true));
        if (fDSParseRecord.contains("MESH_ID")) {
            ((Evss)object).setProp("MESH_ID", gridList.get(fDSParseRecord.getString("MESH_ID")));
        }
        ((Evss)object).setProp("HEIGHT", fDSParseRecord.get("HEIGHT", true));
        ((Evss)object).setProp("HEIGHT0", fDSParseRecord.get("HEIGHT0", true));
        ((Evss)object).setProp("FAC_V0_UP", fDSParseRecord.get("FAC_V0_UP", true));
        ((Evss)object).setProp("FAC_V0_DOWN", fDSParseRecord.get("FAC_V0_DOWN", true));
        ((Evss)object).setProp("FAC_V0_HORI", fDSParseRecord.get("FAC_V0_HORI", true));
        ((Evss)object).setProp("ESC_SPEED", fDSParseRecord.get("ESC_SPEED", true));
        evssList.add((IPyroObject)object);
        this.flagObjectAdded((IPyroObject)object);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("EVSS");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }
}

