/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.evac.EvacList;
import pyrosim.legacy_2012_1.domain.evac.Evho;
import pyrosim.legacy_2012_1.domain.evac.EvhoList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class EvhoParser
extends AFDS5Parser {
    public EvhoParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Object object;
        String string;
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process EVHO record: ID missing"), Intl.intl("EVHO Record Ignored"));
            return false;
        }
        EvhoList evhoList = this.getContainer().getEvhoList();
        if (evhoList.get(string = fDSParseRecord.getString("ID")) != null) {
            int n = 1;
            object = string;
            while (evhoList.get(string = String.format("%s[%d]", object, n)) != null) {
            }
            this.addWarning(fDSParseRecord, Intl.intl("Invalid EVHO record: Duplicate ID"), String.format(Intl.intl("ID changed from \"%s\"to \"%s\""), object, string));
        }
        GridList gridList = this.getContainer().getGridManager();
        object = this.getContainer().getPersList();
        EvacList evacList = this.getContainer().getEvacList();
        Evho evho = new Evho(string);
        evho.setProp("FYI", fDSParseRecord.get("FYI"));
        if (fDSParseRecord.contains("XB")) {
            FDSArray<UnitDouble> fDSArray = fDSParseRecord.getArray("XB", false);
            evho.setProp("XB", fDSArray.toFlatArray(new UnitDouble[fDSArray.getTotalLength()]));
        }
        if (fDSParseRecord.contains("MESH_ID")) {
            evho.setProp("MESH_ID", gridList.get(fDSParseRecord.getString("MESH_ID")));
        }
        if (fDSParseRecord.contains("PERS_ID")) {
            evho.setProp("PERS_ID", ((Composite)object).get(fDSParseRecord.getString("PERS_ID")));
        }
        if (fDSParseRecord.contains("EVAC_ID")) {
            evho.setProp("EVAC_ID", evacList.get(fDSParseRecord.getString("EVAC_ID")));
        }
        evhoList.add(evho);
        this.flagObjectAdded(evho);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("EVHO");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }
}

