/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.evac.DoorList;
import pyrosim.legacy_2012_1.domain.evac.Evac;
import pyrosim.legacy_2012_1.domain.evac.EvacList;
import pyrosim.legacy_2012_1.domain.evac.ExitList;
import pyrosim.legacy_2012_1.domain.evac.Pers;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class EvacParser
extends AFDS5Parser {
    public EvacParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Object object;
        Object object2;
        String string;
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process EVAC record: ID missing"), Intl.intl("EVAC Record Ignored"));
            return false;
        }
        EvacList evacList = this.getContainer().getEvacList();
        if (evacList.get(string = fDSParseRecord.getString("ID")) != null) {
            int n = 1;
            object2 = string;
            while (evacList.get(string = String.format("%s[%d]", object2, n)) != null) {
            }
            this.addWarning(fDSParseRecord, Intl.intl("Invalid EVAC record: Duplicate ID"), String.format(Intl.intl("ID changed from \"%s\"to \"%s\""), object2, string));
        }
        GridList gridList = this.getContainer().getGridManager();
        object2 = this.getContainer().getPersList();
        Pers pers = fDSParseRecord.contains("PERS_ID") ? (Pers)((Composite)object2).get(fDSParseRecord.getString("PERS_ID")) : null;
        Evac evac = new Evac(string, pers);
        evac.setProp("FYI", fDSParseRecord.get("FYI"));
        if (fDSParseRecord.contains("XB")) {
            object = fDSParseRecord.getArray("XB", false);
            evac.setProp("XB", ((FDSArray)object).toFlatArray(new UnitDouble[((FDSArray)object).getTotalLength()]));
        }
        if (fDSParseRecord.contains("MESH_ID")) {
            evac.setProp("MESH_ID", gridList.get(fDSParseRecord.getString("MESH_ID")));
        }
        evac.setProp("NUMBER_INITIAL_PERSONS", fDSParseRecord.get("NUMBER_INITIAL_PERSONS"));
        if (fDSParseRecord.contains("PERS_ID")) {
            evac.setProp("PERS_ID", ((Composite)object2).get(fDSParseRecord.getString("PERS_ID")));
        }
        evac.setProp("ANGLE", fDSParseRecord.get("ANGLE"));
        evac.setProp("AVATAR_RGB", this.parseColor(fDSParseRecord, "AVATAR_RGB", "AVATAR_COLOR", null, false));
        if (fDSParseRecord.contains("FLOW_FIELD_ID")) {
            evac.setProp("FLOW_FIELD_ID", gridList.get(fDSParseRecord.getString("FLOW_FIELD_ID")));
        }
        object = fDSParseRecord.getList("KNOWN_DOOR_NAMES", false);
        List list = fDSParseRecord.getList("KNOWN_DOOR_PROBS", false);
        if (object != null && !object.isEmpty()) {
            if (object.size() != list.size()) {
                this.addWarning(fDSParseRecord, Intl.intl("List length mismatch: KNOWN_DOOR_NAMES, KNOWN_DOOR_PROBS"), Intl.intl("Ignoring tailing entries."));
            }
            ExitList exitList = this.getContainer().getExitList();
            DoorList doorList = this.getContainer().getDoorList();
            HashMap hashMap = new HashMap();
            int n = Math.min(object.size(), list.size());
            for (int i = 0; i < n; ++i) {
                String string2 = (String)object.get(i);
                NamedPyroObject namedPyroObject = null;
                if (namedPyroObject == null) {
                    namedPyroObject = (NamedPyroObject)exitList.get(string2);
                }
                if (namedPyroObject == null) {
                    namedPyroObject = (NamedPyroObject)doorList.get(string2);
                }
                if (namedPyroObject == null) {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Invalid EVAC record: Unknown door \"%s\""), string2), Intl.intl("EVAC Record Ignored"));
                    return false;
                }
                hashMap.put(namedPyroObject, list.get(i));
            }
            evac.setProp("KNOWN_DOOR_PROBS", hashMap);
        }
        evacList.add(evac);
        this.flagObjectAdded(evac);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("EVAC");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }
}

