/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.evac.DoorList;
import pyrosim.legacy_2012_1.domain.evac.Entr;
import pyrosim.legacy_2012_1.domain.evac.EntrList;
import pyrosim.legacy_2012_1.domain.evac.ExitList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class EntrParser
extends AFDS5Parser {
    public EntrParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Object object;
        Object object2;
        String string;
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process ENTR record: ID missing"), Intl.intl("ENTR Record Ignored"));
            return false;
        }
        EntrList entrList = this.getContainer().getEntrList();
        if (entrList.get(string = fDSParseRecord.getString("ID")) != null) {
            int n = 1;
            object2 = string;
            while (entrList.get(string = String.format("%s[%d]", object2, n)) != null) {
            }
            this.addWarning(fDSParseRecord, Intl.intl("Invalid ENTR record: Duplicate ID"), String.format(Intl.intl("ID changed from \"%s\"to \"%s\""), object2, string));
        }
        GridList gridList = this.getContainer().getGridManager();
        object2 = this.getContainer().getPersList();
        Entr entr = new Entr(string);
        entr.setProp("FYI", fDSParseRecord.get("FYI"));
        if (fDSParseRecord.contains("XB")) {
            object = fDSParseRecord.getArray("XB", false);
            entr.setProp("XB", ((FDSArray)object).toFlatArray(new UnitDouble[((FDSArray)object).getTotalLength()]));
        }
        if (fDSParseRecord.contains("MESH_ID")) {
            entr.setProp("MESH_ID", gridList.get(fDSParseRecord.getString("MESH_ID")));
        }
        entr.setProp("IOR", fDSParseRecord.get("IOR", true));
        entr.setProp("MAX_FLOW", fDSParseRecord.get("MAX_FLOW", true));
        entr.setProp("MAX_HUMANS", fDSParseRecord.get("MAX_HUMANS", true));
        entr.setProp("TIME_START", fDSParseRecord.get("TIME_START", true));
        entr.setProp("TIME_STOP", fDSParseRecord.get("TIME_STOP", true));
        if (fDSParseRecord.contains("PERS_ID")) {
            entr.setProp("PERS_ID", ((Composite)object2).get(fDSParseRecord.getString("PERS_ID")));
        }
        entr.setProp("AVATAR_RGB", this.parseColor(fDSParseRecord, "AVATAR_RGB", "AVATAR_COLOR", null, false));
        if (fDSParseRecord.contains("FLOW_FIELD_ID")) {
            entr.setProp("FLOW_FIELD_ID", gridList.get(fDSParseRecord.getString("FLOW_FIELD_ID")));
        }
        object = fDSParseRecord.getList("KNOWN_DOOR_NAMES", false);
        List list = fDSParseRecord.getList("KNOWN_DOOR_PROBS", false);
        if (object != null && !object.isEmpty()) {
            if (object.size() != list.size()) {
                this.addWarning(fDSParseRecord, Intl.intl("List length mismatch: KNOWN_DOOR_NAMES, KNOWN_DOOR_PROBS"), Intl.intl("Ignoring tailing entries."));
            }
            ExitList exitList = this.getContainer().getExitList();
            DoorList doorList = this.getContainer().getDoorList();
            HashMap hashMap = new HashMap();
            int n = Math.min(object.size(), list.size());
            for (int i = 0; i < n; ++i) {
                String string2 = (String)object.get(i);
                NamedPyroObject namedPyroObject = null;
                if (namedPyroObject == null) {
                    namedPyroObject = (NamedPyroObject)exitList.get(string2);
                }
                if (namedPyroObject == null) {
                    namedPyroObject = (NamedPyroObject)doorList.get(string2);
                }
                if (namedPyroObject == null) {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Invalid ENTR record: Unknown door \"%s\""), string2), Intl.intl("ENTR Record Ignored"));
                    return false;
                }
                hashMap.put(namedPyroObject, list.get(i));
            }
            entr.setProp("KNOWN_DOOR_PROBS", hashMap);
        }
        entrList.add(entr);
        this.flagObjectAdded(entr);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("ENTR");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }
}

