/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.io.Serializable;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.evac.Door;
import pyrosim.legacy_2012_1.domain.evac.DoorList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class DoorParser
extends AFDS5Parser {
    public DoorParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Serializable serializable;
        String string;
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process DOOR record: ID missing"), Intl.intl("DOOR Record Ignored"));
            return false;
        }
        DoorList doorList = this.getContainer().getDoorList();
        if (doorList.get(string = fDSParseRecord.getString("ID")) != null) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process DOOR record: Duplicate ID"), Intl.intl("DOOR Record Ignored"));
            return false;
        }
        Door door = new Door(string);
        door.setProp("FYI", fDSParseRecord.get("FYI"));
        if (fDSParseRecord.contains("XB")) {
            serializable = fDSParseRecord.getArray("XB", false);
            door.setProp("XB", ((FDSArray)serializable).toFlatArray(new UnitDouble[((FDSArray)serializable).getTotalLength()]));
        }
        if (fDSParseRecord.contains("XYZ")) {
            serializable = fDSParseRecord.getArray("XYZ", false);
            door.setProp("XYZ", ((FDSArray)serializable).toFlatArray(new UnitDouble[((FDSArray)serializable).getTotalLength()]));
        }
        serializable = this.getContainer().getGridManager();
        if (fDSParseRecord.contains("MESH_ID")) {
            door.setProp("MESH_ID", ((Composite)serializable).get(fDSParseRecord.getString("MESH_ID")));
        }
        door.setProp("IOR", fDSParseRecord.get("IOR", true));
        if (fDSParseRecord.contains("TO_NODE")) {
            String string2 = fDSParseRecord.getString("TO_NODE");
            NamedPyroObject namedPyroObject = null;
            if (namedPyroObject == null) {
                namedPyroObject = (NamedPyroObject)this.getContainer().getDoorList().get(string2);
            }
            if (namedPyroObject == null) {
                namedPyroObject = (NamedPyroObject)this.getContainer().getExitList().get(string2);
            }
            if (namedPyroObject == null) {
                namedPyroObject = (NamedPyroObject)this.getContainer().getCorrList().get(string2);
            }
            if (namedPyroObject == null) {
                namedPyroObject = (NamedPyroObject)this.getContainer().getEntrList().get(string2);
            }
            if (namedPyroObject != null) {
                door.setProp("TO_NODE", namedPyroObject);
            } else {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Invalid DOOR record: Unknown TO_NODE \"%s\""), string2), Intl.intl("TO_NODE record dropped."));
            }
        }
        door.setProp("EXIT_SIGN", fDSParseRecord.get("EXIT_SIGN", true));
        door.setProp("KEEP_XY", fDSParseRecord.get("KEEP_XY", true));
        if (fDSParseRecord.contains("VENT_FFIELD")) {
            door.setProp("VENT_FFIELD", ((Composite)serializable).get(fDSParseRecord.getString("VENT_FFIELD")));
        }
        if (fDSParseRecord.contains("FLOW_FIELD_ID")) {
            door.setProp("FLOW_FIELD_ID", ((Composite)serializable).get(fDSParseRecord.getString("FLOW_FIELD_ID")));
        }
        door.setProp("RGB", this.parseColor(fDSParseRecord, "RGB", "COLOR", null, false));
        door.setProp("TIME_OPEN", fDSParseRecord.get("TIME_OPEN"));
        door.setProp("TIME_CLOSE", fDSParseRecord.get("TIME_CLOSE"));
        doorList.add(door);
        this.flagObjectAdded(door);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("DOOR");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }
}

