/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.controls.LatchCtrl;
import pyrosim.legacy_2012_1.domain.controls.NotOp;
import pyrosim.legacy_2012_1.domain.devices.AlarmInfo;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.TripFlags;
import pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator;
import pyrosim.legacy_2012_1.domain.devices.aspiration.AspiratorSampler;
import pyrosim.legacy_2012_1.domain.devices.detectors.CableFailDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.IDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLink;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.Timer;
import pyrosim.legacy_2012_1.domain.devices.hvac.HvacDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.AABoxMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.Clock;
import pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple;
import pyrosim.legacy_2012_1.domain.devices.sprayers.ASprayer;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Nozzle;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Sprinkler;
import pyrosim.legacy_2012_1.domain.geom.AttachedPointLoc;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.hvac.HvacDuct;
import pyrosim.legacy_2012_1.domain.hvac.HvacNode;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.signals.IDoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.common.GeomUtil;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PropParser;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitLineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class DeviceParser
extends AFDS5Parser {
    private final PinConnParser d_pinConns;
    private final PropParser d_propParser;
    private final List<FDSParseRecord> d_aspSamplerRecs = new ArrayList<FDSParseRecord>();

    public DeviceParser(FDS5ParsingInfo fDS5ParsingInfo, PinConnParser pinConnParser, PropParser propParser) {
        super(fDS5ParsingInfo);
        this.d_pinConns = pinConnParser;
        this.d_propParser = propParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("DEVC");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        return this.processDevc(fDSParseRecord);
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        for (FDSParseRecord fDSParseRecord : this.d_aspSamplerRecs) {
            String string = (String)fDSParseRecord.get("DEVC_ID");
            if (string == null) continue;
            String string2 = (String)fDSParseRecord.get("ID");
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("FLOWRATE", true);
            UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("DELAY", true);
            AspiratorSampler aspiratorSampler = (AspiratorSampler)this.getContainer().getDevices().get(string2);
            Aspirator aspirator = (Aspirator)this.getContainer().getDevices().get(string);
            if (aspirator == null) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Could not find aspirator: %s"), string));
            }
            aspirator.setSamplerLine(new Aspirator.SamplerLine(aspiratorSampler, unitDouble, unitDouble2));
        }
    }

    private IQuantity parseQuantity(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, boolean bl, boolean bl2) throws FDSRecordFormatException {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        FDSParseRecord fDSParseRecord3 = fDSParseRecord;
        String string8 = (String)fDSParseRecord.get("QUANTITY", false);
        if (string8 == null) {
            fDSParseRecord3 = fDSParseRecord2;
            string8 = (String)fDSParseRecord2.get("QUANTITY", false);
            if (string8 == null) {
                return null;
            }
        }
        if (fDSParseRecord3.getType().equals("DEVC")) {
            string7 = "QUANTITY";
            string6 = "PART_ID";
            string5 = "SPEC_ID";
            string4 = "MATL_ID";
            string3 = "DUCT_ID";
            string2 = "NODE_ID";
        } else {
            string7 = "QUANTITY";
            string6 = "PART_ID";
            string5 = "SPEC_ID";
            string4 = null;
            string3 = null;
            string2 = null;
        }
        return this.parseQuantity(fDSParseRecord3, string7, string6, string5, string4, string3, string2, 0, string, bl, bl2);
    }

    protected boolean processDevc(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Object object;
        Object object2;
        FDSParseRecord fDSParseRecord2;
        String string;
        String string2 = (String)fDSParseRecord.get("STATISTICS", false);
        if (string2 != null) {
            return true;
        }
        boolean bl = false;
        String string3 = (String)fDSParseRecord.get("ID");
        if (string3 == null || string3.trim().equals("")) {
            string3 = Util.getUniqueName(this.getContainer().getDevices(), Intl.intl("DEVC"));
            bl = true;
        }
        if ((string = (String)fDSParseRecord.get("PROP_ID")) == null) {
            fDSParseRecord2 = PropParser.getDefaultProp();
        } else {
            fDSParseRecord2 = this.d_propParser.getProp(string);
            if (fDSParseRecord2 == null) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("PROP record, %s, could not be found."), string));
            }
        }
        String string4 = (String)fDSParseRecord.get("QUANTITY", false);
        if (string4 == null && (string4 = (String)fDSParseRecord2.get("QUANTITY", false)) == null) {
            this.addWarning(fDSParseRecord, Intl.intl("The device type could not be determined from the DEVC or PROP record."), Intl.intl("Adding device to additional records section."));
            return false;
        }
        IDevice iDevice = null;
        if (fDSParseRecord2.contains("PART_ID")) {
            iDevice = this.parseSprayer(fDSParseRecord, fDSParseRecord2, string3, string4);
        } else if (string4.equals("SPRINKLER LINK TEMPERATURE")) {
            iDevice = this.parseSprinklerLink(fDSParseRecord, fDSParseRecord2, string3);
        } else if (string4.equals("LINK TEMPERATURE")) {
            iDevice = this.parseHeatDetector(fDSParseRecord, fDSParseRecord2, string3);
        } else if (string4.equals("spot obscuration") || string4.equals("CHAMBER OBSCURATION")) {
            iDevice = this.parseSmokeDetector(fDSParseRecord, fDSParseRecord2, string3);
        } else if (string4.equalsIgnoreCase("ASPIRATION")) {
            iDevice = this.parseAspirator(fDSParseRecord, fDSParseRecord2, string3);
        } else if (string4.equals("CABLE TEMPERATURE")) {
            iDevice = this.parseCableMeasurer(fDSParseRecord, fDSParseRecord2, string3);
        } else if (string4.startsWith("MASS FLOW") || string4.startsWith("HEAT FLOW") || string4.startsWith("VOLUME FLOW")) {
            iDevice = this.parseFlowMeasurer(fDSParseRecord, fDSParseRecord2, string3, string4);
        } else {
            object2 = this.parseQuantity(fDSParseRecord, fDSParseRecord2, Intl.intl("Adding to additional records section."), true, false);
            if (object2 == null) {
                return false;
            }
            object = object2.get();
            if (object2.equals(Quantity.SPEC_DENSITY.create(ExSpecList.MixFrac.SOOT.spec))) {
                iDevice = this.parseSootDensityDevice(fDSParseRecord, fDSParseRecord2, string3);
            } else if (((Enum)object).equals((Object)Quantity.PATH_OBSCURATION)) {
                iDevice = this.parsePathObscurationMeasurer(fDSParseRecord, fDSParseRecord2, string3);
            } else if (((Enum)object).equals((Object)Quantity.LAYER_HEIGHT)) {
                iDevice = this.parseLayerInfoMeasurer(fDSParseRecord, fDSParseRecord2, string3, true, false, false);
            } else if (((Enum)object).equals((Object)Quantity.UPPER_TEMPERATURE)) {
                iDevice = this.parseLayerInfoMeasurer(fDSParseRecord, fDSParseRecord2, string3, false, true, false);
            } else if (((Enum)object).equals((Object)Quantity.LOWER_TEMPERATURE)) {
                iDevice = this.parseLayerInfoMeasurer(fDSParseRecord, fDSParseRecord2, string3, false, false, true);
            } else if (((Enum)object).equals((Object)Quantity.TIME)) {
                iDevice = this.parseClock(fDSParseRecord, string3);
            } else if (!GasPointMeasurer.getQuantityFilter().shouldFilter(object2.get())) {
                iDevice = this.parseGasPointMeasurer(fDSParseRecord, fDSParseRecord2, string3, (IQuantity)object2);
            } else if (!SolidPointMeasurer.getQuantityFilter().shouldFilter(object2.get())) {
                iDevice = this.parseSolidPointMeasurer(fDSParseRecord, fDSParseRecord2, string3, (IQuantity)object2);
            } else if (!AABoxMeasurer.getQuantityFilter().shouldFilter(object2.get())) {
                iDevice = this.parseAABoxMeasurer(fDSParseRecord, fDSParseRecord2, string3, (IQuantity)object2);
            } else if (HvacDevice.isValidQuantity((IQuantity)object2)) {
                iDevice = this.parseHvacDevc(string4, fDSParseRecord, (IQuantity)object2, string3);
            }
        }
        if (iDevice == null) {
            this.addWarning(fDSParseRecord, Intl.intl("Unknown device type encountered."), Intl.intl("Adding device to additional records section."));
            return false;
        }
        if (!bl && iDevice instanceof ISignalSource) {
            object2 = (ISignalSource)((Object)iDevice);
            object = object2.getOutputPins().iterator();
            while (object.hasNext()) {
                IOutPin iOutPin;
                IOutPin iOutPin2 = iOutPin = object.next();
                this.d_pinConns.addOutputName(iOutPin2, string3);
            }
            if (iDevice instanceof Timer) {
                this.d_pinConns.addOutputName(Clock.INSTANCE.getMsrInfo().getPin(), string3);
            }
        }
        if (iDevice != Clock.INSTANCE) {
            int n = this.existsStatus(fDSParseRecord, iDevice, IDevice.class);
            if (n != 0) {
                return this.convertToReturn(n);
            }
            this.getContainer().getDevices().add(iDevice);
            this.flagObjectAdded(iDevice);
        }
        return true;
    }

    private IOutPin parseLatch(FDSParseRecord fDSParseRecord, IOutPin iOutPin) {
        boolean bl = fDSParseRecord.getBoolean("LATCH", true);
        if (bl) {
            LatchCtrl latchCtrl = new LatchCtrl();
            if (!latchCtrl.getInputPin().canConnect(iOutPin)) {
                return iOutPin;
            }
            latchCtrl.getInputPin().connect(iOutPin);
            return latchCtrl.getOutputPins().get(0);
        }
        return iOutPin;
    }

    private IOutPin parseInvert(FDSParseRecord fDSParseRecord, IOutPin iOutPin) {
        boolean bl = fDSParseRecord.getBoolean("INITIAL_STATE", true);
        if (bl) {
            NotOp notOp = new NotOp();
            if (!notOp.getInputPin().canConnect(iOutPin)) {
                return iOutPin;
            }
            notOp.getInputPin().connect(iOutPin);
            return notOp.getOutputPins().get(0);
        }
        return iOutPin;
    }

    private IDevice parseAABoxMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, IQuantity iQuantity) throws FDSRecordFormatException {
        UnitAABox unitAABox = DeviceParser.parseAABox(fDSParseRecord, "DEVC", "XB", true);
        AABoxMeasurer aABoxMeasurer = new AABoxMeasurer(string, iQuantity, unitAABox);
        aABoxMeasurer.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, aABoxMeasurer.getQuantity().get()));
        return aABoxMeasurer;
    }

    private FlowMeasurer parseFlowMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, String string2) throws FDSRecordFormatException {
        String string3;
        int n;
        String string4 = string2.trim();
        char c = string4.charAt(string4.length() - 1);
        switch (c) {
            case '-': {
                n = 1;
                string3 = string4.substring(0, string4.length() - 1).trim();
                break;
            }
            case '+': {
                n = 0;
                string3 = string4.substring(0, string4.length() - 1).trim();
                break;
            }
            default: {
                n = 2;
                string3 = string4;
            }
        }
        Quantity quantity = this.getQuantityMap().getQuantity(string3);
        if (quantity == null || FlowMeasurer.getQuantityFilter().shouldFilter(quantity)) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Invalid flow direction specified."));
        }
        AARectangle aARectangle = this.parseAARectangle(fDSParseRecord);
        FlowMeasurer flowMeasurer = new FlowMeasurer(string, quantity.create(), aARectangle, n);
        flowMeasurer.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, flowMeasurer.getQuantity().get()));
        return flowMeasurer;
    }

    private IDevice parseLayerInfoMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, boolean bl, boolean bl2, boolean bl3) throws FDSRecordFormatException {
        UnitLineSeg3D unitLineSeg3D = DeviceParser.parseLineSeg3D(fDSParseRecord, "DEVC", "XB", true);
        LayerMeasurer layerMeasurer = new LayerMeasurer(string, bl, bl2, bl3, unitLineSeg3D);
        if (bl) {
            layerMeasurer.getHeightInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, layerMeasurer.getHeightInfo().getPin()));
        }
        if (bl2) {
            layerMeasurer.getUpperTempInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, layerMeasurer.getUpperTempInfo().getPin()));
        }
        if (bl3) {
            layerMeasurer.getLowerTempInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, layerMeasurer.getLowerTempInfo().getPin()));
        }
        return layerMeasurer;
    }

    private PathObscurationMeasurer parsePathObscurationMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        UnitLineSeg3D unitLineSeg3D = DeviceParser.parseLineSeg3D(fDSParseRecord, "DEVC", "XB", true);
        PathObscurationMeasurer pathObscurationMeasurer = new PathObscurationMeasurer(string, unitLineSeg3D);
        pathObscurationMeasurer.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, pathObscurationMeasurer.getQuantity().get()));
        return pathObscurationMeasurer;
    }

    private static AlarmInfo parseAlarm(FDSParseRecord fDSParseRecord, IDoubleOutPin iDoubleOutPin) {
        return DeviceParser.parseAlarm(fDSParseRecord, iDoubleOutPin.getUnitType());
    }

    private static AlarmInfo parseAlarm(FDSParseRecord fDSParseRecord, Quantity quantity) {
        return DeviceParser.parseAlarm(fDSParseRecord, quantity.unitType);
    }

    private static AlarmInfo parseAlarm(FDSParseRecord fDSParseRecord, int n) {
        Double d = fDSParseRecord.getDouble("SETPOINT", false);
        if (d == null) {
            return null;
        }
        Unit unit = SIUS.unit(n);
        UnitDouble unitDouble = new UnitDouble(d, unit);
        return new AlarmInfo(unitDouble, DeviceParser.parseTripFlags(fDSParseRecord));
    }

    private static int parseTripFlags(FDSParseRecord fDSParseRecord) {
        int n = 0;
        if (fDSParseRecord.getBoolean("INITIAL_STATE", true).booleanValue()) {
            n |= 2;
        }
        if (fDSParseRecord.getBoolean("LATCH", true).booleanValue()) {
            n |= 1;
        }
        return n;
    }

    private CableFailDetector parseCableMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        CableFailDetector.CableInfo cableInfo = new CableFailDetector.CableInfo(fDSParseRecord2.getUnitDouble("CABLE_MASS_PER_LENGTH", true), fDSParseRecord2.getUnitDouble("CABLE_FAILURE_TEMPERATURE", true), fDSParseRecord2.getUnitDouble("CABLE_DIAMETER", true), fDSParseRecord2.getUnitDouble("CABLE_JACKET_THICKNESS", true));
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        CableFailDetector cableFailDetector = new CableFailDetector(string, freePointLoc, cableInfo);
        cableFailDetector.setTripFlags(DeviceParser.parseTripFlags(fDSParseRecord));
        return cableFailDetector;
    }

    private Aspirator parseAspirator(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("BYPASS_FLOWRATE", true);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        Aspirator aspirator = new Aspirator(string, unitDouble, freePointLoc);
        aspirator.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, aspirator.getQuantity().get()));
        return aspirator;
    }

    private AspiratorSampler parseAspiratorSampler(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        AspiratorSampler aspiratorSampler = new AspiratorSampler(string, freePointLoc);
        aspiratorSampler.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, aspiratorSampler.getQuantity().get()));
        this.d_aspSamplerRecs.add(fDSParseRecord);
        return aspiratorSampler;
    }

    private IDevice parseSootDensityDevice(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        if (fDSParseRecord.contains("FLOWRATE") || fDSParseRecord.contains("DELAY") || fDSParseRecord.contains("DEVC_ID")) {
            return this.parseAspiratorSampler(fDSParseRecord, fDSParseRecord2, string);
        }
        return this.parseGasPointMeasurer(fDSParseRecord, fDSParseRecord2, string, Quantity.SPEC_DENSITY.create(ExSpecList.MixFrac.SOOT.spec));
    }

    private IDevice parseClock(FDSParseRecord fDSParseRecord, String string) {
        AlarmInfo alarmInfo = DeviceParser.parseAlarm(fDSParseRecord, Quantity.TIME);
        if (alarmInfo == null) {
            return Clock.INSTANCE;
        }
        Timer timer = new Timer(string, alarmInfo.setpoint, TripFlags.initiallyOn(alarmInfo.tripFlags));
        return timer;
    }

    private IDevice parseGasPointMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, IQuantity iQuantity) throws FDSRecordFormatException {
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        if (iQuantity.get().equals((Object)Quantity.THERMOCOUPLE)) {
            Thermocouple thermocouple = new Thermocouple(string, fDSParseRecord2.getUnitDouble("BEAD_DIAMETER", true), fDSParseRecord2.getDouble("BEAD_EMISSIVITY", true), fDSParseRecord2.getUnitDouble("BEAD_DENSITY", true), fDSParseRecord2.getUnitDouble("BEAD_SPECIFIC_HEAT", true), freePointLoc);
            thermocouple.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, thermocouple.getQuantity().get()));
            return thermocouple;
        }
        GasPointMeasurer gasPointMeasurer = new GasPointMeasurer(string, iQuantity, freePointLoc);
        gasPointMeasurer.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, gasPointMeasurer.getQuantity().get()));
        return gasPointMeasurer;
    }

    private IDevice parseSolidPointMeasurer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, IQuantity iQuantity) throws FDSRecordFormatException {
        AttachedPointLoc attachedPointLoc = this.parseAttachedPointLoc(fDSParseRecord);
        SolidPointMeasurer solidPointMeasurer = iQuantity.get().equals((Object)Quantity.INSIDE_WALL_TEMPERATURE) ? new InnerTempMeasurer(string, fDSParseRecord.getUnitDouble("DEPTH", true), attachedPointLoc) : (iQuantity.get().equals((Object)Quantity.PRESSURE_COEFFICIENT) ? new PressureCoeffMeasurer(string, fDSParseRecord2.getUnitDouble("CHARACTERISTIC_VELOCITY", true), attachedPointLoc) : (iQuantity.get().equals((Object)Quantity.GAUGE_HEAT_FLUX) ? new GaugeHeatFluxMeasurer(string, fDSParseRecord2.getUnitDouble("GAUGE_TEMPERATURE", true), attachedPointLoc) : (!SolidDensityMeasurer.getQuantityFilter().shouldFilter(iQuantity.get()) ? new SolidDensityMeasurer(string, (ObjectQuantity)iQuantity, fDSParseRecord.getUnitDouble("DEPTH", true), attachedPointLoc) : new SolidPointMeasurer(string, iQuantity, attachedPointLoc))));
        solidPointMeasurer.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(fDSParseRecord, solidPointMeasurer.getQuantity().get()));
        return solidPointMeasurer;
    }

    private ASprayer parseSprayer(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string, String string2) throws FDSRecordFormatException {
        if (string2.equals("SPRINKLER LINK TEMPERATURE")) {
            return this.parseSprinkler(fDSParseRecord, fDSParseRecord2, string);
        }
        if (string2.equals("CONTROL")) {
            return this.parseGenericNozzle(fDSParseRecord, fDSParseRecord2, string);
        }
        return this.parseMeasuringNozzle(fDSParseRecord, fDSParseRecord2, string);
    }

    private Sprinkler parseSprinkler(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        SprinklerLinkModel sprinklerLinkModel = this.d_propParser.parseSprinklerLinkModel(fDSParseRecord2);
        SprayModel sprayModel = this.d_propParser.parseSprayModel(fDSParseRecord2);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        Sprinkler.TraditionalModel traditionalModel = new Sprinkler.TraditionalModel(sprinklerLinkModel, fDSParseRecord.getBoolean("INITIAL_STATE", true), fDSParseRecord.getBoolean("LATCH", true));
        Sprinkler sprinkler = new Sprinkler(string, sprayModel, traditionalModel, freePointLoc);
        return sprinkler;
    }

    private Nozzle parseGenericNozzle(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        SprayModel sprayModel = this.d_propParser.parseSprayModel(fDSParseRecord2);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        Nozzle nozzle = new Nozzle(string, sprayModel, freePointLoc);
        DeviceParser.markSingleInputForRetrieval(fDSParseRecord, nozzle, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return nozzle;
    }

    private ASprayer parseMeasuringNozzle(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        SprayModel sprayModel = this.d_propParser.parseSprayModel(fDSParseRecord2);
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, fDSParseRecord2, "", false, false);
        if (iQuantity == null || Sprinkler.QuantityModel.getQuantityFilter().shouldFilter(iQuantity.get())) {
            return null;
        }
        Double d = (Double)fDSParseRecord.get("SETPOINT", true);
        if (d == null) {
            return null;
        }
        UnitDouble unitDouble = new UnitDouble(d, SIUS.unit(iQuantity.get().unitType));
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        Sprinkler.QuantityModel quantityModel = new Sprinkler.QuantityModel(iQuantity, unitDouble, fDSParseRecord.getBoolean("INITIAL_STATE", true), fDSParseRecord.getBoolean("LATCH", true));
        Sprinkler sprinkler = new Sprinkler(string, sprayModel, quantityModel, freePointLoc);
        return sprinkler;
    }

    private SprinklerLink parseSprinklerLink(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        SprinklerLinkModel sprinklerLinkModel = this.d_propParser.parseSprinklerLinkModel(fDSParseRecord2);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        SprinklerLink sprinklerLink = new SprinklerLink(string, sprinklerLinkModel, freePointLoc);
        sprinklerLink.setTripFlags(DeviceParser.parseTripFlags(fDSParseRecord));
        return sprinklerLink;
    }

    private IDetector parseSmokeDetector(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        SmokeLinkModel smokeLinkModel = this.d_propParser.parseSmokeLinkModel(fDSParseRecord2);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        SmokeDetector smokeDetector = new SmokeDetector(string, smokeLinkModel, freePointLoc);
        smokeDetector.setTripFlags(DeviceParser.parseTripFlags(fDSParseRecord));
        return smokeDetector;
    }

    private IDetector parseHeatDetector(FDSParseRecord fDSParseRecord, FDSParseRecord fDSParseRecord2, String string) throws FDSRecordFormatException {
        HeatLinkModel heatLinkModel = this.d_propParser.parseHeatLinkModel(fDSParseRecord2);
        FreePointLoc freePointLoc = this.parseFreePointLoc(fDSParseRecord);
        HeatDetector heatDetector = new HeatDetector(string, heatLinkModel, freePointLoc);
        heatDetector.setTripFlags(DeviceParser.parseTripFlags(fDSParseRecord));
        return heatDetector;
    }

    private IDevice parseHvacDevc(String string, FDSParseRecord fDSParseRecord, IQuantity iQuantity, String string2) throws FDSRecordFormatException {
        String string3 = fDSParseRecord.getString("ID");
        boolean bl = false;
        boolean bl2 = false;
        for (Class<? extends IPyroObject> clazz : iQuantity.get().requiredTypes) {
            if (HvacDuct.class.isAssignableFrom(clazz)) {
                bl = true;
            }
            if (!HvacNode.class.isAssignableFrom(clazz)) continue;
            bl2 = true;
        }
        if (bl) {
            return new HvacDevice.DuctDevice(string3, iQuantity);
        }
        if (bl2) {
            return new HvacDevice.NodeDevice(string3, iQuantity);
        }
        return null;
    }

    private AARectangle parseAARectangle(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitPoint3D[] unitPoint3DArray = DeviceParser.parseXB(fDSParseRecord, "DEVC", "XB", true);
        if (unitPoint3DArray[0].x() == unitPoint3DArray[1].x()) {
            return new AARectangle(0, unitPoint3DArray[0].x(), unitPoint3DArray[0].y(), unitPoint3DArray[0].z(), unitPoint3DArray[1].y(), unitPoint3DArray[1].z());
        }
        if (unitPoint3DArray[0].y() == unitPoint3DArray[1].y()) {
            return new AARectangle(1, unitPoint3DArray[0].y(), unitPoint3DArray[0].x(), unitPoint3DArray[0].z(), unitPoint3DArray[1].x(), unitPoint3DArray[1].z());
        }
        if (unitPoint3DArray[0].z() == unitPoint3DArray[1].z()) {
            return new AARectangle(2, unitPoint3DArray[0].z(), unitPoint3DArray[0].x(), unitPoint3DArray[0].y(), unitPoint3DArray[1].x(), unitPoint3DArray[1].y());
        }
        throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("XB must specify a plane."));
    }

    private FreePointLoc parseFreePointLoc(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitPoint3D unitPoint3D = DeviceParser.parseLoc(fDSParseRecord, "DEVC", "XYZ", true);
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("ROTATION", true);
        FDSArray fDSArray = fDSParseRecord.getArray("ORIENTATION", true);
        Vector3d vector3d = new Vector3d((Double)fDSArray.get(0), (Double)fDSArray.get(1), (Double)fDSArray.get(2));
        return new FreePointLoc(unitPoint3D, vector3d, unitDouble);
    }

    private AttachedPointLoc parseAttachedPointLoc(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitPoint3D unitPoint3D = DeviceParser.parseLoc(fDSParseRecord, "DEVC", "XYZ", true);
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("ROTATION", true);
        Integer n = (Integer)fDSParseRecord.get("IOR");
        if (n == null) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Device must specify orientation using IOR."));
        }
        Vector3d vector3d = GeomUtil.toWorldVec(n);
        return new AttachedPointLoc(unitPoint3D, vector3d, unitDouble);
    }
}

