/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.evac.Corr;
import pyrosim.legacy_2012_1.domain.evac.CorrList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class CorrParser
extends AFDS5Parser {
    public CorrParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        FDSArray<UnitDouble> fDSArray;
        String string;
        if (!fDSParseRecord.contains("ID")) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to process CORR record: ID missing"), Intl.intl("CORR Record Ignored"));
            return false;
        }
        CorrList corrList = this.getContainer().getCorrList();
        if (corrList.get(string = fDSParseRecord.getString("ID")) != null) {
            int n = 1;
            fDSArray = string;
            while (corrList.get(string = String.format("%s[%d]", fDSArray, n)) != null) {
            }
            this.addWarning(fDSParseRecord, Intl.intl("Invalid CORR record: Duplicate ID"), String.format(Intl.intl("ID changed from \"%s\"to \"%s\""), fDSArray, string));
        }
        Corr corr = new Corr(string);
        corr.setProp("FYI", fDSParseRecord.get("FYI"));
        if (fDSParseRecord.contains("MAX_HUMANS_INSIDE")) {
            corr.setProp("MAX_HUMANS_INSIDE", fDSParseRecord.getInteger("MAX_HUMANS_INSIDE"));
        }
        if (fDSParseRecord.contains("TO_NODE")) {
            fDSArray = fDSParseRecord.getString("TO_NODE");
            NamedPyroObject namedPyroObject = null;
            if (namedPyroObject == null) {
                namedPyroObject = (NamedPyroObject)this.getContainer().getDoorList().get((String)((Object)fDSArray));
            }
            if (namedPyroObject == null) {
                namedPyroObject = (NamedPyroObject)this.getContainer().getExitList().get((String)((Object)fDSArray));
            }
            if (namedPyroObject == null) {
                namedPyroObject = (NamedPyroObject)this.getContainer().getCorrList().get((String)((Object)fDSArray));
            }
            if (namedPyroObject == null) {
                namedPyroObject = (NamedPyroObject)this.getContainer().getEntrList().get((String)((Object)fDSArray));
            }
            if (namedPyroObject != null) {
                corr.setProp("TO_NODE", namedPyroObject);
            } else {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Invalid CORR record: Unknown TO_NODE \"%s\""), fDSArray), Intl.intl("TO_NODE record dropped."));
            }
        }
        if (fDSParseRecord.contains("XB")) {
            fDSArray = fDSParseRecord.getArray("XB", false);
            corr.setProp("XB1", fDSArray.toFlatArray(new UnitDouble[fDSArray.getTotalLength()]));
        }
        if (fDSParseRecord.contains("XB1")) {
            fDSArray = fDSParseRecord.getArray("XB1", false);
            corr.setProp("XB1", fDSArray.toFlatArray(new UnitDouble[fDSArray.getTotalLength()]));
            if (fDSParseRecord.contains("XB")) {
                this.addWarning(fDSParseRecord, Intl.intl("Invalid CORR record: Cannot define both XB and XB1"), Intl.intl("Ignoring value for XB"));
            }
        }
        if (fDSParseRecord.contains("XB2")) {
            fDSArray = fDSParseRecord.getArray("XB2", false);
            corr.setProp("XB2", fDSArray.toFlatArray(new UnitDouble[fDSArray.getTotalLength()]));
        }
        if (fDSParseRecord.contains("FAC_SPEED")) {
            corr.setProp("FAC_SPEED", fDSParseRecord.getDouble("FAC_SPEED"));
        }
        if (fDSParseRecord.contains("EFF_LENGTH")) {
            corr.setProp("EFF_LENGTH", fDSParseRecord.getUnitDouble("EFF_LENGTH"));
        }
        corrList.add(corr);
        this.flagObjectAdded(corr);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("CORR");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }
}

