/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.LinkedHashSet;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.output.Boundaries;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PropParser;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class BoundaryParser
extends AFDS5Parser {
    private final Set<IQuantity> d_measurements = new LinkedHashSet<IQuantity>();
    private final PropParser d_propParser;

    public BoundaryParser(FDS5ParsingInfo fDS5ParsingInfo, PropParser propParser) {
        super(fDS5ParsingInfo);
        this.d_propParser = propParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("BNDF");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public void done() throws FDSRecordFormatException {
        if (this.d_measurements.isEmpty()) {
            return;
        }
        Boundaries boundaries = this.getContainer().getBoundaryOutput();
        this.d_measurements.addAll(boundaries.getQuantities());
        boundaries.setQuantities(this.d_measurements);
        this.flagObjectAdded(boundaries);
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, 16, Intl.intl("BNDF record ignored"), true, false);
        if (iQuantity == null) {
            return false;
        }
        this.d_measurements.add(iQuantity);
        FDSParseRecord fDSParseRecord2 = null;
        String string = (String)fDSParseRecord.get("PROP_ID");
        if (string != null && (fDSParseRecord2 = this.d_propParser.getProp(string)) == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find PROP record: %s"), string), Intl.intl("Ignoring properties."));
        }
        if (fDSParseRecord2 == null) {
            fDSParseRecord2 = PropParser.getDefaultProp();
        }
        if (iQuantity.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord2.get("CHARACTERISTIC_VELOCITY", true);
            this.getContainer().getBoundaryOutput().setPressCoeffCharVel(unitDouble);
        } else if (iQuantity.get().equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord2.get("GAUGE_TEMPERATURE", true);
            this.getContainer().getBoundaryOutput().setGaugeTemperature(unitDouble);
        }
        return true;
    }
}

