/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.quantity.VelocitySign;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParseWarning;
import pyrosim.legacy_2012_1.io.fds.FDSParsingInfo;
import pyrosim.legacy_2012_1.io.fds.FDSRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.FDSRecordSpec;
import pyrosim.legacy_2012_1.io.fds.FDSRenderProps;
import pyrosim.legacy_2012_1.io.fds.IFDSRecordParser;
import pyrosim.legacy_2012_1.io.fds.v5.FDS5Colors;
import pyrosim.legacy_2012_1.io.fds.v5.QuantityMap;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.Multiplier;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitLineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public abstract class AFDS5Parser
implements IFDSRecordParser {
    protected static final int VALID = 0;
    protected static final int IGNORE = 1;
    protected static final int ADDITIONAL_RECORD = 2;
    protected static final Color INVISIBLE_COLOR = new InvsColor();
    private FDS5ParsingInfo d_parsingInfo;

    public AFDS5Parser(FDS5ParsingInfo fDS5ParsingInfo) {
        this.d_parsingInfo = fDS5ParsingInfo;
    }

    @Override
    public void process(Collection<FDSParseRecord> collection, Collection<FDSParseRecord> collection2) throws FDSRecordFormatException {
        for (FDSParseRecord fDSParseRecord : collection) {
            boolean bl = false;
            try {
                bl = this.process(fDSParseRecord);
            }
            catch (FDSRecordFormatException fDSRecordFormatException) {
                throw fDSRecordFormatException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new FDSRecordFormatException(fDSParseRecord);
            }
            if (bl) continue;
            collection2.add(fDSParseRecord);
        }
        this.done();
    }

    protected abstract boolean process(FDSParseRecord var1) throws FDSRecordFormatException;

    protected void done() throws FDSRecordFormatException {
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
    }

    public PyroMod getContainer() {
        return this.d_parsingInfo.getContainer();
    }

    public FDS5ParsingInfo getParsingInfo() {
        return this.d_parsingInfo;
    }

    public void flagObjectAdded(IPyroObject iPyroObject) {
        this.d_parsingInfo.getParseResult().extractedObjs.add(iPyroObject);
    }

    public void flagObjectsAdded(Collection<? extends IPyroObject> collection) {
        for (IPyroObject iPyroObject : collection) {
            this.flagObjectAdded(iPyroObject);
        }
    }

    public void unflagObjectAdded(IPyroObject iPyroObject) {
        this.d_parsingInfo.getParseResult().extractedObjs.remove(iPyroObject);
    }

    public void flagEvac() {
        this.getContainer().setEvacEnabled(true);
    }

    public void addWarning(FDSParseWarning fDSParseWarning) {
        this.d_parsingInfo.addWarning(fDSParseWarning);
    }

    public void addWarning(FDSParseRecord fDSParseRecord, String string, String string2) {
        this.d_parsingInfo.addWarning(new FDSParseWarning(fDSParseRecord, string, string2));
    }

    public QuantityMap getQuantityMap() {
        return this.d_parsingInfo.getQuantityMap();
    }

    public IQuantity parseQuantity(FDSParseRecord fDSParseRecord, String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, boolean bl, boolean bl2) throws FDSRecordFormatException {
        try {
            IQuantity iQuantity = this.getQuantityMap().parseQuantity(this.getParsingInfo(), fDSParseRecord, string, string2, string3, string4, string5, string6, bl);
            if (iQuantity != null && !QuantityUtil.canOutputAll(iQuantity.get(), n)) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Quantity %s is invalid for output."), fDSParseRecord.getString(string)), string7);
                return null;
            }
            return iQuantity;
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            if (bl2) {
                throw fDSRecordFormatException;
            }
            this.addWarning(fDSParseRecord, fDSRecordFormatException.getError(), string7);
            return null;
        }
    }

    protected Color parseColor(FDSParseRecord fDSParseRecord, String string, String string2, String string3, boolean bl) {
        return AFDS5Parser.parseColor(this.getParsingInfo(), fDSParseRecord, string, string2, string3, bl);
    }

    protected static Color parseColor(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord, String string, String string2, String string3, boolean bl) {
        FDSArray fDSArray;
        Color color = null;
        if (string != null && fDSParseRecord.contains(string)) {
            fDSArray = fDSParseRecord.getArray(string, false);
            color = AFDS5Parser.interpColor(fDSParsingInfo, fDSParseRecord, (Double)fDSArray.get(0), (Double)fDSArray.get(1), (Double)fDSArray.get(2));
        } else if (string2 != null && fDSParseRecord.contains(string2)) {
            fDSArray = (String)fDSParseRecord.get(string2);
            if (((String)((Object)fDSArray)).equals("INVISIBLE")) {
                return INVISIBLE_COLOR;
            }
            color = FDS5Colors.getColor(fDSArray);
            if (color == null) {
                fDSParsingInfo.addWarning(fDSParseRecord, String.format(Intl.intl("%s is not a valid FDS color name."), fDSArray), String.format(Intl.intl("Using default color."), new Object[0]));
            }
        }
        if (color == null) {
            if (!bl) {
                return null;
            }
            fDSArray = fDSParseRecord.getArray(string, true);
            if (fDSArray != null) {
                color = AFDS5Parser.interpColor(fDSParsingInfo, fDSParseRecord, (Double)fDSArray.get(0), (Double)fDSArray.get(1), (Double)fDSArray.get(2));
            } else {
                String string4 = (String)fDSParseRecord.get(string2, true);
                if (string4 != null) {
                    color = FDS5Colors.getColor(string4);
                }
            }
        }
        int n = 255;
        if (string3 != null && fDSParseRecord.contains(string3)) {
            n = (int)((Double)fDSParseRecord.get(string3) * 255.0);
        }
        if (color == null) {
            return new Color(128, 128, 128, n);
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    private static Color interpColor(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord, double d, double d2, double d3) {
        if (0.0 < d && d < 1.0 || 0.0 < d2 && d2 < 1.0 || 0.0 < d3 && d3 < 1.0) {
            fDSParsingInfo.addWarning(fDSParseRecord, Intl.intl("Old-style RGB value detected."), Intl.intl("Converted to new range [0...255]."));
            return new Color((float)d, (float)d2, (float)d3);
        }
        return new Color((int)d, (int)d2, (int)d3);
    }

    protected <T extends IPyroGeomSrc> Pair<String, List<T>> applyMult(FDSParseRecord fDSParseRecord, String string, T t) {
        Object object;
        String string2 = fDSParseRecord.getString(string, false);
        if (string2 != null) {
            object = this.getParsingInfo().getMultiplier(string2);
            if (object == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find MULT record, \"%s\""), string2), String.format(Intl.intl("Ignoring MULT and adding %s as defined."), fDSParseRecord.getType()));
            } else {
                return ((Multiplier)object).applyTo(t);
            }
        }
        object = t instanceof INamed ? ((INamed)((Object)t)).getName() : "";
        return new Pair<Object, List<IPyroGeomSrc>>(object, Arrays.asList(t));
    }

    protected static AABoxGeom parseXBGeom(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl) throws FDSRecordFormatException {
        UnitPoint3D[] unitPoint3DArray = AFDS5Parser.parseXB(fDSParseRecord, string, string2, bl);
        if (unitPoint3DArray == null) {
            return null;
        }
        return new AABoxGeom(unitPoint3DArray[0].getPoint3dValue(Geometry.LU), unitPoint3DArray[1].getPoint3dValue(Geometry.LU), 0);
    }

    protected static UnitPoint3D[] parseXB(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl) throws FDSRecordFormatException {
        FDSArray fDSArray = null;
        if (fDSParseRecord.contains(string2)) {
            fDSArray = fDSParseRecord.getArray(string2, true);
        }
        if (fDSArray == null) {
            if (bl) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("%s must specify geometry."), string));
            }
            return null;
        }
        UnitPoint3D unitPoint3D = new UnitPoint3D((UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(2), (UnitDouble)fDSArray.get(4));
        UnitPoint3D unitPoint3D2 = new UnitPoint3D((UnitDouble)fDSArray.get(1), (UnitDouble)fDSArray.get(3), (UnitDouble)fDSArray.get(5));
        return GeomUtil.rectify(unitPoint3D, unitPoint3D2);
    }

    protected static UnitAABox parseAABox(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl) throws FDSRecordFormatException {
        UnitPoint3D[] unitPoint3DArray = AFDS5Parser.parseXB(fDSParseRecord, string, string2, bl);
        if (unitPoint3DArray == null) {
            return null;
        }
        return new UnitAABox(unitPoint3DArray[0], unitPoint3DArray[1]);
    }

    protected static UnitLineSeg3D parseLineSeg3D(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl) throws FDSRecordFormatException {
        UnitPoint3D[] unitPoint3DArray = AFDS5Parser.parseXB(fDSParseRecord, string, string2, bl);
        if (unitPoint3DArray == null) {
            return null;
        }
        return new UnitLineSeg3D(unitPoint3DArray[0], unitPoint3DArray[1]);
    }

    protected static UnitPoint3D parseLoc(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl) throws FDSRecordFormatException {
        return AFDS5Parser.parseLoc(fDSParseRecord, string, string2, true, bl);
    }

    protected static UnitPoint3D parseLoc(FDSParseRecord fDSParseRecord, String string, String string2, boolean bl, boolean bl2) throws FDSRecordFormatException {
        FDSArray fDSArray = fDSParseRecord.getArray(string2, bl);
        if (fDSArray == null || fDSArray.get(0) == null || fDSArray.get(1) == null || fDSArray.get(2) == null) {
            if (bl2) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("%s is missing a location."), string));
            }
            return null;
        }
        return new UnitPoint3D((UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), (UnitDouble)fDSArray.get(2));
    }

    protected static TexOrigin parseTexLoc(FDSParseRecord fDSParseRecord, Point3d point3d, String string, String string2) throws FDSRecordFormatException {
        UnitPoint3D unitPoint3D = AFDS5Parser.parseLoc(fDSParseRecord, string, string2, false);
        if (unitPoint3D != null && !unitPoint3D.equals(TexOrigin.DEF_LOC)) {
            if (unitPoint3D.getPoint3dValue(Geometry.LU).equals(point3d)) {
                return TexOrigin.defaultLocal();
            }
            return new TexOrigin(unitPoint3D, false);
        }
        return TexOrigin.defaultWorld();
    }

    protected static int countDimensions(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        int n = 0;
        if (unitPoint3D.xu().equals(unitPoint3D2.xu())) {
            ++n;
        }
        if (unitPoint3D.yu().equals(unitPoint3D2.yu())) {
            ++n;
        }
        if (unitPoint3D.zu().equals(unitPoint3D2.zu())) {
            ++n;
        }
        return n;
    }

    protected <T extends IPyroObject> T findObject(Class<T> clazz, String string) {
        try {
            return this.findObject(null, clazz, string, false);
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            assert (false);
            return null;
        }
    }

    protected <T extends IPyroObject> T findObject(FDSParseRecord fDSParseRecord, Class<T> clazz, String string, boolean bl) throws FDSRecordFormatException {
        T t = this.getParsingInfo().findObject(clazz, string);
        if (t == null && bl) {
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Could not find %s."), string));
        }
        return t;
    }

    protected <T extends IPyroObject> T findReplacementObject(Class<T> clazz, String string) {
        return this.getParsingInfo().findReplacementObject(clazz, string);
    }

    protected boolean checkName(FDSParseRecord fDSParseRecord, String string) {
        if (string == null || string.trim().equals("")) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%s has no ID."), fDSParseRecord.getType()), String.format(Intl.intl("Adding %s to additional records section."), fDSParseRecord.getType()));
            return false;
        }
        return true;
    }

    protected <T extends INamed> int existsStatus(FDSParseRecord fDSParseRecord, T t, Class<T> clazz) {
        T t2 = this.findReplacementObject(clazz, t.getName());
        if (t2 == null) {
            return 0;
        }
        T t3 = this.findObject(clazz, t.getName());
        if (t3 != null && t3.equals(t)) {
            return 1;
        }
        this.addWarning(fDSParseRecord, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), fDSParseRecord.getType(), t.getName()), String.format(Intl.intl("Adding to additional records section."), fDSParseRecord.getType()));
        return 2;
    }

    protected boolean convertToReturn(int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    protected TimeFunction parseTimeFunction(FDSParseRecord fDSParseRecord, String string, String string2) {
        UnitDouble unitDouble = string != null ? fDSParseRecord.getUnitDouble(string, true) : null;
        String string3 = string2 != null ? fDSParseRecord.getString(string2, false) : null;
        return this.parseTimeFunction(fDSParseRecord, unitDouble, string3);
    }

    protected TimeFunction parseTimeFunction(FDSParseRecord fDSParseRecord, UnitDouble unitDouble, String string) {
        TimeFunction timeFunction = null;
        if (string != null) {
            Ramp ramp = this.getParsingInfo().getRamp(string, RampInputs.TIME, 28, true);
            if (ramp == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Ramp %s could not be found."), string), Intl.intl("Using the default ramp function."));
            } else {
                timeFunction = new TimeFunction.Custom(ramp);
            }
        }
        if (timeFunction == null) {
            timeFunction = AFDS5Parser.parseTCurve(fDSParseRecord, unitDouble);
        }
        assert (timeFunction != null);
        return timeFunction;
    }

    protected static TimeFunction parseTCurve(FDSParseRecord fDSParseRecord, String string) {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble(string);
        return AFDS5Parser.parseTCurve(fDSParseRecord, unitDouble);
    }

    protected static TimeFunction parseTCurve(FDSParseRecord fDSParseRecord, UnitDouble unitDouble) {
        if (unitDouble != null) {
            double d = unitDouble.getValueNoUnit();
            if (d < 0.0) {
                return new TimeFunction.TSquared(unitDouble.negate());
            }
            return new TimeFunction.TanH(unitDouble);
        }
        return TimeFunction.newDefault();
    }

    protected static String getInputID(FDSParseRecord fDSParseRecord, String string, String string2) {
        String string3 = fDSParseRecord.getString(string);
        if (string3 != null) {
            return string3;
        }
        return fDSParseRecord.getString(string2);
    }

    protected static void markSingleInputForRetrieval(FDSParseRecord fDSParseRecord, ISignalSink iSignalSink, PinConnParser pinConnParser, String string, String string2) {
        String string3 = AFDS5Parser.getInputID(fDSParseRecord, string, string2);
        if (string3 != null) {
            pinConnParser.markInputForRetrieval(fDSParseRecord, iSignalSink.getInputPin(), Arrays.asList(string3));
        }
    }

    protected VelocitySign parseVelocitySign(FDSParseRecord fDSParseRecord, Integer n) {
        if (n == null) {
            return VelocitySign.ALWAYS_POSITIVE;
        }
        switch (n) {
            case 1: {
                return VelocitySign.MATCH_U;
            }
            case 2: {
                return VelocitySign.MATCH_V;
            }
            case 3: {
                return VelocitySign.MATCH_W;
            }
            case 0: {
                return VelocitySign.ALWAYS_POSITIVE;
            }
        }
        this.addWarning(new FDSParseWarning(fDSParseRecord, String.format(Intl.intl("Unknown Velocity Index: %d"), n), Intl.intl("Ignoring Velocity Index")));
        return VelocitySign.ALWAYS_POSITIVE;
    }

    protected CustomFDSProps getCustomVals(FDSParseRecord fDSParseRecord) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        FDSRenderProps fDSRenderProps = new FDSRenderProps();
        HashSet<String> hashSet = new HashSet<String>();
        this.getUnsupportedFields(fDSParseRecord.getType(), hashSet);
        for (String object : hashSet) {
            FDSRecordSpec.Field field;
            Object t = fDSParseRecord.get(object);
            if (t == null || (field = fDSParseRecord.getSpec().fields.get(object)) == null) continue;
            String string = field.render(fDSRenderProps, t);
            this.collectCustomVal(linkedHashMap, string);
        }
        for (FDSRecord.UnknownProp unknownProp : fDSParseRecord.getUnknownProps()) {
            linkedHashMap.put(unknownProp.key, unknownProp.renderVal());
        }
        return new CustomFDSProps(linkedHashMap);
    }

    private void collectCustomVal(Map<String, String> map, String string) {
        int n = string.indexOf(61);
        if (n == -1 || n == 0 || n == string.length() - 1) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        assert (!string2.isEmpty() && !string3.isEmpty());
        map.put(string2, string3);
    }

    private static class InvsColor
    extends Color {
        private static final long serialVersionUID = 3863372250254443480L;

        public InvsColor() {
            super(0, 0, 0, 0);
        }
    }
}

