/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.hvac.HvacDuct;
import pyrosim.legacy_2012_1.domain.hvac.HvacNode;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParsingInfo;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.FDSRecordSpec;
import pyrosim.legacy_2012_1.io.fds.FDSRenderRecord;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.treeview.TVEntryPoints;
import pyrosim.legacy_2012_1.util.Util;

public class QuantityMap {
    public static final String CONTROL = "CONTROL";
    public static final String LINK_TEMPERATURE = "LINK TEMPERATURE";
    public static final String SPOT_OBSCURATION = "spot obscuration";
    public static final String CHAMBER_OBSCURATION = "CHAMBER OBSCURATION";
    public static final String SPRINKLER_LINK_TEMPERATURE = "SPRINKLER LINK TEMPERATURE";
    public static final String ASPIRATION = "ASPIRATION";
    public static final String HEAT_FLOW = "HEAT FLOW";
    public static final String MASS_FLOW = "MASS FLOW";
    public static final String VOLUME_FLOW = "VOLUME FLOW";
    public static final String CABLE_TEMPERATURE = "CABLE TEMPERATURE";
    public static final String FDS_TIME = "TIME";
    private final Map<Quantity, String> d_pyroToFDSMap = new HashMap<Quantity, String>();
    private final Map<String, IQuantity> d_fdsToPyroPredefMap = new HashMap<String, IQuantity>();
    private final Map<String, Quantity> d_fdsToPyroObjMap = new HashMap<String, Quantity>();
    private final List<Pair<String, Quantity>> d_fdsToPyroLegPostfixMap = new ArrayList<Pair<String, Quantity>>();

    public QuantityMap() {
        this.mapPredef(Quantity.ABSORPTION_COEFFICIENT, "ABSORPTION COEFFICIENT", "ABSORPTION_COEFFICIENT");
        this.mapPredef(Quantity.AVERAGE_SPECIFIC_HEAT, "AVERAGE SPECIFIC HEAT");
        this.mapPredef(Quantity.CONDUCTIVITY, "CONDUCTIVITY");
        this.mapPredef(Quantity.DENSITY, "DENSITY");
        this.mapPredef(Quantity.DIVERGENCE, "DIVERGENCE");
        this.mapPredef(Quantity.ENTHALPY, "ENTHALPY");
        this.mapPredef(Quantity.EXTINCTION_COEFFICIENT, "EXTINCTION COEFFICIENT", "extinction coefficient");
        this.mapPredef(Quantity.FED, "FED");
        this.mapPredef(Quantity.H, "H");
        this.mapPredef(Quantity.HRRPUV, "HRRPUV");
        this.mapPredef(Quantity.MIXTURE_FRACTION, "MIXTURE FRACTION", "MIXTURE_FRACTION");
        this.mapPredef(Quantity.OPTICAL_DENSITY, "OPTICAL DENSITY");
        this.mapPredef(Quantity.PRESSURE, "PRESSURE");
        this.mapPredef(Quantity.RADIATIVE_HEAT_FLUX_GAS, "RADIATIVE HEAT FLUX GAS");
        this.mapPredef(Quantity.RELATIVE_HUMIDITY, "RELATIVE HUMIDITY");
        this.mapPredef(Quantity.SPECIFIC_ENTHALPY, "SPECIFIC ENTHALPY");
        this.mapPredef(Quantity.SPECIFIC_HEAT, "SPECIFIC HEAT");
        this.mapPredef(Quantity.TEMPERATURE, "TEMPERATURE");
        this.mapPredef(Quantity.THERMOCOUPLE, "THERMOCOUPLE");
        this.mapPredef(Quantity.U_VELOCITY, "U-VELOCITY");
        this.mapPredef(Quantity.V_VELOCITY, "V-VELOCITY");
        this.mapPredef(Quantity.W_VELOCITY, "W-VELOCITY");
        this.mapPredef(Quantity.VELOCITY, "VELOCITY");
        this.mapPredef(Quantity.VISCOSITY, "VISCOSITY");
        this.mapPredef(Quantity.VISIBILITY, "VISIBILITY", "visibility");
        this.mapPredef(Quantity.ADIABATIC_SURFACE_TEMPERATURE, "ADIABATIC SURFACE TEMPERATURE", "ADIABATIC_SURFACE_TEMPERATURE");
        this.mapPredef(Quantity.BACK_WALL_TEMPERATURE, "BACK WALL TEMPERATURE", "BACK_WALL_TEMPERATURE");
        this.mapPredef(Quantity.BURNING_RATE, "BURNING RATE", "BURNING_RATE");
        this.mapPredef(Quantity.CONVECTIVE_FLUX, "CONVECTIVE HEAT FLUX", "CONVECTIVE_FLUX");
        this.mapPredef(Quantity.GAS_TEMPERATURE, "GAS TEMPERATURE");
        this.mapPredef(Quantity.GAUGE_HEAT_FLUX, "GAUGE HEAT FLUX", "GAUGE_HEAT_FLUX");
        this.mapPredef(Quantity.HEAT_FLUX, "NET HEAT FLUX", "HEAT_FLUX");
        this.mapPredef(Quantity.HEAT_TRANSFER_COEFFICIENT, "HEAT TRANSFER COEFFICIENT", "HEAT_TRANSFER_COEFFICIENT");
        this.mapPredef(Quantity.INCIDENT_HEAT_FLUX, "INCIDENT HEAT FLUX", "INCIDENT_HEAT_FLUX");
        this.mapPredef(Quantity.INSIDE_WALL_TEMPERATURE, "INSIDE WALL TEMPERATURE", "INSIDE_WALL_TEMPERATURE");
        this.mapPredef(Quantity.MASS_LOSS, "MASS LOSS", "MASS_LOSS");
        this.mapPredef(Quantity.NORMAL_VELOCITY, "NORMAL VELOCITY", "NORMAL_VELOCITY");
        this.mapPredef(Quantity.PRESSURE_COEFFICIENT, "PRESSURE COEFFICIENT", "PRESSURE_COEFFICIENT");
        this.mapPredef(Quantity.RADIATIVE_FLUX, "RADIATIVE HEAT FLUX", "RADIATIVE_FLUX");
        this.mapPredef(Quantity.RADIOMETER, "RADIOMETER");
        this.mapPredef(Quantity.SURFACE_DENSITY, "SURFACE DENSITY");
        this.mapPredef(Quantity.WALL_TEMPERATURE, "WALL TEMPERATURE", "WALL_TEMPERATURE");
        this.mapPredef(Quantity.WALL_THICKNESS, "WALL THICKNESS", "WALL_THICKNESS");
        this.mapPredef(Quantity.HEAT_FLOW, HEAT_FLOW);
        this.mapPredef(Quantity.HRR, "HRR");
        this.mapPredef(Quantity.MASS_FLOW, MASS_FLOW);
        this.mapPredef(Quantity.VOLUME_FLOW, VOLUME_FLOW);
        this.mapPredef(Quantity.LAYER_HEIGHT, "LAYER HEIGHT");
        this.mapPredef(Quantity.LOWER_TEMPERATURE, "LOWER TEMPERATURE");
        this.mapPredef(Quantity.PATH_OBSCURATION, "PATH OBSCURATION", "path obscuration");
        this.mapPredef(Quantity.UPPER_TEMPERATURE, "UPPER TEMPERATURE");
        this.mapPredef(Quantity.ACTUATED_SPRINKLERS, "ACTUATED SPRINKLERS");
        this.mapPredef(Quantity.CPU_TIME, "CPU TIME");
        this.mapPredef(Quantity.ITERATION, "ITERATION");
        this.mapPredef(Quantity.OPEN_NOZZLES, "OPEN NOZZLES");
        this.mapPredef(Quantity.PRESSURE_ZONE, "PRESSURE ZONE");
        this.mapPredef(Quantity.TIME, FDS_TIME);
        this.mapPredef(Quantity.TIME_STEP, "TIME STEP");
        this.mapPredef(Quantity.TURBULENCE_RESOLUTION, "TURBULENCE RESOLUTION");
        this.mapPredef(Quantity.WALL_CLOCK_TIME, "WALL CLOCK TIME");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.CARBON_DIOXIDE, Quantity.SPEC_VOLUME_FRACTION), "carbon dioxide");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.CARBON_MONOXIDE, Quantity.SPEC_VOLUME_FRACTION), "carbon monoxide");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.FUEL, Quantity.SPEC_VOLUME_FRACTION), "fuel");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.HYDROGEN, Quantity.SPEC_VOLUME_FRACTION), "hydrogen");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.NITROGEN, Quantity.SPEC_VOLUME_FRACTION), "nitrogen");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.OTHER, Quantity.SPEC_VOLUME_FRACTION), "other");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.OTHER, Quantity.SPEC_MASS_FRACTION), "other mass fraction");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.OXYGEN, Quantity.SPEC_VOLUME_FRACTION), "oxygen");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.OXYGEN, Quantity.SPEC_MASS_FRACTION), "oxygen mass fraction");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.SOOT, Quantity.SPEC_VOLUME_FRACTION), "soot", "soot volume fraction");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.SOOT, Quantity.SPEC_DENSITY), "soot density");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.WATER_VAPOR, Quantity.SPEC_VOLUME_FRACTION), "water vapor");
        this.mapPredef(QuantityMap.newQuant(ExSpecList.MixFrac.WATER_VAPOR, Quantity.SPEC_MASS_FRACTION), "WATER VAPOR", "water vapor mass fraction");
        this.mapObj(Quantity.PART_ACMPUA, "AMPUA", "_AMPUA");
        this.mapObj(Quantity.PART_CPUA, "CPUA", "_CPUA");
        this.mapObj(Quantity.PART_MASS_FLUX_X, "DROPLET FLUX X", "_FLUX_X");
        this.mapObj(Quantity.PART_MASS_FLUX_Y, "DROPLET FLUX Y", "_FLUX_Y");
        this.mapObj(Quantity.PART_MASS_FLUX_Z, "DROPLET FLUX Z", "_FLUX_Z");
        this.mapObj(Quantity.PART_MPUA, "MPUA", "_MPUA");
        this.mapObj(Quantity.PART_MPUV, "MPUV", "_MPUV");
        this.mapObj(Quantity.SPEC_MASS_FLUX, "MASS FLUX");
        this.mapObj(Quantity.SPEC_MASS_FLUX_X, "MASS FLUX X", "_FLUX_X");
        this.mapObj(Quantity.SPEC_MASS_FLUX_Y, "MASS FLUX Y", "_FLUX_Y");
        this.mapObj(Quantity.SPEC_MASS_FLUX_Z, "MASS FLUX Z", "_FLUX_Z");
        this.mapObj(Quantity.SPEC_MASS_FRACTION, "MASS FRACTION");
        this.mapObj(Quantity.SPEC_VOLUME_FRACTION, "VOLUME FRACTION", "_VF");
        this.mapObj(Quantity.SPEC_DENSITY, "DENSITY");
        this.mapObj(Quantity.SPEC_VISIBILITY, "VISIBILITY");
        this.mapObj(Quantity.SPEC_OPTICAL_DENSITY, "OPTICAL DENSITY");
        this.mapObj(Quantity.MATL_SOLID_DENSITY, "SOLID DENSITY");
        this.mapObj(Quantity.HVAC_AIRCOIL_HEAT_EXCHANGE, "AIRCOIL HEAT EXCHANGE");
        this.mapObj(Quantity.HVAC_DUCT_DENSITY, "DUCT DENSITY");
        this.mapObj(Quantity.HVAC_DUCT_MASS_FLOW, "DUCT MASS FLOW");
        this.mapObj(Quantity.HVAC_DUCT_MASS_FRACTION, "DUCT MASS FRACTION");
        this.mapObj(Quantity.HVAC_DUCT_TEMPERATURE, "DUCT TEMPERATURE");
        this.mapObj(Quantity.HVAC_DUCT_VELOCITY, "DUCT VELOCITY");
        this.mapObj(Quantity.HVAC_DUCT_VOLUME_FLOW, "DUCT VOLUME FLOW");
        this.mapObj(Quantity.HVAC_DUCT_VOLUME_FRACTION, "DUCT VOLUME FRACTION");
        this.mapObj(Quantity.HVAC_FILTER_LOADING, "FILTER LOADING");
        this.mapObj(Quantity.HVAC_FILTER_LOSS, "FILTER LOSS");
        this.mapObj(Quantity.HVAC_NODE_DENSITY, "NODE DENSITY");
        this.mapObj(Quantity.HVAC_NODE_MASS_FRACTION, "NODE MASS FRACTION");
        this.mapObj(Quantity.HVAC_NODE_PRESSURE, "NODE PRESSURE");
        this.mapObj(Quantity.HVAC_NODE_TEMPERATURE, "NODE TEMPERATURE");
        this.mapObj(Quantity.HVAC_NODE_VOLUME_FRACTION, "NODE VOLUME FRACTION");
        this.mapObj(Quantity.HVAC_NODE_PRESSURE_DIFFERENCE, "NODE PRESSURE DIFFERENCE");
    }

    private static ObjectQuantity newQuant(ExSpecList.MixFrac mixFrac, Quantity quantity) {
        return quantity.create(mixFrac.spec);
    }

    private void mapObj(Quantity quantity, String string) {
        this.mapObj(quantity, string, null);
    }

    private void mapObj(Quantity quantity, String string, String string2) {
        this.d_fdsToPyroObjMap.put(string, quantity);
        this.d_pyroToFDSMap.put(quantity, string);
        if (string2 != null) {
            this.d_fdsToPyroLegPostfixMap.add(new Pair<String, Quantity>(string2, quantity));
        }
    }

    private void mapPredef(Quantity quantity, String ... stringArray) {
        assert (quantity.getNumArgs() == 0);
        this.mapPredef(quantity.create(), stringArray);
    }

    private void mapPredef(IQuantity iQuantity, String ... stringArray) {
        for (String string : stringArray) {
            this.d_fdsToPyroPredefMap.put(string, iQuantity);
        }
        if (iQuantity.get().getNumArgs() == 0) {
            this.d_pyroToFDSMap.put(iQuantity.get(), stringArray[0]);
        }
    }

    public IQuantity parseQuantity(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord, String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws FDSRecordFormatException {
        String string7 = fDSParseRecord.getString(string);
        if (string7 == null) {
            if (bl) {
                throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Quantity missing."));
            }
            return null;
        }
        Object var11_11 = string2 == null ? null : fDSParseRecord.get(string2);
        Object var12_12 = string3 == null ? null : fDSParseRecord.get(string3);
        Object var13_13 = string4 == null ? null : fDSParseRecord.get(string4);
        Object var14_14 = string5 == null ? null : fDSParseRecord.get(string5);
        Object var15_15 = string6 == null ? null : fDSParseRecord.get(string6);
        return this.parseQuantity(fDSParsingInfo, fDSParseRecord, string7, var11_11, var12_12, var13_13, var14_14, var15_15);
    }

    public IQuantity parseQuantity(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord, String string, Object object, Object object2, Object object3, Object object4, Object object5) throws FDSRecordFormatException {
        Serializable serializable2;
        IQuantity iQuantity = this.tryParseObjQuantity(fDSParsingInfo, fDSParseRecord, string, object, object2, object3, object4, object5);
        if (iQuantity != null) {
            return iQuantity;
        }
        iQuantity = this.d_fdsToPyroPredefMap.get(string);
        if (iQuantity != null) {
            return iQuantity;
        }
        for (Serializable serializable2 : this.d_fdsToPyroLegPostfixMap) {
            int n = string.indexOf((String)serializable2.v1);
            if (n <= 0) continue;
            String string2 = string.substring(0, n);
            assert (((Quantity)((Object)serializable2.v2)).requiredTypes.length == 1);
            try {
                IPyroObject iPyroObject = this.findObject(fDSParsingInfo, fDSParseRecord, ((Quantity)((Object)serializable2.v2)).requiredTypes[0], ((Quantity)((Object)serializable2.v2)).typeFilters[0], string2, string);
                return ((Quantity)((Object)serializable2.v2)).create(iPyroObject);
            }
            catch (FDSRecordFormatException fDSRecordFormatException) {
            }
        }
        ExSpec exSpec = fDSParsingInfo.findObject(ExSpec.class, string);
        if (exSpec != null) {
            return Quantity.SPEC_MASS_FRACTION.create(exSpec);
        }
        serializable2 = fDSParsingInfo.findObject(Material.class, string);
        if (serializable2 != null) {
            return Quantity.MATL_DENSITY.create(new IPyroObject[]{serializable2});
        }
        throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Unknown quantity: %s"), string));
    }

    private IQuantity tryParseObjQuantity(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord, String string, Object object, Object object2, Object object3, Object object4, Object object5) throws FDSRecordFormatException {
        Quantity quantity = this.d_fdsToPyroObjMap.get(string);
        if (quantity != null) {
            Object object6;
            IQuantity iQuantity = this.d_fdsToPyroPredefMap.get(string);
            boolean bl = iQuantity != null;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<IPyroObject> arrayList2 = new ArrayList<IPyroObject>(quantity.getNumArgs());
            for (int i = 0; i < quantity.getNumArgs(); ++i) {
                object6 = quantity.requiredTypes[i];
                int n = 1;
                for (int j = i + 1; j < quantity.getNumArgs() && quantity.requiredTypes[j].equals(object6); ++j) {
                    ++n;
                }
                Object object7 = QuantityMap.getObjVal(object6, object, object2, object3, object4, object5);
                for (int j = 0; j < n; ++j) {
                    String string2;
                    if (object7 == null) {
                        string2 = TVEntryPoints.ep(object6).getCategoryName();
                        arrayList.add(string2);
                        arrayList2.add(null);
                        continue;
                    }
                    string2 = object7 instanceof String ? (String)object7 : (String)((List)object7).get(j);
                    IPyroObject iPyroObject = this.findObject(fDSParsingInfo, fDSParseRecord, (Class)object6, quantity.typeFilters[i + j], string2, string);
                    arrayList2.add(iPyroObject);
                }
                i += n;
            }
            if (bl && arrayList.size() == quantity.requiredTypes.length) {
                return iQuantity;
            }
            if (!arrayList.isEmpty()) {
                String string3 = (String)arrayList.get(0);
                object6 = String.format(Intl.intl("Use of quantity, %1$s, requires a %2$s to be specified."), string, string3);
                throw new FDSRecordFormatException(fDSParseRecord, (String)object6);
            }
            assert (arrayList2.size() == quantity.requiredTypes.length);
            return quantity.create(arrayList2.toArray(new IPyroObject[arrayList2.size()]));
        }
        return null;
    }

    private IPyroObject findObject(FDSParsingInfo fDSParsingInfo, FDSParseRecord fDSParseRecord, Class clazz, IObjectFilter iObjectFilter, String string, String string2) throws FDSRecordFormatException {
        String string3 = TVEntryPoints.ep(clazz).getCategoryName();
        Object t = fDSParsingInfo.findObject(clazz, string);
        if (t == null) {
            String string4 = String.format(Intl.intl("Could not find %1$s, %2$s, needed for quantity, %3$s."), string3, string, string2);
            throw new FDSRecordFormatException(fDSParseRecord, string4);
        }
        if (iObjectFilter.shouldFilter(t)) {
            String string5 = String.format(Intl.intl("Invalid %1$s for quantity, %2$s: %3$s"), string3, string2, iObjectFilter.toString());
            throw new FDSRecordFormatException(fDSParseRecord, string5);
        }
        return t;
    }

    public void renderQuantity(FDSRenderRecord fDSRenderRecord, String string, String string2, String string3, String string4, String string5, String string6, IQuantity iQuantity) {
        if (iQuantity.get() == Quantity.MATL_DENSITY) {
            fDSRenderRecord.setValue(string, Util.getName(((ObjectQuantity)iQuantity).objects[0]));
            return;
        }
        String string7 = this.d_pyroToFDSMap.get((Object)iQuantity.get());
        assert (string7 != null);
        fDSRenderRecord.setValue(string, string7);
        if (iQuantity instanceof ObjectQuantity) {
            int n;
            ObjectQuantity objectQuantity = (ObjectQuantity)iQuantity;
            Quantity quantity = iQuantity.get();
            for (int i = 0; i < quantity.getNumArgs(); i += n) {
                Object object;
                Class<? extends IPyroObject> clazz = quantity.requiredTypes[i];
                n = 1;
                for (int j = i + 1; j < quantity.getNumArgs() && quantity.requiredTypes[j].equals(clazz); ++j) {
                    ++n;
                }
                ArrayList<String> arrayList = new ArrayList<String>(n);
                for (int j = 0; j < n; ++j) {
                    object = objectQuantity.objects[i + j];
                    arrayList.add(((INamed)object).getName());
                }
                String string8 = QuantityMap.getObjVal(clazz, string2, string3, string4, string5, string6);
                if (string8 == null || arrayList.size() <= 0) continue;
                object = fDSRenderRecord.getSpec().fields.get(string8);
                ArrayList<String> arrayList2 = object instanceof FDSRecordSpec.ListFld ? arrayList : arrayList.get(0);
                fDSRenderRecord.setValue(string8, arrayList2);
            }
        }
    }

    public Quantity getQuantity(String string) {
        IQuantity iQuantity = this.d_fdsToPyroPredefMap.get(string);
        if (iQuantity != null) {
            return iQuantity.get();
        }
        return this.d_fdsToPyroObjMap.get(string);
    }

    public String getFDSName(Quantity quantity) {
        return this.d_pyroToFDSMap.get((Object)quantity);
    }

    private static <T> T getObjVal(Class clazz, T t, T t2, T t3, T t4, T t5) {
        if (ExSpec.class.isAssignableFrom(clazz)) {
            return t2;
        }
        if (Particle.class.isAssignableFrom(clazz)) {
            return t;
        }
        if (Material.class.isAssignableFrom(clazz)) {
            return t3;
        }
        if (HvacNode.class.isAssignableFrom(clazz)) {
            return t5;
        }
        if (HvacDuct.class.isAssignableFrom(clazz)) {
            return t4;
        }
        return null;
    }
}

