/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class FDS5Colors {
    public static final String INVISIBLE = "INVISIBLE";
    private static final Map<String, Color> s_nameColorMap = new HashMap<String, Color>();
    private static final Map<Color, String> s_colorNameMap = new HashMap<Color, String>();

    public static Color getColor(String string) {
        return s_nameColorMap.get(string);
    }

    public static String getName(Color color) {
        return s_colorNameMap.get(color);
    }

    private static void readColors() {
        try {
            InputStream inputStream = FDS5Colors.class.getResourceAsStream("fdscolors.csv");
            if (inputStream == null) {
                System.err.println("fdscolors.csv resource could not be found.");
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (FDS5Colors.readColor(bufferedReader)) {
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean readColor(BufferedReader bufferedReader) throws Exception {
        String string = bufferedReader.readLine();
        if (string == null) {
            return false;
        }
        String[] stringArray = string.split("\\,");
        if (stringArray == null || stringArray.length < 4) {
            return true;
        }
        String string2 = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        int n3 = Integer.parseInt(stringArray[3]);
        int n4 = 255;
        if (stringArray.length > 4) {
            n4 = Integer.parseInt(stringArray[4]);
        }
        FDS5Colors.add(string2, n, n2, n3, n4);
        return true;
    }

    private static void add(String string, int n, int n2, int n3, int n4) {
        Color color = new Color(n, n2, n3, n4);
        s_nameColorMap.put(string, color);
        s_colorNameMap.put(color, string);
    }

    static {
        FDS5Colors.readColors();
    }
}

