/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.texture.Texture;
import pyrosim.legacy_2012_1.domain.texture.TextureDB;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.io.GE1File;
import pyrosim.legacy_2012_1.io.fds.FDSEnabledFilter;
import pyrosim.legacy_2012_1.io.fds.FDSRenderProps;
import pyrosim.legacy_2012_1.io.fds.IFDSRecordRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.util.Util;
import thunderheadeng.io.CopyFile;

public abstract class FDSRenderer {
    private final PyroMod d_model;

    private Collection<IPyroObject> collectPyroObjects() {
        ArrayList<APyroObject> arrayList = new ArrayList<APyroObject>();
        arrayList.add(this.d_model.getSimParams());
        arrayList.addAll(this.d_model.getObstructions().flatten());
        arrayList.addAll(this.d_model.getGridManager().flatten());
        arrayList.addAll(this.d_model.getZoneLeakMgr().flatten());
        arrayList.addAll(Util.sort(this.d_model.getZoneMgr()));
        arrayList.addAll(Util.sort(this.d_model.getExSpecList()));
        Reaction reaction = this.d_model.getReactions().getActiveReaction();
        if (reaction != null) {
            arrayList.add(reaction);
        }
        arrayList.addAll(this.d_model.getDevices().flatten());
        arrayList.add(this.d_model.getBoundaryOutput());
        arrayList.add(this.d_model.getPlot3d());
        arrayList.addAll(this.d_model.getIsofList().flatten());
        arrayList.addAll(this.d_model.getProfList().flatten());
        arrayList.addAll(this.d_model.getSlcfList().flatten());
        arrayList.addAll(this.d_model.getMsrStatMgr().flatten());
        arrayList.addAll(this.d_model.getHvacList().flatten());
        if (this.d_model.getFdsEvacEnabled()) {
            arrayList.addAll(this.d_model.getPersList().flatten());
            arrayList.addAll(this.d_model.getExitList().flatten());
            arrayList.addAll(this.d_model.getEvacList().flatten());
            arrayList.addAll(this.d_model.getEntrList().flatten());
            arrayList.addAll(this.d_model.getEvhoList().flatten());
            arrayList.addAll(this.d_model.getDoorList().flatten());
            arrayList.addAll(this.d_model.getCorrList().flatten());
            arrayList.addAll(this.d_model.getEvssList().flatten());
        }
        return new FilteredCollection<IPyroObject>(arrayList, IPyroObject.class, new FDSEnabledFilter());
    }

    public abstract void renderObjects(IFDSRecordRenderer var1, Collection<? extends IPyroObject> var2, DepSnapshot var3);

    protected abstract void renderFileForVersion(File var1, FDSRenderProps var2, Collection<? extends IPyroObject> var3, DepSnapshot var4) throws IOException;

    protected FDSRenderer(PyroMod pyroMod) {
        this.d_model = pyroMod;
    }

    protected PyroMod getModel() {
        return this.d_model;
    }

    public void renderFile(File file, FDSRenderProps fDSRenderProps) throws IOException {
        this.renderFile(file, fDSRenderProps, this.collectPyroObjects());
    }

    public void renderFile(File file, FDSRenderProps fDSRenderProps, Collection<? extends IPyroObject> collection) throws IOException {
        DepSnapshot depSnapshot = FDSRenderer.collectDependedOns(collection);
        this.renderFileForVersion(file, fDSRenderProps, collection, depSnapshot);
    }

    public void renderAllObjects(IFDSRecordRenderer iFDSRecordRenderer) {
        Collection<IPyroObject> collection = this.collectPyroObjects();
        this.renderObjects(iFDSRecordRenderer, collection);
    }

    public void renderObjects(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        DepSnapshot depSnapshot = FDSRenderer.collectDependedOns(collection);
        this.renderObjects(iFDSRecordRenderer, collection, depSnapshot);
    }

    public static DepSnapshot collectDependedOns(Collection<? extends IPyroObject> collection) {
        DepSnapshot depSnapshot = new DepSnapshot();
        for (IPyroObject iPyroObject : collection) {
            depSnapshot.takeSnapshot(iPyroObject);
        }
        depSnapshot.removeMappings(collection);
        return depSnapshot;
    }

    protected static boolean writeGE1(File file, String string, PyroMod pyroMod) throws IOException {
        return GE1File.writeFile(new File(file, string).getAbsolutePath(), pyroMod);
    }

    protected static void writeSmokeViewIni(File file, String string, boolean bl) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(file, string))));
        if (bl) {
            FDSRenderer.writeSVINIPref(printWriter, "BLOCKLOCATION", 5);
        }
        FDSRenderer.writeSVINIPref(printWriter, "SHOWNORMALWHENSMOOTH", 1);
        FDSRenderer.writeSVINIPref(printWriter, "SHOWALLTEXTURES", 1);
        printWriter.close();
    }

    private static void writeSVINIPref(PrintWriter printWriter, String string, Object object) {
        printWriter.println(string);
        printWriter.println(object.toString());
    }

    protected static void copyTextures(TextureDB textureDB, File file, Collection<? extends IPyroObject> collection) {
        String string;
        TextureInfo textureInfo;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (IPyroObject object : collection) {
            if (!(object instanceof Surface) || (textureInfo = ((Surface)object).getTextureInfo()) == null) continue;
            string = textureInfo.getTexID();
            treeSet.add(string);
        }
        for (String string2 : treeSet) {
            assert (textureDB.names().contains(string2));
            textureInfo = textureDB.getDefaultInfo(string2);
            if (textureInfo == null) continue;
            string = textureInfo.getTexID();
            Texture texture = textureDB.getTexture(string);
            File file2 = new File(file, string);
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            texture.getImage().save(file2.getAbsolutePath());
        }
    }

    protected static void copyFile(File file, File file2) throws IOException {
        CopyFile.copy(file, file2);
    }

    public static String getProperCHID(String string, int n) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        File file = new File(string2);
        int n2 = (string2 = file.getName()).lastIndexOf(46);
        if (n2 >= 0) {
            string2 = string2.substring(0, n2);
        }
        string2 = string2.replace('.', '_');
        if ((string2 = string2.replace(' ', '_')).length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static String getProperTitle(String string, int n) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }
}

