/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.PrintWriter;
import java.util.Map;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordSpec;
import pyrosim.legacy_2012_1.io.fds.FDSRenderProps;
import pyrosim.legacy_2012_1.io.fds.IFDSFieldRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.io.StringPrintWriter;

public class FDSRenderRecord
extends FDSRecord {
    static final long serialVersionUID = 1L;
    private String d_customText = null;

    public FDSRenderRecord(FDSRecordSpec fDSRecordSpec, boolean bl) {
        super(fDSRecordSpec, bl);
    }

    public static FDSRenderRecord fromParseRecord(FDSParseRecord fDSParseRecord) {
        FDSRenderRecord fDSRenderRecord = new FDSRenderRecord(fDSParseRecord.getSpec(), false);
        fDSRenderRecord.setComment(fDSParseRecord.getComment());
        for (FDSRecord.UnknownProp object : fDSParseRecord.getUnknownProps()) {
            fDSRenderRecord.addUnknownProp(object.key, object.values);
        }
        for (Map.Entry entry : fDSParseRecord.getProperties().entrySet()) {
            fDSRenderRecord.setValue((String)entry.getKey(), entry.getValue());
        }
        return fDSRenderRecord;
    }

    @Override
    public boolean empty() {
        return super.empty() && this.d_customText == null;
    }

    public void setCustomText(String string) {
        this.d_customText = string;
    }

    public String getCustomText() {
        return this.d_customText;
    }

    public String renderRecord(FDSRenderProps fDSRenderProps, IFDSFieldRenderer iFDSFieldRenderer) {
        StringPrintWriter stringPrintWriter = new StringPrintWriter();
        this.renderRecord(stringPrintWriter, fDSRenderProps, iFDSFieldRenderer);
        return stringPrintWriter.toString();
    }

    public void renderRecord(PrintWriter printWriter, FDSRenderProps fDSRenderProps, IFDSFieldRenderer iFDSFieldRenderer) {
        if (this.d_customText != null) {
            printWriter.println(this.d_customText);
            return;
        }
        printWriter.append("&");
        printWriter.append(this.getType());
        printWriter.append(" ");
        String string = fDSRenderProps.getFieldSep();
        int n = 0;
        for (Map.Entry<String, Object> entry : this.getProperties().entrySet()) {
            String string2 = this.renderToString(fDSRenderProps, entry.getKey(), entry.getValue());
            if (string2.length() <= 0) continue;
            if (n++ > 0) {
                printWriter.append(string);
            }
            iFDSFieldRenderer.render(printWriter, entry.getKey(), string2);
        }
        for (FDSRecord.UnknownProp unknownProp : this.getUnknownProps()) {
            if (n++ > 0) {
                printWriter.append(string);
            }
            printWriter.append(unknownProp.render());
        }
        printWriter.append("/");
        String string3 = this.getComment();
        if (string3 != null) {
            printWriter.append(" " + (String)string3);
        }
        printWriter.append(fDSRenderProps.getNewline());
    }

    protected String renderToString(FDSRenderProps fDSRenderProps, String string, Object object) {
        FDSRecordSpec.Field field = this.getSpec().fields.get(string);
        assert (field != null);
        try {
            return field.render(fDSRenderProps, object);
        }
        catch (Throwable throwable) {
            String string2 = String.format("Error rendering %s:%s", this.getType(), string);
            throw new RuntimeException(string2, throwable);
        }
    }
}

