/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Stack;
import pyrosim.legacy_2012_1.thunderheadeng.util.Formatter;

public class FDSRenderProps {
    private final Stack<Object> d_propStack;
    private final String d_newline;
    private boolean d_mergeFDSCells = true;
    private boolean d_expandBoundaryHoles = false;
    private IDecimalFormatter d_formatter = new ScientificFormatter();
    private boolean d_forcefullyInvokeMixFrac = false;
    private boolean d_renderMultiLine = false;
    private String d_fieldSep = ", ";

    public FDSRenderProps() {
        this.d_propStack = new Stack();
        this.d_newline = System.getProperty("line.separator");
    }

    public FDSRenderProps(pyrosim.io.fds.FDSRenderProps fDSRenderProps) {
        this();
        this.imprint(fDSRenderProps);
    }

    public void imprint(FDSRenderProps fDSRenderProps) {
        fDSRenderProps.pushProps();
        this.popProps(fDSRenderProps.d_propStack);
    }

    public void imprint(pyrosim.io.fds.FDSRenderProps fDSRenderProps) {
        fDSRenderProps.pushProps();
        this.popProps(fDSRenderProps.getProps());
    }

    public String getNewline() {
        return this.d_newline;
    }

    public void pushProps() {
        this.d_propStack.push(this.d_formatter);
        this.d_propStack.push(this.d_renderMultiLine);
        this.d_propStack.push(this.d_fieldSep);
        this.d_propStack.push(this.d_mergeFDSCells);
        this.d_propStack.push(this.d_forcefullyInvokeMixFrac);
        this.d_propStack.push(this.d_expandBoundaryHoles);
    }

    public void popProps() {
        this.popProps(this.d_propStack);
    }

    private void popProps(Stack<Object> stack) {
        this.d_expandBoundaryHoles = (Boolean)stack.pop();
        this.d_forcefullyInvokeMixFrac = (Boolean)stack.pop();
        this.d_mergeFDSCells = (Boolean)stack.pop();
        this.d_fieldSep = (String)stack.pop();
        this.d_renderMultiLine = (Boolean)stack.pop();
        this.d_formatter = (IDecimalFormatter)stack.pop();
    }

    public boolean expandBoundaryHoles() {
        return this.d_expandBoundaryHoles;
    }

    public void setExpandBoundaryHoles(boolean bl) {
        this.d_expandBoundaryHoles = bl;
    }

    public boolean mergeFDSCells() {
        return this.d_mergeFDSCells;
    }

    public void setMergeFDSCells(boolean bl) {
        this.d_mergeFDSCells = bl;
    }

    public void setDecimalFormatter(IDecimalFormatter iDecimalFormatter) {
        this.d_formatter = iDecimalFormatter;
    }

    public IDecimalFormatter getDecimalFormatter() {
        return this.d_formatter;
    }

    public boolean renderMultiLine() {
        return this.d_renderMultiLine;
    }

    public void setRenderMultiLine(boolean bl) {
        this.d_renderMultiLine = bl;
        this.d_fieldSep = this.d_renderMultiLine ? "," + this.d_newline + "      " : ", ";
    }

    public String getFieldSep() {
        return this.d_fieldSep;
    }

    public String renderDouble(double d) {
        return this.d_formatter.format(d);
    }

    public void setInvokeMixFrac(boolean bl) {
        this.d_forcefullyInvokeMixFrac = bl;
    }

    public boolean shouldInvokeMixFrac() {
        return this.d_forcefullyInvokeMixFrac;
    }

    public static class AlignedFormatter
    implements IDecimalFormatter {
        public final int width;
        public final int numDecimals;
        private final DecimalFormat d_format;

        public AlignedFormatter(int n, int n2) {
            this.width = n;
            this.numDecimals = n2;
            this.d_format = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
            char[] cArray = new char[n2 + 2];
            Arrays.fill(cArray, '0');
            cArray[1] = 46;
            this.d_format.applyPattern(new String(cArray));
        }

        @Override
        public String format(double d) {
            int n;
            String string = this.d_format.format(d);
            if (string.length() >= this.width) {
                return string;
            }
            char[] cArray = new char[this.width];
            int n2 = this.width - string.length();
            for (n = 0; n < n2; ++n) {
                cArray[n] = 32;
            }
            for (n = n2; n < this.width; ++n) {
                cArray[n] = string.charAt(n - n2);
            }
            return new String(cArray);
        }
    }

    public static class GeneralFormatter
    implements IDecimalFormatter {
        private final Formatter d_formatter;
        public final int precision;

        public GeneralFormatter(int n) {
            this.precision = n;
            this.d_formatter = new Formatter(Locale.US);
        }

        @Override
        public String format(double d) {
            return this.d_formatter.format(d, this.precision);
        }
    }

    @Deprecated
    public static class EasyReadFormatter
    implements IDecimalFormatter {
        private static final DecimalFormat DECIMAL_FORMAT_4 = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        private static final DecimalFormat DECIMAL_FORMAT_2;

        @Override
        public String format(double d) {
            if (Math.abs(d) >= 0.01 && Math.abs(d) <= 0.4999) {
                return DECIMAL_FORMAT_4.format(d);
            }
            if (Math.abs(d) >= 0.5 && Math.abs(d) <= 999.0 || d == 0.0) {
                return DECIMAL_FORMAT_2.format(d);
            }
            return ScientificFormatter.SCIENTIFIC_FORMAT.format(d);
        }

        static {
            DECIMAL_FORMAT_4.applyPattern("0.0000");
            DECIMAL_FORMAT_2 = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
            DECIMAL_FORMAT_2.applyPattern("0.00");
        }
    }

    public static class ScientificFormatter
    implements IDecimalFormatter {
        private static final DecimalFormat SCIENTIFIC_FORMAT = (DecimalFormat)DecimalFormat.getInstance(Locale.US);

        @Override
        public String format(double d) {
            return SCIENTIFIC_FORMAT.format(d);
        }

        static {
            SCIENTIFIC_FORMAT.applyPattern("0.0000000E000");
        }
    }

    public static interface IDecimalFormatter {
        public String format(double var1);
    }
}

