/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import pyrosim.Intl;
import pyrosim.legacy_2012_1.io.fds.FDSParseException;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordDebugInfo;

public class FDSRecordFormatException
extends FDSParseException {
    private static final long serialVersionUID = 3962159604886511887L;
    private final String d_error;

    public FDSRecordFormatException(String string) {
        super(null, 0, FDSRecordFormatException.constructErrorMessage(null, string));
        this.d_error = string;
    }

    public FDSRecordFormatException(FDSParseRecord fDSParseRecord) {
        super(FDSRecordFormatException.getFilename(fDSParseRecord), FDSRecordFormatException.getLineNum(fDSParseRecord), FDSRecordFormatException.constructErrorMessage(fDSParseRecord, null));
        this.d_error = "";
    }

    public FDSRecordFormatException(FDSParseRecord fDSParseRecord, String string) {
        super(FDSRecordFormatException.getFilename(fDSParseRecord), FDSRecordFormatException.getLineNum(fDSParseRecord), FDSRecordFormatException.constructErrorMessage(fDSParseRecord, string));
        this.d_error = string;
    }

    public String getError() {
        return this.d_error;
    }

    private static String getFilename(FDSParseRecord fDSParseRecord) {
        FDSRecordDebugInfo fDSRecordDebugInfo = fDSParseRecord.getDebugInfo();
        return fDSRecordDebugInfo != null ? fDSRecordDebugInfo.getFilename() : null;
    }

    private static int getLineNum(FDSParseRecord fDSParseRecord) {
        FDSRecordDebugInfo fDSRecordDebugInfo = fDSParseRecord.getDebugInfo();
        return fDSRecordDebugInfo != null ? fDSRecordDebugInfo.getBeginLineNum() : 0;
    }

    private static String constructErrorMessage(FDSParseRecord fDSParseRecord, String string) {
        String string2 = "";
        if (fDSParseRecord != null) {
            FDSRecordDebugInfo fDSRecordDebugInfo = fDSParseRecord.getDebugInfo();
            if (fDSRecordDebugInfo != null) {
                string2 = String.format(Intl.intl("Invalid %s record specified."), fDSParseRecord.getType());
                if (fDSRecordDebugInfo.getOriginalText() != null) {
                    string2 = string2 + "\n\n" + fDSRecordDebugInfo.getOriginalText() + "\n";
                }
            }
            if (string != null) {
                if (string2.length() > 0) {
                    string2 = string2 + "\n";
                }
                string2 = string2 + string;
            }
        } else {
            string2 = Intl.intl("Invalid record specified.");
        }
        return string2;
    }
}

