/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.io.fds.FDSRecordSpec;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public abstract class FDSRecord
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private String d_comment;
    private final FDSRecordSpec d_spec;
    private Map<String, Object> d_properties;
    private List<UnknownProp> d_unknownProps;

    public FDSRecord(FDSRecordSpec fDSRecordSpec, boolean bl) {
        this.d_spec = fDSRecordSpec;
        this.d_properties = new LinkedHashMap<String, Object>();
        if (bl) {
            this.init();
        }
    }

    public void init() {
        for (FDSRecordSpec.Field field : this.d_spec.fields.values()) {
            this.setValue(field.name, field.initialValue);
        }
    }

    public FDSRecordSpec getSpec() {
        return this.d_spec;
    }

    public String getType() {
        return this.d_spec.rectype;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.d_properties);
    }

    public boolean empty() {
        return this.d_properties.isEmpty() && (this.d_unknownProps == null || this.d_unknownProps.isEmpty());
    }

    public boolean contains(String string) {
        return this.d_properties.containsKey(string);
    }

    public <T> T get(String string) {
        return this.get(string, false);
    }

    public String getString(String string) {
        return (String)this.d_properties.get(string);
    }

    public <T> T get(String string, boolean bl) {
        Object object = this.d_properties.get(string);
        if (object == null && bl) {
            object = this.getSpec().fields.get((Object)string).initialValue;
        }
        return (T)object;
    }

    public void setValue(String string, Object object) {
        this.setValue(string, object, true);
    }

    public void setValue(String string, Object object, boolean bl) {
        if (object == null) {
            this.d_properties.remove(string);
            return;
        }
        assert (this.getSpec().fields.get(string) != null);
        assert (this.getSpec().fields.get((Object)string).clazz.isAssignableFrom(object.getClass()));
        if (!bl) {
            Object t = this.getSpec().fields.get((Object)string).initialValue;
            if (!object.equals(t)) {
                this.d_properties.put(string, object);
            }
        } else {
            this.d_properties.put(string, object);
        }
    }

    public String getComment() {
        return this.d_comment;
    }

    public void setComment(String string) {
        this.d_comment = string;
    }

    public void addUnknownProp(String string, List<String> list) {
        if (this.d_unknownProps == null) {
            this.d_unknownProps = new ArrayList<UnknownProp>(1);
        }
        this.d_unknownProps.add(new UnknownProp(string, list));
    }

    public Object clone() {
        try {
            FDSRecord fDSRecord = (FDSRecord)super.clone();
            fDSRecord.d_properties = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.d_properties.entrySet()) {
                fDSRecord.d_properties.put(entry.getKey(), entry.getValue());
            }
            if (this.d_unknownProps != null) {
                fDSRecord.d_unknownProps = new ArrayList<UnknownProp>(this.d_unknownProps);
            }
            return fDSRecord;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public List<UnknownProp> getUnknownProps() {
        return this.d_unknownProps == null ? Collections.EMPTY_LIST : this.d_unknownProps;
    }

    public DiffResult diff(FDSRecord fDSRecord) {
        HashSet<String> hashSet = Collections.EMPTY_SET;
        HashSet<String> hashSet2 = Collections.EMPTY_SET;
        HashSet<String> hashSet3 = Collections.EMPTY_SET;
        for (Map.Entry<String, Object> object : this.d_properties.entrySet()) {
            String string = object.getKey();
            Object object2 = object.getValue();
            if (fDSRecord.d_properties.containsKey(string)) {
                Object object3 = fDSRecord.d_properties.get(string);
                if (theUtil.equal(object2, object3)) continue;
                if (hashSet3 == Collections.EMPTY_SET) {
                    hashSet3 = new HashSet<String>();
                }
                hashSet3.add(string);
                continue;
            }
            if (hashSet == Collections.EMPTY_SET) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(string);
        }
        for (String string : fDSRecord.d_properties.keySet()) {
            if (this.d_properties.containsKey(string)) continue;
            if (hashSet2 == Collections.EMPTY_SET) {
                hashSet2 = new HashSet<String>();
            }
            hashSet2.add(string);
        }
        return new DiffResult((Set<String>)hashSet, (Set<String>)hashSet2, (Set<String>)hashSet3);
    }

    public static class DiffResult {
        public final Set<String> missing;
        public final Set<String> additional;
        public final Set<String> different;

        public DiffResult(Set<String> set, Set<String> set2, Set<String> set3) {
            this.missing = set;
            this.additional = set2;
            this.different = set3;
        }
    }

    public static class UnknownProp
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final String key;
        public final List<String> values;

        public UnknownProp(String string, List<String> list) {
            this.key = string;
            this.values = list;
        }

        public String render() {
            String string = this.key + "=";
            for (int i = 0; i < this.values.size(); ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + this.values.get(i);
            }
            return string;
        }

        public String renderVal() {
            String string = "";
            for (int i = 0; i < this.values.size(); ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + this.values.get(i);
            }
            return string;
        }
    }
}

