/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.util.Arrays;
import java.util.Collection;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParseResult;
import pyrosim.legacy_2012_1.io.fds.FDSParseWarning;

public class FDSParsingInfo {
    public static final int DBL_FAIL_ON_ERROR = 0;
    public static final int DBL_CONTINUE_ON_ERROR = 1;
    public static final int DEFAULT_DEBUG_LEVEL = 0;
    private final String d_parsingFile;
    private final PyroMod d_wContainer;
    private final Collection<PyroMod> d_rContainers;
    private int d_debugLevel;
    private final FDSParseResult d_parseResult = new FDSParseResult();

    public FDSParsingInfo(String string, PyroMod pyroMod, PyroMod pyroMod2) {
        this(string, pyroMod, pyroMod2, 0);
    }

    public FDSParsingInfo(String string, PyroMod pyroMod, PyroMod pyroMod2, int n) {
        this.d_parsingFile = string;
        this.d_debugLevel = n;
        this.d_wContainer = pyroMod;
        this.d_rContainers = pyroMod2 == pyroMod ? Arrays.asList(pyroMod) : Arrays.asList(pyroMod, pyroMod2);
    }

    public String getParsingFile() {
        return this.d_parsingFile;
    }

    public int getDebugLevel() {
        return this.d_debugLevel;
    }

    public PyroMod getContainer() {
        return this.d_wContainer;
    }

    public Collection<PyroMod> getSourceContainers() {
        return this.d_rContainers;
    }

    public FDSParseResult getParseResult() {
        return this.d_parseResult;
    }

    public static <T extends IPyroObject> T findObject(Class<T> clazz, String string, PyroMod ... pyroModArray) {
        return FDSParsingInfo.findObject(clazz, string, Arrays.asList(pyroModArray));
    }

    public static <T extends IPyroObject> T findObject(Class<T> clazz, String string, Collection<PyroMod> collection) {
        for (PyroMod pyroMod : collection) {
            T object;
            Composite<? extends IPyroObject> composite = FDSParsingInfo.getCategoryRoot(pyroMod, clazz);
            assert (composite != null);
            if (composite == null || (object = composite.find(string, clazz, true)) == null) continue;
            return object;
        }
        if (ExSpec.class.isAssignableFrom(clazz)) {
            for (ExSpecList.MixFrac mixFrac : ExSpecList.MixFrac.values()) {
                if (!mixFrac.name.equals(string)) continue;
                return (T)mixFrac.spec;
            }
        }
        return null;
    }

    private static Composite<? extends IPyroObject> getCategoryRoot(PyroMod pyroMod, Class clazz) {
        for (IPyroObject iPyroObject : pyroMod.getMembers()) {
            if (!(iPyroObject instanceof Composite) || !((Composite)iPyroObject).getType().isAssignableFrom(clazz)) continue;
            return (Composite)iPyroObject;
        }
        return null;
    }

    public <T extends IPyroObject> T findObject(Class<T> clazz, String string) {
        return FDSParsingInfo.findObject(clazz, string, this.d_rContainers);
    }

    public <T extends IPyroObject> T findReplacementObject(Class<T> clazz, String string) {
        return FDSParsingInfo.findObject(clazz, string, this.d_wContainer);
    }

    public void addWarning(FDSParseWarning fDSParseWarning) {
        this.d_parseResult.warningReport.addWarning(fDSParseWarning);
    }

    public void addWarning(FDSParseRecord fDSParseRecord, String string, String string2) {
        this.d_parseResult.warningReport.addWarning(new FDSParseWarning(fDSParseRecord, string, string2));
    }
}

