/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.io.fds.FDSGrammar;
import pyrosim.legacy_2012_1.io.fds.FDSParseException;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParseResult;
import pyrosim.legacy_2012_1.io.fds.FDSParsingInfo;
import pyrosim.legacy_2012_1.io.fds.FDSRecordSpec;
import pyrosim.legacy_2012_1.io.fds.FDSRenderProps;
import pyrosim.legacy_2012_1.io.fds.FDSRenderRecord;
import pyrosim.legacy_2012_1.io.fds.FDSStringRenderer;
import pyrosim.legacy_2012_1.io.fds.IFDSRecordParser;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;

public abstract class FDSParser {
    private static final String DECODER_NAME = "UTF-8";
    private static Charset CHARSET = Charset.forName("UTF-8");
    private static CharsetDecoder DECODER = CHARSET.newDecoder();

    protected abstract FDSParsingInfo createParsingInfo(String var1, PyroMod var2, PyroMod var3);

    protected abstract List<? extends IFDSRecordParser> createParsers(FDSParsingInfo var1);

    protected abstract Map<String, FDSRecordSpec> getRecordSpecs();

    protected abstract String getFinishRecType();

    public FDSParseResult parseFile(String string, PyroMod pyroMod) throws IOException, FDSParseException {
        return this.parseFile(string, pyroMod, pyroMod);
    }

    public FDSParseResult parseFile(String string, PyroMod pyroMod, PyroMod pyroMod2) throws IOException, FDSParseException {
        CharSequence charSequence = FDSParser.getBufferFromFile(string);
        return this.parseBuffer(string, charSequence, pyroMod, pyroMod2);
    }

    public FDSParseResult parseBuffer(CharSequence charSequence, PyroMod pyroMod) throws IOException, FDSParseException {
        return this.parseBuffer(charSequence, pyroMod, pyroMod);
    }

    public FDSParseResult parseBuffer(CharSequence charSequence, PyroMod pyroMod, PyroMod pyroMod2) throws IOException, FDSParseException {
        return this.parseBuffer(null, charSequence, pyroMod, pyroMod2);
    }

    public FDSParseResult parseRecords(List<FDSParseRecord> list, PyroMod pyroMod) throws IOException, FDSParseException {
        return this.parseRecords(list, pyroMod, pyroMod);
    }

    public FDSParseResult parseRecords(List<FDSParseRecord> list, PyroMod pyroMod, PyroMod pyroMod2) throws IOException, FDSParseException {
        FDSParsingInfo fDSParsingInfo = this.createParsingInfo(null, pyroMod, pyroMod2);
        this.parseRecords(list, (String)null, fDSParsingInfo);
        return fDSParsingInfo.getParseResult();
    }

    protected FDSParseResult parseBuffer(String string, CharSequence charSequence, PyroMod pyroMod, PyroMod pyroMod2) throws IOException, FDSParseException {
        FDSParsingInfo fDSParsingInfo = this.createParsingInfo(string, pyroMod, pyroMod2);
        return this.parseBuffer(string, charSequence, fDSParsingInfo);
    }

    protected FDSParseResult parseBuffer(String string, CharSequence charSequence, FDSParsingInfo fDSParsingInfo) throws IOException, FDSParseException {
        List<FDSParseRecord> list = FDSGrammar.parse(charSequence, string, fDSParsingInfo.getParseResult().warningReport, this.getRecordSpecs(), this.getFinishRecType());
        this.parseRecords(list, null, fDSParsingInfo);
        return fDSParsingInfo.getParseResult();
    }

    protected static CharSequence getBufferFromFile(String string) throws IOException, CharacterCodingException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), DECODER_NAME));){
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append(System.getProperty("line.separator"));
            }
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2;
        }
    }

    protected void parseRecords(List<FDSParseRecord> list, String string, FDSParsingInfo fDSParsingInfo) throws IOException, FDSParseException {
        fDSParsingInfo.getContainer().pauseUpdates(false);
        ArrayList<FDSParseRecord> arrayList = new ArrayList<FDSParseRecord>();
        this.parse(fDSParsingInfo, list, arrayList);
        if (!arrayList.isEmpty()) {
            String string2 = fDSParsingInfo.getContainer().getUnprocessedRecords();
            FDSStringRenderer fDSStringRenderer = new FDSStringRenderer(string2, new FDSRenderProps());
            for (FDSParseRecord fDSParseRecord : arrayList) {
                FDSRenderRecord fDSRenderRecord = FDSRenderRecord.fromParseRecord(fDSParseRecord);
                fDSStringRenderer.render(fDSRenderRecord, null);
            }
            fDSParsingInfo.getContainer().setUnprocessedRecords(fDSStringRenderer.toString());
        }
        fDSParsingInfo.getContainer().resumeUpdates();
        fDSParsingInfo.getContainer().getEvents().changed(fDSParsingInfo.getContainer(), PyroMod.EVT_FILENAME_CHANGED, PyroMod.EVT_MODEL_CHANGED);
    }

    /*
     * WARNING - void declaration
     */
    private void parse(FDSParsingInfo fDSParsingInfo, List<FDSParseRecord> list, List<FDSParseRecord> list2) throws FDSParseException {
        LinkedHashSet<FDSParseRecord> linkedHashSet;
        List<? extends IFDSRecordParser> list3 = this.createParsers(fDSParsingInfo);
        IdentityHashMap identityHashMap = new IdentityHashMap();
        for (IFDSRecordParser object32 : list3) {
            identityHashMap.put(object32, new ArrayList());
        }
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (IFDSRecordParser iFDSRecordParser : list3) {
            HashSet<String> hashSet = new HashSet<String>();
            iFDSRecordParser.getRecordTypes(hashSet);
            for (Object object : hashSet) {
                void var14_25;
                ArrayList<IFDSRecordParser> arrayList = (ArrayList<IFDSRecordParser>)hashMap.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<IFDSRecordParser>();
                    hashMap.put(object, arrayList);
                }
                arrayList.add(iFDSRecordParser);
                Set set = (Set)hashMap2.get(object);
                if (set == null) {
                    LinkedHashSet linkedHashSet2 = new LinkedHashSet();
                    hashMap2.put(object, linkedHashSet2);
                }
                iFDSRecordParser.getUnsupportedFields((String)object, (Set<String>)var14_25);
            }
        }
        for (FDSParseRecord fDSParseRecord : list) {
            List list4 = (List)hashMap.get(fDSParseRecord.getType());
            if (list4 == null) {
                fDSParsingInfo.addWarning(fDSParseRecord, String.format(Intl.intl("%s records are not yet supported."), fDSParseRecord.getType()), Intl.intl("Adding to additional records section."));
                list2.add(fDSParseRecord);
                continue;
            }
            linkedHashSet = new LinkedHashSet<FDSParseRecord>((Collection)hashMap2.get(fDSParseRecord.getType()));
            linkedHashSet.retainAll(fDSParseRecord.getProperties().keySet());
            if (!linkedHashSet.isEmpty()) {
                Object object;
                object = "";
                for (String string : linkedHashSet) {
                    if (((String)object).length() > 0) {
                        object = (String)object + ", ";
                    }
                    object = (String)object + string;
                }
                fDSParsingInfo.addWarning(fDSParseRecord, String.format(Intl.intl("These fields are not yet supported: %s"), object), Intl.intl("Ignoring unsupported fields."));
            }
            for (ArrayList<IFDSRecordParser> arrayList : list4) {
                ((List)identityHashMap.get(arrayList)).add(fDSParseRecord);
            }
        }
        IdentityHashSet identityHashSet = new IdentityHashSet();
        for (IFDSRecordParser iFDSRecordParser : list3) {
            linkedHashSet = (List)identityHashMap.get(iFDSRecordParser);
            iFDSRecordParser.process(linkedHashSet, identityHashSet);
        }
        for (IFDSRecordParser iFDSRecordParser : list3) {
            iFDSRecordParser.postProcess();
        }
        list2.addAll(identityHashSet);
    }
}

