/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FDSArray<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] d_dimensions;
    private final int[] d_dimMults;
    private final Object d_array;

    public FDSArray(int[] nArray) {
        this(null, nArray);
    }

    public FDSArray(T t, int[] nArray) {
        int n;
        int n2;
        assert (nArray.length > 0);
        this.d_dimensions = nArray;
        this.d_dimMults = new int[nArray.length];
        for (n2 = 0; n2 < this.d_dimMults.length; ++n2) {
            n = 1;
            int n3 = nArray.length - n2 - 1;
            for (int i = n3 - 1; i >= 0; --i) {
                n *= nArray[i];
            }
            this.d_dimMults[n3] = n;
        }
        n2 = this.d_dimMults[nArray.length - 1] * nArray[nArray.length - 1];
        this.d_array = Array.newInstance(Object.class, n2);
        if (t != null) {
            for (n = 0; n < n2; ++n) {
                Array.set(this.d_array, n, t);
            }
        }
    }

    public FDSArray(Collection<? extends T> collection) {
        this(new int[]{collection.size()});
        int n = 0;
        for (T t : collection) {
            this.set(n++, t);
        }
    }

    public FDSArray(T ... TArray) {
        this(new int[]{TArray.length});
        for (int i = 0; i < TArray.length; ++i) {
            this.set(i, TArray[i]);
        }
    }

    public boolean isEmpty() {
        int n = Array.getLength(this.d_array);
        for (int i = 0; i < n; ++i) {
            if (Array.get(this.d_array, i) == null) continue;
            return false;
        }
        return true;
    }

    public boolean isFrontPacked() {
        if (Array.get(this.d_array, 0) == null) {
            return false;
        }
        int n = Math.min(this.getDimensions()[0], this.getTotalLength());
        int n2 = 1;
        while (n2 < n && Array.get(this.d_array, n2++) != null) {
        }
        while (n2 < this.getTotalLength()) {
            if (Array.get(this.d_array, n2++) == null) continue;
            return false;
        }
        return true;
    }

    public List<T> getFrontPackedValsAsList() {
        if (!this.isFrontPacked()) {
            assert (false);
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.getDimensions()[0] && Array.get(this.d_array, n) != null) {
            arrayList.add(Array.get(this.d_array, n++));
        }
        return arrayList;
    }

    public T[] toFlatArray(T[] TArray) {
        for (int i = 0; i < this.getTotalLength(); ++i) {
            TArray[i] = Array.get(this.d_array, i);
        }
        return TArray;
    }

    public int[] getDimensions() {
        return this.d_dimensions;
    }

    public void set(T t, int[] nArray) {
        assert (nArray.length == this.d_dimensions.length);
        assert (this.isIndexValid(nArray));
        int n = this.getGlobalIx(nArray);
        Array.set(this.d_array, n, t);
    }

    public T get(int ... nArray) {
        assert (nArray.length == this.d_dimensions.length);
        assert (this.isIndexValid(nArray));
        int n = this.getGlobalIx(nArray);
        return (T)Array.get(this.d_array, n);
    }

    public void set(int n, T ... TArray) {
        for (int i = 0; i < TArray.length; ++i) {
            Array.set(this.d_array, i + n, TArray[i]);
        }
    }

    public void set(int n, List<? extends T> list) {
        for (int i = 0; i < list.size(); ++i) {
            Array.set(this.d_array, i + n, list.get(i));
        }
    }

    public int getTotalLength() {
        return Array.getLength(this.d_array);
    }

    public boolean isIndexValid(int ... nArray) {
        int n = this.getGlobalIx(nArray);
        return n >= 0 && n < Array.getLength(this.d_array);
    }

    private int getGlobalIx(int ... nArray) {
        assert (nArray.length == this.d_dimensions.length);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] * this.d_dimMults[i];
        }
        return n;
    }

    public Object getBaseArray() {
        return this.d_array;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FDSArray)) {
            return false;
        }
        FDSArray fDSArray = (FDSArray)object;
        if (!Arrays.equals(this.d_dimensions, fDSArray.d_dimensions)) {
            return false;
        }
        for (int i = 0; i < this.getTotalLength(); ++i) {
            boolean bl;
            Object object2 = Array.get(this.d_array, i);
            Object object3 = Array.get(fDSArray.d_array, i);
            boolean bl2 = object2 == null ? object3 == null : (bl = object2.equals(object3));
            if (bl) continue;
            return false;
        }
        return true;
    }

    public boolean containsNonNull() {
        int n = Array.getLength(this.d_array);
        for (int i = 0; i < n; ++i) {
            Object object = Array.get(this.d_array, i);
            if (object == null) continue;
            return true;
        }
        return false;
    }
}

