/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.vecmath.Point3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.FDSRun;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.ResultsArchive;
import pyrosim.legacy_2012_1.domain.Serialized;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.surf.AOutFlowSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.controls.AControl;
import pyrosim.legacy_2012_1.domain.controls.ADblCompareOp;
import pyrosim.legacy_2012_1.domain.controls.ALogicOp;
import pyrosim.legacy_2012_1.domain.controls.AndOp;
import pyrosim.legacy_2012_1.domain.controls.ControlBridge;
import pyrosim.legacy_2012_1.domain.controls.CustomCtrl;
import pyrosim.legacy_2012_1.domain.controls.DblLessThanOp;
import pyrosim.legacy_2012_1.domain.controls.IControl;
import pyrosim.legacy_2012_1.domain.controls.LatchCtrl;
import pyrosim.legacy_2012_1.domain.controls.NotOp;
import pyrosim.legacy_2012_1.domain.controls.OrOp;
import pyrosim.legacy_2012_1.domain.controls.TimeDelayCtrl;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.dependencies.Dependency;
import pyrosim.legacy_2012_1.domain.devices.AlarmInfo;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.TripFlags;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.Timer;
import pyrosim.legacy_2012_1.domain.devices.measurers.Clock;
import pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.IMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.MeasureOutInfo;
import pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Nozzle;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Sprinkler;
import pyrosim.legacy_2012_1.domain.evac.CorrList;
import pyrosim.legacy_2012_1.domain.evac.DoorList;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.output.IMeasurementStat;
import pyrosim.legacy_2012_1.domain.output.IsosurfaceMgr;
import pyrosim.legacy_2012_1.domain.output.Slice;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.Output;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.particle.SizeDistribution;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.domain.quantity.StaticQuantity;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.domain.signals.AOutPin;
import pyrosim.legacy_2012_1.domain.signals.IDoubleInPin;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ILatchable;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.domain.zones.Leak;
import pyrosim.legacy_2012_1.domain.zones.Zone;
import pyrosim.legacy_2012_1.domain.zones.ZoneMgr;
import pyrosim.legacy_2012_1.legacy.v22.domain.measure.Measurement;
import pyrosim.legacy_2012_1.legacy.v22.domain.measure.ObjectMeasurement;
import pyrosim.legacy_2012_1.legacy.v26.domain.output.AMeasurementStat;
import pyrosim.legacy_2012_1.legacy.v26.domain.output.GasMeasurementStat;
import pyrosim.legacy_2012_1.legacy.v26.domain.output.SolidMeasurementStat;
import pyrosim.legacy_2012_1.legacy.v28.domain.output.Isosurface;
import pyrosim.legacy_2012_1.legacy.v29.domain.devices.measurers.LayerMeasurer;
import pyrosim.legacy_2012_1.legacy.v30.domain.output.AMsrStat;
import pyrosim.legacy_2012_1.legacy.v30.domain.output.GasMsrStat;
import pyrosim.legacy_2012_1.legacy.v30.domain.output.SolidMsrStat;
import pyrosim.legacy_2012_1.legacy.v31.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AAlignedFDSObject;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AUnalignedFDSObject;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AbstractFDSObject;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AbstractFace;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AlignedBlock;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AlignedHole;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.FDSConvexPoly;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.Hole;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.IFace;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.Slab;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.Vent;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.Wall;
import pyrosim.legacy_2012_1.legacy.v31.domain.texture.BufferModelImage;
import pyrosim.legacy_2012_1.legacy.v31.domain.texture.FileModelImage;
import pyrosim.legacy_2012_1.legacy.v31.geom.Polygon;
import pyrosim.legacy_2012_1.legacy.v31.geom.Quad;
import pyrosim.legacy_2012_1.legacy.v36.domain.Ramp;
import pyrosim.legacy_2012_1.legacy.v39.domain.texture.ModelImage;
import pyrosim.legacy_2012_1.legacy.v42.domain.ExSpecList;
import pyrosim.legacy_2012_1.legacy.v42.domain.FloorManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.GridList;
import pyrosim.legacy_2012_1.legacy.v42.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.controls.ControlMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.devices.DeviceManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.devices.sprayers.SprayModelMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.evac.EntrList;
import pyrosim.legacy_2012_1.legacy.v42.domain.evac.EvacList;
import pyrosim.legacy_2012_1.legacy.v42.domain.evac.EvhoList;
import pyrosim.legacy_2012_1.legacy.v42.domain.evac.EvssList;
import pyrosim.legacy_2012_1.legacy.v42.domain.evac.ExitList;
import pyrosim.legacy_2012_1.legacy.v42.domain.geom.FDSComposite;
import pyrosim.legacy_2012_1.legacy.v42.domain.geom.FDSObjectManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.hvac.HvacList;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.ADepPyroList;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.ADepPyroSet;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.ADepPyroUniqueMap;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.APyroList;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.APyroManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.APyroMap;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.APyroSet;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.APyroUniqueMap;
import pyrosim.legacy_2012_1.legacy.v42.domain.managers.IPyroManager;
import pyrosim.legacy_2012_1.legacy.v42.domain.output.ProfList;
import pyrosim.legacy_2012_1.legacy.v42.domain.output.SliceList;
import pyrosim.legacy_2012_1.legacy.v42.domain.output.StatisticMgr;
import pyrosim.legacy_2012_1.legacy.v42.domain.particle.ParticleList;
import pyrosim.legacy_2012_1.legacy.v42.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.legacy.v42.domain.zones.LeakMgr;
import pyrosim.legacy_2012_1.legacy.v43.domain.Floor;
import pyrosim.legacy_2012_1.legacy.v45.domain.measure.AMeasurement;
import pyrosim.legacy_2012_1.legacy.v45.domain.measure.Measurements;
import pyrosim.legacy_2012_1.legacy.v45.domain.measure.ObjectMsr;
import pyrosim.legacy_2012_1.legacy.v45.domain.measure.StaticMsr;
import pyrosim.legacy_2012_1.thunderheadeng.TeciIO;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ExtrudedPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NGon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyLine;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.TransformedGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v5.geometry.objs.WallGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Warning;
import pyrosim.legacy_2012_1.thunderheadeng.util.WarningReport;
import pyrosim.legacy_2012_1.unitsystem.EnglishUS;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class PyroSimObjectInputStream
extends ObjectInputStream {
    public static final int CURR_VERSION = 48;
    public static final int TECI_VERSION = 7;
    public static final byte[] FORMAT_CODE;
    private final int d_version;
    private final int d_teciVersion;
    private String d_revision;
    private final TeciIO d_teciio;
    private final Set<String> d_fileSystemTextures;
    private final WarningReport<Warning> d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
    private final Map<UnitPoint3D, UnitPoint3D> d_pointMap = new HashMap<UnitPoint3D, UnitPoint3D>();
    private final Map<Point3d, Point3d> d_point3dMap = new HashMap<Point3d, Point3d>();
    private final Map<Color, Color> d_colorMap = new HashMap<Color, Color>();
    private final Map<String, String> d_strMap = new HashMap<String, String>();
    private final NavigableMap<Integer, Map<String, Class>> d_classLookup;
    private Map<String, IQuantity> d_pre23MsrMap = null;
    private List<ISignalSource> d_pre42SignalSources = null;
    private List<ISignalSink> d_pre42SignalSinks = null;
    private Unit d_pre29ObscurationUnitSIUS = Unit.ONE.divide(SI.METER).alternate("%/m");
    private Unit d_pre29ObscurationUnitEnglish = Unit.ONE.divide(NonSI.FOOT).label("%/ft");
    private Unit d_pre29AspirationUnit = Unit.ONE.alternate("%");
    private Set<SolidReaction.Rate.RefSpec> d_pre32RefSpecs = null;
    private Set<LiquidReaction> d_pre32InvalidReacs = null;
    private Set<Unit> d_obscurationUnits;

    public PyroSimObjectInputStream(InputStream inputStream, Set<String> set) throws IOException {
        super(inputStream);
        this.d_fileSystemTextures = set;
        byte[] byArray = new byte[FORMAT_CODE.length];
        this.read(byArray);
        String string = new String(byArray);
        this.d_version = Integer.parseInt(string.substring(3));
        if (this.d_version < 30) {
            this.d_teciVersion = 1;
            this.d_revision = "";
        } else {
            this.d_teciVersion = this.readInt();
            try {
                this.d_revision = (String)this.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                assert (false);
                this.d_revision = "";
            }
        }
        this.d_teciio = new TeciIO(this.d_teciVersion);
        this.enableResolveObject(true);
        this.d_classLookup = new TreeMap<Integer, Map<String, Class>>();
        this.initLegClasses();
    }

    public static int getVersion(ObjectInputStream objectInputStream) {
        return objectInputStream instanceof PyroSimObjectInputStream ? ((PyroSimObjectInputStream)objectInputStream).getVersion() : Integer.MAX_VALUE;
    }

    public boolean canOpenVersion() {
        return this.d_version >= 21;
    }

    public boolean isNewer() {
        return this.d_version > 48;
    }

    public String getRevision() {
        return this.d_revision;
    }

    public int getVersion() {
        return this.d_version;
    }

    public Serialized readModel() throws IOException, ClassNotFoundException {
        System.out.printf("loading model (PyroSim Version: %d; Teci Version: %d)%n", this.d_version, this.d_teciVersion);
        if (this.d_version < 21) {
            throw new IOException("[" + this.getClass().getName() + "] Unsupported model version.");
        }
        if (this.d_version < 23) {
            this.constructPre23MsrMap();
        }
        if (this.d_version < 32) {
            this.d_pre32RefSpecs = new IdentityHashSet<SolidReaction.Rate.RefSpec>();
            this.d_pre32InvalidReacs = new IdentityHashSet<LiquidReaction>();
        }
        if (this.d_version < 42) {
            this.d_pre42SignalSources = new ArrayList<ISignalSource>();
            this.d_pre42SignalSinks = new ArrayList<ISignalSink>();
        }
        Serialized serialized = (Serialized)this.readObject();
        this.initSerFields(serialized);
        this.updateData(serialized);
        this.fixSurfRefs(serialized);
        return serialized;
    }

    private void removeObjsFromInvalidGroups(Serialized serialized) {
        HashMap<IPyroObject, List<Composite>> hashMap = new HashMap<IPyroObject, List<Composite>>();
        PyroSimObjectInputStream.mapParents(serialized.obstructions, hashMap);
        HashSet<Composite> hashSet = new HashSet<Composite>();
        for (Map.Entry entry : hashMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            for (int i = 1; i < ((List)entry.getValue()).size(); ++i) {
                Composite composite = (Composite)((List)entry.getValue()).get(i);
                composite.remove((IPyroObject)entry.getKey());
                hashSet.add(composite);
            }
        }
        System.out.printf("Removed duplicate objects from %d groups.%n", hashSet.size());
    }

    private static void mapParents(Composite composite, Map<IPyroObject, List<Composite>> map) {
        for (IPyroObject iPyroObject : composite.getMembers(IPyroObject.class)) {
            List<Composite> list = map.get(iPyroObject);
            if (list == null) {
                list = new ArrayList<Composite>(2);
                map.put(iPyroObject, list);
            }
            if (!list.contains(composite)) {
                list.add(composite);
            }
            if (!(iPyroObject instanceof Composite)) continue;
            PyroSimObjectInputStream.mapParents((Composite)iPyroObject, map);
        }
    }

    private void initSerFields(Serialized serialized) {
        if (serialized.controls == null) {
            serialized.controls = new pyrosim.legacy_2012_1.domain.controls.ControlMgr();
        }
        if (this.d_version < 29) {
            serialized.controls = new pyrosim.legacy_2012_1.domain.controls.ControlMgr();
        }
        if (this.d_version < 31) {
            serialized.zones = new ZoneMgr();
            serialized.zones.addDefaults();
            serialized.zoneLeaks = new pyrosim.legacy_2012_1.domain.zones.LeakMgr();
            serialized.perss = new PersList();
            serialized.exits = new pyrosim.legacy_2012_1.domain.evac.ExitList();
            serialized.evacs = new pyrosim.legacy_2012_1.domain.evac.EvacList();
            serialized.entrs = new pyrosim.legacy_2012_1.domain.evac.EntrList();
            serialized.evhos = new pyrosim.legacy_2012_1.domain.evac.EvhoList();
            serialized.corrs = new CorrList();
            serialized.evsss = new pyrosim.legacy_2012_1.domain.evac.EvssList();
            serialized.doors = new DoorList();
            serialized.simParams.getMisc().initEvacProps(serialized.surfmgr);
        }
        if (serialized.msrStats == null) {
            serialized.msrStats = new pyrosim.legacy_2012_1.domain.output.StatisticMgr();
        }
        if (this.d_version < 36) {
            serialized.rastProps = new RasterizationOptions();
        }
        if (this.d_version < 37) {
            serialized.d_protect = false;
            serialized.d_protectPassHash = new byte[0];
        }
        if (this.d_version < 41) {
            serialized.hvacSystem = new pyrosim.legacy_2012_1.domain.hvac.HvacList();
        }
        if (this.d_version < 42) {
            serialized.resultsArchive = new ResultsArchive();
        }
        if (serialized.lastFDSRun == null) {
            serialized.lastFDSRun = new FDSRun();
        }
        this.initMissingSurfs(serialized);
    }

    private void updateData(Serialized serialized) {
        boolean bl;
        if (this.d_version < 25 && (bl = this.updatePre25ISOF(serialized.isosurfaces))) {
            this.d_warnings.addWarning(new Warning(Intl.intl("Mass flux isosurface for extra species detected.\nThis value was stored with an incorrect unit type."), Intl.intl("Value has been converted to the correct unit type.  Please verify.")));
        }
        if (this.d_version < 42) {
            this.fixPre42SourceSinkRefs();
        }
        if (this.d_version < 27) {
            this.updatePre27Stats(serialized);
        }
        if (this.d_version < 28) {
            this.removeV28DeprecatedQuantities(serialized);
            serialized.simParams.getFileOutput().convertPre28SpecToQuantity();
        }
        if (this.d_version < 29) {
            this.fixPre29LowerTemp(serialized);
            serialized.controls = this.createPre29Controls(serialized);
        }
        if (this.d_version < 32) {
            this.warnPre32Mats(serialized);
        }
        if (this.d_version < 37) {
            this.moveDropsPerSecData(serialized);
            this.fixPre37ZoneLeaks(serialized);
        }
        if (this.d_version < 39) {
            this.fixPre39DtInsert(serialized);
        }
        if (this.d_version < 40) {
            this.fixPre40Defaults(serialized);
        }
        if (this.d_version < 43) {
            this.sortManagers(serialized);
        }
        if (this.d_version < 47) {
            this.fixPre47DisabledReactions(serialized);
        }
        if (this.d_version < 48) {
            this.fixPre48TextureInfos(serialized);
        }
    }

    public WarningReport<Warning> getWarnings() {
        return this.d_warnings;
    }

    private void initMissingSurfs(Serialized serialized) {
        pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager surfaceManager = new pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager();
        surfaceManager.addPredefined();
        for (Surface surface : surfaceManager.flatten()) {
            if (!surface.isPredefined() || serialized.surfmgr.get(surface.getName()) != null) continue;
            serialized.surfmgr.add(surface);
        }
    }

    private void fixPre47DisabledReactions(Serialized serialized) {
        boolean bl = false;
        for (Object object : serialized.reactions.flatten()) {
            if (((APyroObject)object).isEnabled()) continue;
            bl = true;
            ((APyroObject)object).setEnabled(true);
        }
        if (bl) {
            Object object;
            String string = Intl.intl("Reactions can no longer be disabled - they can only be made \"active\" and \"inactive.\"");
            object = Intl.intl("Re-enabled all reactions.");
            this.getWarnings().addWarning(new Warning(string, (String)object));
        }
    }

    private void fixPre48TextureInfos(Serialized serialized) {
        for (Surface surface : serialized.surfmgr.flatten()) {
            TextureInfo textureInfo = surface.getTextureInfo();
            if (textureInfo == null || serialized.textures.getTexture(textureInfo.getTexID()) != null || this.d_fileSystemTextures.contains(textureInfo.getTexID())) continue;
            surface.setTexture(null);
            String string = String.format(Intl.intl("Could not find texture for surface, %1$s: %2$s"), surface.getName(), textureInfo.getTexID());
            String string2 = Intl.intl("Removed texture from surface.");
            this.getWarnings().addWarning(new Warning(string, string2));
        }
    }

    private void moveDropsPerSecData(Serialized serialized) {
        IParticleDesc iParticleDesc;
        Serializable serializable;
        for (NamedPyroObject namedPyroObject : serialized.sprayModels.flatten()) {
            serializable = ((SprayModel)namedPyroObject).getParticle();
            iParticleDesc = serializable.getDescription();
            if (!(iParticleDesc instanceof GenericPartDesc)) continue;
            GenericPartDesc genericPartDesc = (GenericPartDesc)iParticleDesc;
            ((SprayModel)namedPyroObject).setDropsPerSecond(genericPartDesc.d_dropsPerSec);
        }
        for (NamedPyroObject namedPyroObject : serialized.particles.flatten()) {
            serializable = ((Particle)namedPyroObject).getDescription();
            if (!(serializable instanceof GenericPartDesc)) continue;
            iParticleDesc = (GenericPartDesc)serializable;
            try {
                pyrosim.legacy_2012_1.util.Util.assignFinalField(iParticleDesc, "d_dropsPerSec", -1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void fixPre37ZoneLeaks(Serialized serialized) {
        ArrayList<Leak> arrayList = new ArrayList<Leak>();
        for (Leak leak : serialized.zoneLeaks.flatten()) {
            Zone zone = (Zone)serialized.zones.get(leak.zone1.getName());
            Zone zone2 = (Zone)serialized.zones.get(leak.zone2.getName());
            if (zone == leak.zone1 && zone2 == leak.zone2) continue;
            arrayList.add(leak);
        }
        serialized.zoneLeaks.removeAll(arrayList);
    }

    private void fixPre39DtInsert(Serialized serialized) {
        Serializable serializable;
        for (NamedPyroObject namedPyroObject : serialized.surfmgr.flatten()) {
            ParticleInjection particleInjection;
            serializable = ((Surface)namedPyroObject).getSurfDesc();
            if (!(serializable instanceof AOutFlowSurfDesc) || (particleInjection = ((AOutFlowSurfDesc)serializable).d_partInj) == null) continue;
            Particle particle = particleInjection.getParticle();
            try {
                pyrosim.legacy_2012_1.util.Util.assignFinalField(particleInjection, "d_dtInsert", particle.getDescription().getOutput().d_dtInsert);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (NamedPyroObject namedPyroObject : serialized.sprayModels.flatten()) {
            serializable = ((SprayModel)namedPyroObject).getParticle();
            if (serializable == null) continue;
            ((SprayModel)namedPyroObject).setDtInsert(((Particle)serializable).getDescription().getOutput().d_dtInsert);
        }
    }

    private void fixPre40Defaults(Serialized serialized) {
        for (Particle particle : serialized.particles.flatten()) {
            IParticleDesc iParticleDesc = particle.getDescription();
            Output output = iParticleDesc.getOutput();
            if (output.d_samplingFactor != -1) continue;
            int n = particle.isMassless() ? 1 : 10;
            output = new Output(output.d_age, n);
            IParticleDesc iParticleDesc2 = iParticleDesc.setOutput(output);
            particle.setDescription(iParticleDesc2);
        }
    }

    private void sortManagers(Serialized serialized) {
        ArrayList<Composite> arrayList = new ArrayList<Composite>(Hierarchy.flatten(PyroMod.getMembers(serialized, true), Composite.class));
        for (Composite composite : arrayList) {
            Class clazz = composite.getType();
            if (clazz.isAssignableFrom(FDSObject.class) || clazz.isAssignableFrom(Grid.class) || !INamed.class.isAssignableFrom(clazz)) continue;
            List<IPyroObject> list = pyrosim.legacy_2012_1.util.Util.sort(composite.getMembers());
            composite.reorder(list);
        }
    }

    private void fixPre29LowerTemp(Serialized serialized) {
        for (FDSObject iNamed : ((APyroObject)serialized.obstructions).flatten(FDSObject.class)) {
            this.fixPre29LowerTemp(iNamed.getInputPin());
        }
        for (Nozzle nozzle : ((APyroObject)serialized.devices).flatten(Nozzle.class)) {
            this.fixPre29LowerTemp(nozzle.getInputPin());
        }
    }

    private void fixPre29LowerTemp(IInPin iInPin) {
        Unit unit = SIUS.getInstance().getLengthUnit();
        Unit unit2 = EnglishUS.getInstance().getLengthUnit();
        for (IOutPin iOutPin : iInPin.getConnections()) {
            Object object;
            ISignalSink iSignalSink;
            boolean bl = false;
            if (iOutPin.getAttachedSource() instanceof ISignalSink && (iSignalSink = (ISignalSink)((Object)iOutPin.getAttachedSource())).getInputPin().getConnections().size() == 1 && (object = iSignalSink.getInputPin().getConnectedSources().iterator().next()) instanceof pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer && ((pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer)object).getLowerTempInfo().getPin() == iSignalSink.getInputPin().getConnections().iterator().next()) {
                bl = true;
            }
            if (iOutPin.getAttachedSource() instanceof ADblCompareOp && bl) {
                iSignalSink = (ADblCompareOp)iOutPin.getAttachedSource();
                object = (IDoubleInPin)((ADblCompareOp)iSignalSink).getInputPin();
                if (((ADblCompareOp)iSignalSink).getN().getUnit().equals(unit)) {
                    object.changeInputUnits(SIUS.getInstance());
                } else if (((ADblCompareOp)iSignalSink).getN().getUnit().equals(unit2)) {
                    object.changeInputUnits(EnglishUS.getInstance());
                }
            } else if (iOutPin.getAttachedSource() instanceof CustomCtrl && bl && ((CustomCtrl)(iSignalSink = (CustomCtrl)iOutPin.getAttachedSource())).getTripValues().size() >= 1) {
                object = (IDoubleInPin)((CustomCtrl)iSignalSink).getInputPin();
                Unit unit3 = ((CustomCtrl)iSignalSink).getTripValues().first().getUnit();
                if (unit3.equals(unit)) {
                    object.changeInputUnits(SIUS.getInstance());
                } else if (unit3.equals(unit2)) {
                    object.changeInputUnits(EnglishUS.getInstance());
                }
            }
            if (!(iOutPin.getAttachedSource() instanceof ISignalSink)) continue;
            this.fixPre29LowerTemp(((ISignalSink)((Object)iOutPin.getAttachedSource())).getInputPin());
        }
    }

    /*
     * WARNING - void declaration
     */
    private pyrosim.legacy_2012_1.domain.controls.ControlMgr createPre29Controls(Serialized serialized) {
        void var5_11;
        Object object2;
        ArrayList<INamed> arrayList = new ArrayList<INamed>();
        arrayList.addAll(((APyroObject)serialized.obstructions).flatten(FDSObject.class));
        arrayList.addAll(((APyroObject)serialized.devices).flatten(Nozzle.class));
        IdentityHashMap<IDevice, Pre29DevcWrapper> identityHashMap = new IdentityHashMap<IDevice, Pre29DevcWrapper>();
        for (ISignalSink map2 : arrayList) {
            PyroSimObjectInputStream.wrapPre29Devices(identityHashMap, map2.getInputPin(), null);
        }
        boolean bl = false;
        if (!identityHashMap.isEmpty()) {
            System.out.println("Converted control logic to the new control system.");
            bl = true;
        }
        if (bl) {
            for (Object object2 : identityHashMap.values()) {
                PyroSimObjectInputStream.unwrapPre29Device(serialized, (Pre29DevcWrapper)object2);
            }
        }
        LinkedHashMap<IOutPin, List<IInPin>> linkedHashMap = new LinkedHashMap<IOutPin, List<IInPin>>();
        PyroSimObjectInputStream.disconnectControls(arrayList, linkedHashMap);
        if (bl) {
            Map<IOutPin, List<IInPin>> map = this.convertPre29Controls(linkedHashMap);
        }
        object2 = new pyrosim.legacy_2012_1.domain.controls.ControlMgr();
        for (Map.Entry entry : var5_11.entrySet()) {
            ControlBridge controlBridge = new ControlBridge(Intl.intl("CTRL"));
            Util.autoRename(object2, controlBridge);
            controlBridge.getInputPin().connect((IOutPin)entry.getKey());
            IOutPin iOutPin = controlBridge.getOutputPins().get(0);
            for (IInPin iInPin : (List)entry.getValue()) {
                iInPin.connect(iOutPin);
            }
            ((Composite)object2).add(controlBridge);
        }
        return object2;
    }

    private static void wrapPre29Devices(Map<IDevice, Pre29DevcWrapper> map, IInPin iInPin, IInPin iInPin2) {
        boolean bl = false;
        for (IOutPin iOutPin : iInPin.getConnections()) {
            Object object;
            INamed iNamed;
            AControl aControl = null;
            AlarmInfo alarmInfo = null;
            if (iOutPin.getAttachedSource() instanceof CustomCtrl) {
                iNamed = (CustomCtrl)iOutPin.getAttachedSource();
                if (iNamed.getTripValues().size() == 1) {
                    aControl = iNamed;
                    alarmInfo = new AlarmInfo((UnitDouble)iNamed.getTripValues().iterator().next(), TripFlags.toFlags(bl, iNamed.getInitialState()));
                }
            } else if (iOutPin.getAttachedSource() instanceof ADblCompareOp) {
                iNamed = (ADblCompareOp)iOutPin.getAttachedSource();
                boolean bl2 = iNamed instanceof DblLessThanOp;
                aControl = iNamed;
                alarmInfo = new AlarmInfo(((ADblCompareOp)iNamed).getN(), TripFlags.toFlags(bl, bl2));
            }
            iNamed = null;
            IOutPin iOutPin2 = null;
            if (aControl != null && alarmInfo != null && aControl.getInputPin().getConnections().size() == 1 && (object = (iOutPin2 = aControl.getInputPin().getConnections().iterator().next()).getAttachedSource()) instanceof IMeasurer) {
                iNamed = (IMeasurer)object;
            }
            if (iNamed != null && iOutPin2 != null) {
                object = map.get(iNamed);
                if (object == null) {
                    object = new Pre29DevcWrapper((IMeasurer)iNamed);
                    map.put((IDevice)iNamed, (Pre29DevcWrapper)object);
                }
                int n = -1;
                for (int i = 0; i < iNamed.getNumMeasurements(); ++i) {
                    if (iNamed.getMsrInfo(i).getPin() != iOutPin2) continue;
                    n = i;
                    break;
                }
                assert (n != -1);
                ArrayList<PinReplacement> arrayList = (ArrayList<PinReplacement>)((Pre29DevcWrapper)object).alarmMaps[n].get(alarmInfo);
                if (arrayList == null) {
                    arrayList = new ArrayList<PinReplacement>();
                    ((Pre29DevcWrapper)object).alarmMaps[n].put(alarmInfo, arrayList);
                }
                IInPin iInPin3 = bl ? iInPin2 : iInPin;
                IOutPin iOutPin3 = bl ? ((LatchCtrl)iInPin.getAttachedSink()).getOutputPins().get(0) : aControl.getOutputPins().get(0);
                arrayList.add(new PinReplacement(iOutPin3, iInPin3));
                continue;
            }
            if (!(iOutPin.getAttachedSource() instanceof ISignalSink)) continue;
            object = iOutPin.getAttachedSource() instanceof LatchCtrl ? iInPin : null;
            PyroSimObjectInputStream.wrapPre29Devices(map, ((ISignalSink)((Object)iOutPin.getAttachedSource())).getInputPin(), (IInPin)object);
        }
    }

    private static void unwrapPre29Device(Serialized serialized, Pre29DevcWrapper pre29DevcWrapper) {
        if (pre29DevcWrapper.devc instanceof Clock) {
            assert (pre29DevcWrapper.alarmMaps.length == 1);
            for (Map.Entry entry : pre29DevcWrapper.alarmMaps[0].entrySet()) {
                AlarmInfo alarmInfo = (AlarmInfo)entry.getKey();
                List list = (List)entry.getValue();
                Timer timer = new Timer(alarmInfo.setpoint, TripFlags.initiallyOn(alarmInfo.tripFlags));
                IOutPin iOutPin = timer.getOutputPins().get(0);
                for (PinReplacement pinReplacement : list) {
                    ((IInPin)pinReplacement.v2).disconnect((IOutPin)pinReplacement.v1);
                    ((IInPin)pinReplacement.v2).connect(iOutPin);
                }
            }
            return;
        }
        ArrayList<IMeasurer> arrayList = new ArrayList<IMeasurer>();
        arrayList.add(pre29DevcWrapper.devc);
        for (int i = 0; i < pre29DevcWrapper.alarmMaps.length; ++i) {
            int n = 0;
            for (Map.Entry entry : pre29DevcWrapper.alarmMaps[i].entrySet()) {
                IMeasurer iMeasurer;
                if (n >= arrayList.size()) {
                    iMeasurer = (IMeasurer)pre29DevcWrapper.devc.clone();
                    for (int j = 0; j < iMeasurer.getNumMeasurements(); ++j) {
                        iMeasurer.getMsrInfo(j).setAlarmInfo(null);
                    }
                    Util.autoRename(serialized.devices, iMeasurer);
                    serialized.devices.add(iMeasurer);
                    arrayList.add(iMeasurer);
                }
                iMeasurer = (IMeasurer)arrayList.get(n++);
                AlarmInfo alarmInfo = (AlarmInfo)entry.getKey();
                List list = (List)entry.getValue();
                MeasureOutInfo measureOutInfo = iMeasurer.getMsrInfo(i);
                measureOutInfo.setAlarmInfo(alarmInfo);
                LogicOutPin logicOutPin = measureOutInfo.getAlarmPin();
                for (PinReplacement pinReplacement : list) {
                    ((IInPin)pinReplacement.v2).disconnect((IOutPin)pinReplacement.v1);
                    ((IInPin)pinReplacement.v2).connect(logicOutPin);
                }
            }
        }
    }

    private static void disconnectControls(Collection<? extends ISignalSink> collection, Map<IOutPin, List<IInPin>> map) {
        for (ISignalSink iSignalSink : collection) {
            for (IOutPin iOutPin : iSignalSink.getInputPin().getConnections()) {
                List<IInPin> list = map.get(iOutPin);
                if (list == null) {
                    list = new ArrayList<IInPin>(1);
                    map.put(iOutPin, list);
                }
                list.add(iSignalSink.getInputPin());
            }
            iSignalSink.getInputPin().disconnectAll();
        }
    }

    private Map<IOutPin, List<IInPin>> convertPre29Controls(Map<IOutPin, List<IInPin>> map) {
        LinkedHashMap<IOutPin, List<IInPin>> linkedHashMap = new LinkedHashMap<IOutPin, List<IInPin>>(map.size());
        for (Map.Entry<IOutPin, List<IInPin>> entry : map.entrySet()) {
            IOutPin iOutPin = this.convertPre29Control(entry.getKey());
            List list = (List)linkedHashMap.get(iOutPin);
            if (list != null) {
                list.addAll((Collection)entry.getValue());
                continue;
            }
            linkedHashMap.put(iOutPin, entry.getValue());
        }
        return linkedHashMap;
    }

    /*
     * WARNING - void declaration
     */
    private IOutPin convertPre29Control(IOutPin iOutPin) {
        if (!(iOutPin.getAttachedSource() instanceof AndOp) && !(iOutPin.getAttachedSource() instanceof OrOp)) {
            return iOutPin;
        }
        boolean bl = iOutPin.getAttachedSource() instanceof AndOp;
        Set<? extends IOutPin> set = ((IControl)iOutPin.getAttachedSource()).getInputPin().getConnections();
        if (set.size() > 1) {
            ArrayList<void> arrayList = new ArrayList<void>(set.size());
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            UnitDouble unitDouble = null;
            for (IOutPin iOutPin2 : set) {
                void object;
                void var10_15;
                void var10_13;
                if (iOutPin2.getAttachedSource() instanceof NotOp && ((NotOp)iOutPin2.getAttachedSource()).getInputPin().getConnections().size() == 1) {
                    ++n;
                    IOutPin iOutPin3 = ((NotOp)iOutPin2.getAttachedSource()).getInputPin().getConnections().iterator().next();
                }
                if (var10_13.getAttachedSource() instanceof TimeDelayCtrl && (unitDouble == null || unitDouble.equals(((TimeDelayCtrl)var10_13.getAttachedSource()).getTimeDelay())) && ((TimeDelayCtrl)var10_13.getAttachedSource()).getInputPin().getConnections().size() == 1) {
                    ++n3;
                    TimeDelayCtrl timeDelayCtrl = (TimeDelayCtrl)var10_13.getAttachedSource();
                    unitDouble = timeDelayCtrl.getTimeDelay();
                    IOutPin iOutPin4 = timeDelayCtrl.getInputPin().getConnections().iterator().next();
                }
                if (var10_15.getAttachedSource() instanceof LatchCtrl && ((LatchCtrl)var10_15.getAttachedSource()).getInputPin().getConnections().size() == 1) {
                    ++n2;
                    IOutPin iOutPin5 = ((LatchCtrl)var10_15.getAttachedSource()).getInputPin().getConnections().iterator().next();
                }
                if (!(object.getAttachedSource() instanceof IDevice) || object.getAttachedSource() instanceof Timer) continue;
                arrayList.add(object);
            }
            if (!(n2 != set.size() || arrayList.size() != set.size() || n != 0 && n != set.size() || n3 != 0 && n3 != set.size())) {
                void var10_23;
                AControl aControl;
                if (n > 0) {
                    bl = !bl;
                }
                ALogicOp aLogicOp = bl ? new AndOp() : new OrOp();
                for (IOutPin iOutPin6 : arrayList) {
                    aLogicOp.getInputPin().connect(iOutPin6);
                }
                IOutPin iOutPin7 = aLogicOp.getOutputPins().get(0);
                LatchCtrl latchCtrl = new LatchCtrl();
                latchCtrl.getInputPin().connect(iOutPin7);
                IOutPin iOutPin8 = latchCtrl.getOutputPins().get(0);
                if (n3 > 0 && unitDouble.getValueNoUnit() != 0.0) {
                    aControl = new TimeDelayCtrl(unitDouble);
                    ((TimeDelayCtrl)aControl).getInputPin().connect(iOutPin8);
                    IOutPin iOutPin9 = ((TimeDelayCtrl)aControl).getOutputPins().get(0);
                }
                if (n > 0) {
                    void var10_21;
                    aControl = new NotOp();
                    ((NotOp)aControl).getInputPin().connect((IOutPin)var10_21);
                    IOutPin iOutPin10 = ((NotOp)aControl).getOutputPins().get(0);
                }
                return var10_23;
            }
        }
        return iOutPin;
    }

    private void warnPre32Mats(Serialized serialized) {
        String string;
        Object object;
        ArrayList arrayList = new ArrayList();
        for (Object object2 : serialized.matmgr.flatten()) {
            if (!this.usesOldSpec((Material)object2)) continue;
            arrayList.add(object2);
        }
        if (!arrayList.isEmpty()) {
            object = Intl.intl("No action taken.  Please review the material.");
            for (Material serializable : arrayList) {
                string = String.format(Intl.intl("Material %s: reaction reference rates are no longer supported starting in FDS 5.4.0."), serializable.getName());
                this.d_warnings.addWarning(new Warning(string, (String)object));
            }
        }
        arrayList.clear();
        for (Object object2 : serialized.matmgr.flatten()) {
            if (!(((Material)object2).getPyrolysis() instanceof LiquidPyrolysis)) continue;
            LiquidPyrolysis liquidPyrolysis = (LiquidPyrolysis)((Material)object2).getPyrolysis();
            if (!this.d_pre32InvalidReacs.contains(liquidPyrolysis.d_reaction)) continue;
            arrayList.add(object2);
        }
        if (!arrayList.isEmpty()) {
            object = String.format(Intl.intl("Assigned a heat of vaporization of %s."), Global.format(SIUS.newud(0.0, 46)));
            for (Material material : arrayList) {
                string = String.format(Intl.intl("Material %s: liquid materials must specify a heat of vaporization starting with FDS 5.4.0."), material.getName());
                this.d_warnings.addWarning(new Warning(string, (String)object));
            }
        }
    }

    private boolean usesOldSpec(Material material) {
        if (material.getPyrolysis() instanceof SolidPyrolysis) {
            for (SolidReaction solidReaction : ((SolidPyrolysis)material.getPyrolysis()).getReactions()) {
                if (!this.d_pre32RefSpecs.contains(solidReaction.d_rate.d_spec)) continue;
                return true;
            }
        }
        return false;
    }

    private void fixSurfRefs(Serialized serialized) {
        ArrayList<INamed> arrayList = new ArrayList<INamed>();
        int n = 0;
        for (FDSObject fDSObject : ((APyroObject)serialized.obstructions).flatten(FDSObject.class)) {
            Object object;
            INamed iNamed;
            if (fDSObject instanceof IObstruction) {
                int n2 = 0;
                iNamed = (IObstruction)fDSObject;
                object = iNamed.getSurfaces();
                for (int i = 0; i < ((Surface[])object).length; ++i) {
                    Surface surface = object[i];
                    Surface surface2 = (Surface)serialized.surfmgr.get(surface.getName());
                    if (surface2 == null) {
                        serialized.surfmgr.add(surface);
                        arrayList.add(surface);
                        continue;
                    }
                    if (surface == surface2) continue;
                    object[i] = surface2;
                    ++n2;
                }
                if (n2 > 0) {
                    iNamed.setSurfaces((Surface[])object);
                }
                n += n2;
                continue;
            }
            if (!(fDSObject instanceof pyrosim.legacy_2012_1.domain.geom.Vent)) continue;
            pyrosim.legacy_2012_1.domain.geom.Vent vent = (pyrosim.legacy_2012_1.domain.geom.Vent)fDSObject;
            iNamed = vent.getSurface();
            object = (Surface)serialized.surfmgr.get(((NamedPyroObject)iNamed).getName());
            if (object == null) {
                serialized.surfmgr.add(iNamed);
                arrayList.add(iNamed);
                continue;
            }
            if (iNamed == object) continue;
            vent.setSurface((Surface)object);
            ++n;
        }
        if (n > 0) {
            System.err.println("Fixed " + n + " invalid surface references.");
        }
        if (!arrayList.isEmpty()) {
            Object object = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i > 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + ((Surface)arrayList.get(i)).getName();
            }
            String string = String.format(Intl.intl("Found %d surface(s) missing from the model: %s"), arrayList.size(), object);
            String string2 = Intl.intl("Added extra surfaces to the model.");
            this.d_warnings.addWarning(new Warning(string, string2));
        }
    }

    private void constructPre23MsrMap() {
        this.d_pre23MsrMap = new HashMap<String, IQuantity>();
        this.addPre23Msr(Intl.intl("Absorption Coefficient"), Quantity.ABSORPTION_COEFFICIENT);
        this.addPre23Msr(Intl.intl("Carbon Dioxide Concentration"), ExSpecList.MixFrac.CARBON_DIOXIDE.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Carbon Dioxide"), ExSpecList.MixFrac.CARBON_DIOXIDE.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Carbon Monoxide Concentration"), ExSpecList.MixFrac.CARBON_MONOXIDE.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Carbon Monoxide"), ExSpecList.MixFrac.CARBON_MONOXIDE.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Density"), Quantity.DENSITY);
        this.addPre23Msr(Intl.intl("Divergence"), Quantity.DIVERGENCE);
        this.addPre23Msr(Intl.intl("Extinction Coefficient"), Quantity.EXTINCTION_COEFFICIENT);
        this.addPre23Msr(Intl.intl("Fuel Concentration"), ExSpecList.MixFrac.FUEL.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Fuel"), ExSpecList.MixFrac.FUEL.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("H"), Quantity.H);
        this.addPre23Msr(Intl.intl("Heat Release Rate per Unit Volume"), Quantity.HRRPUV);
        this.addPre23Msr(Intl.intl("Hydrogen Concentration"), ExSpecList.MixFrac.HYDROGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Hydrogen"), ExSpecList.MixFrac.HYDROGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Mixture Fraction"), Quantity.MIXTURE_FRACTION);
        this.addPre23Msr(Intl.intl("Nitrogen Concentration"), ExSpecList.MixFrac.NITROGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Nitrogen"), ExSpecList.MixFrac.NITROGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Other Concentration"), ExSpecList.MixFrac.OTHER.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Oxygen Concentration"), ExSpecList.MixFrac.OXYGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Oxygen"), ExSpecList.MixFrac.OXYGEN.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Oxygen Mass Fraction"), ExSpecList.MixFrac.OXYGEN.spec, Quantity.SPEC_MASS_FRACTION);
        this.addPre23Msr(Intl.intl("Pressure"), Quantity.PRESSURE);
        this.addPre23Msr(Intl.intl("Radiant Intensity"), Quantity.RADIANT_INTENSITY);
        this.addPre23Msr(Intl.intl("Soot Concentration"), ExSpecList.MixFrac.SOOT.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Soot"), ExSpecList.MixFrac.SOOT.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Soot Volume Fraction"), ExSpecList.MixFrac.SOOT.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Soot Density"), ExSpecList.MixFrac.SOOT.spec, Quantity.SPEC_DENSITY);
        this.addPre23Msr(Intl.intl("Temperature"), Quantity.TEMPERATURE);
        this.addPre23Msr(Intl.intl("Thermocouple"), Quantity.THERMOCOUPLE);
        this.addPre23Msr(Intl.intl("U-Velocity"), Quantity.U_VELOCITY);
        this.addPre23Msr(Intl.intl("V-Velocity"), Quantity.V_VELOCITY);
        this.addPre23Msr(Intl.intl("W-Velocity"), Quantity.W_VELOCITY);
        this.addPre23Msr(Intl.intl("Velocity"), Quantity.VELOCITY);
        this.addPre23Msr(Intl.intl("Viscosity"), Quantity.VISCOSITY);
        this.addPre23Msr(Intl.intl("Visibility"), Quantity.VISIBILITY);
        this.addPre23Msr(Intl.intl("Water Vapor"), ExSpecList.MixFrac.WATER_VAPOR.spec, Quantity.SPEC_VOLUME_FRACTION);
        this.addPre23Msr(Intl.intl("Adiabatic Surface Temperature"), Quantity.ADIABATIC_SURFACE_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Back Wall Temperature"), Quantity.BACK_WALL_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Burning Rate"), Quantity.BURNING_RATE);
        this.addPre23Msr(Intl.intl("Convective Flux"), Quantity.CONVECTIVE_FLUX);
        this.addPre23Msr(Intl.intl("Gas Temperature"), Quantity.GAS_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Gauge Heat Flux"), Quantity.GAUGE_HEAT_FLUX);
        this.addPre23Msr(Intl.intl("Heat Flux"), Quantity.HEAT_FLUX);
        this.addPre23Msr(Intl.intl("Heat Transfer Coefficient"), Quantity.HEAT_TRANSFER_COEFFICIENT);
        this.addPre23Msr(Intl.intl("Incident Heat Flux"), Quantity.INCIDENT_HEAT_FLUX);
        this.addPre23Msr(Intl.intl("Inside Wall Temperature"), Quantity.INSIDE_WALL_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Mass Loss"), Quantity.MASS_LOSS);
        this.addPre23Msr(Intl.intl("Normal Velocity"), Quantity.NORMAL_VELOCITY);
        this.addPre23Msr(Intl.intl("Pressure Coefficient"), Quantity.PRESSURE_COEFFICIENT);
        this.addPre23Msr(Intl.intl("Radiative Flux"), Quantity.RADIATIVE_FLUX);
        this.addPre23Msr(Intl.intl("Radiometer"), Quantity.RADIOMETER);
        this.addPre23Msr(Intl.intl("Wall Temperature"), Quantity.WALL_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Wall Thickness"), Quantity.WALL_THICKNESS);
        this.addPre23Msr(Intl.intl("Heat Flow"), Quantity.HEAT_FLOW);
        this.addPre23Msr(Intl.intl("Heat Release Rate"), Quantity.HRR);
        this.addPre23Msr(Intl.intl("Mass Flow"), Quantity.MASS_FLOW);
        this.addPre23Msr(Intl.intl("Volume Flow"), Quantity.VOLUME_FLOW);
        this.addPre23Msr(Intl.intl("Layer Height"), Quantity.LAYER_HEIGHT);
        this.addPre23Msr(Intl.intl("Lower Temperature"), Quantity.LOWER_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Path Obscuration"), Quantity.PATH_OBSCURATION);
        this.addPre23Msr(Intl.intl("Upper Temperature"), Quantity.UPPER_TEMPERATURE);
        this.addPre23Msr(Intl.intl("Time"), Quantity.TIME);
        this.addPre23Msr(Intl.intl("Aspiration"), Quantity.ASPIRATION);
    }

    private void addPre23Msr(String string, IPyroObject iPyroObject, Quantity quantity) {
        this.d_pre23MsrMap.put(string, quantity.create(iPyroObject));
    }

    private void addPre23Msr(String string, Quantity quantity) {
        this.d_pre23MsrMap.put(string, quantity.create());
    }

    private boolean updatePre25ISOF(IsosurfaceMgr isosurfaceMgr) {
        boolean bl = false;
        for (pyrosim.legacy_2012_1.domain.output.Isosurface isosurface : isosurfaceMgr.flatten()) {
            IQuantity iQuantity = isosurface.getQuantity();
            Quantity quantity = iQuantity.get();
            if (quantity.requiredTypes.length <= 0 || !ExSpec.class.isAssignableFrom(quantity.requiredTypes[0])) continue;
            int n = quantity.unitType;
            if (isosurface.getContours().size() <= 0) continue;
            bl |= quantity == Quantity.SPEC_MASS_FLUX_X || quantity == Quantity.SPEC_MASS_FLUX_Y || quantity == Quantity.SPEC_MASS_FLUX_Z;
            List<UnitDouble> list = isosurface.getContours();
            ArrayList<UnitDouble> arrayList = new ArrayList<UnitDouble>();
            for (UnitDouble unitDouble : list) {
                arrayList.add(SIUS.newud(unitDouble.getValueNoUnit(), n));
            }
            isosurface.setContours(arrayList);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void fixPre42SourceSinkRefs() {
        Object object;
        assert (this.d_pre42SignalSinks != null && this.d_pre42SignalSources != null);
        for (ISignalSink iPyroObject : this.d_pre42SignalSinks) {
            object = iPyroObject.getInputPin();
            if (object == null) continue;
            object.setSink(iPyroObject);
        }
        for (ISignalSource iSignalSource : this.d_pre42SignalSources) {
            void var4_8;
            for (IOutPin iOutPin : iSignalSource.getOutputPins()) {
                iOutPin.setSource(iSignalSource);
            }
            if (!(iSignalSource instanceof IMeasurer)) continue;
            object = (IMeasurer)iSignalSource;
            boolean bl = false;
            while (var4_8 < object.getNumMeasurements()) {
                object.getMsrInfo((int)var4_8).legacySetSource((ILatchable)object);
                ++var4_8;
            }
        }
    }

    private void updatePre27Stats(Serialized serialized) {
        serialized.msrStats.prune();
        ArrayList arrayList = new ArrayList(serialized.msrStats.flatten());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            IMeasurementStat iMeasurementStat = (IMeasurementStat)arrayList.get(i);
            String string = iMeasurementStat.getName();
            List<IMeasurementStat> list = serialized.msrStats.findAll(string, IMeasurementStat.class, true);
            if (list.size() <= 1) continue;
            Util.autoRename(serialized.msrStats, iMeasurementStat);
        }
    }

    private void removeObjs(PyroMod pyroMod, DepSnapshot depSnapshot, Collection<? extends IPyroObject> collection) {
        Object object;
        Object object2;
        Object object3;
        IPyroObject iPyroObject;
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        Object object4 = new LinkedIdentityHashSet<IPyroObject>(collection);
        while (!object4.isEmpty()) {
            linkedIdentityHashSet.addAll(object4);
            LinkedIdentityHashSet linkedIdentityHashSet2 = new LinkedIdentityHashSet();
            Object object5 = object4.iterator();
            while (object5.hasNext()) {
                iPyroObject = (IPyroObject)object5.next();
                object3 = depSnapshot.getDependents(iPyroObject);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Dependency)object2.next();
                    assert (((Dependency)object).link != DLink.REQUIRED);
                    if (((Dependency)object).link == DLink.STRONG && ((Dependency)object).source instanceof IPyroObject && !linkedIdentityHashSet.contains((IPyroObject)((Object)((Dependency)object).source)) && pyrosim.legacy_2012_1.util.Util.canDelete(pyroMod, ((Dependency)object).source)) {
                        linkedIdentityHashSet2.add((IPyroObject)((Object)((Dependency)object).source));
                        continue;
                    }
                    ((Dependency)object).source.taskReplaceDep(iPyroObject, null).run();
                }
            }
            object4 = linkedIdentityHashSet2;
        }
        for (Object object5 : linkedIdentityHashSet) {
            iPyroObject = object5.getParent();
            if (!(iPyroObject instanceof Composite)) continue;
            object3 = pyrosim.legacy_2012_1.util.Util.getCatName((IPyroObject)object5);
            object2 = String.format(Intl.intl("The %s, %s, is no longer valid."), object3, pyrosim.legacy_2012_1.util.Util.getName((IPyroObject)object5));
            object = String.format(Intl.intl("Removed %s from the model."), object3);
            this.d_warnings.addWarning(new Warning((String)object2, (String)object));
            ((Composite)iPyroObject).remove((IPyroObject)object5);
        }
    }

    private void removeV28DeprecatedQuantities(Serialized serialized) {
        PyroMod pyroMod = new PyroMod(serialized, false, false);
        LinkedHashSet<StaticQuantity> linkedHashSet = new LinkedHashSet<StaticQuantity>();
        linkedHashSet.add(Quantity.RADIANT_INTENSITY.create());
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        block0: for (IMeasurer cloneable2 : ((APyroObject)serialized.devices).flatten(IMeasurer.class)) {
            for (int i = 0; i < cloneable2.getNumMeasurements(); ++i) {
                if (!linkedHashSet.contains(cloneable2.getQuantity(i))) continue;
                arrayList.add(cloneable2);
                continue block0;
            }
        }
        for (Sprinkler sprinkler : ((APyroObject)serialized.devices).flatten(Sprinkler.class)) {
            if (!(sprinkler.getLinkModel() instanceof Sprinkler.QuantityModel) || !linkedHashSet.contains(((Sprinkler.QuantityModel)sprinkler.getLinkModel()).d_quantity)) continue;
            arrayList.add(sprinkler);
        }
        for (Slice slice : serialized.slices.flatten()) {
            if (!linkedHashSet.contains(slice.getQuantity())) continue;
            arrayList.add(slice);
        }
        for (pyrosim.legacy_2012_1.domain.output.Isosurface isosurface : serialized.isosurfaces.flatten()) {
            if (!linkedHashSet.contains(isosurface.getQuantity())) continue;
            arrayList.add(isosurface);
        }
        for (IMeasurementStat iMeasurementStat : serialized.msrStats.flatten()) {
            if (!linkedHashSet.contains(iMeasurementStat.getQuantity())) continue;
            arrayList.add(iMeasurementStat);
        }
        boolean bl = !arrayList.isEmpty();
        HashSet<IQuantity> hashSet = new HashSet<IQuantity>(serialized.plot3d.getQuantities());
        if (hashSet.removeAll(linkedHashSet)) {
            bl = true;
            serialized.plot3d.setQuantities(hashSet);
        }
        if (bl) {
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("RADIANT_INTENSITY is no longer supported since FDS 5.2."), new Object[0]), Intl.intl("All references to RADIANT_INTENSITY have been removed.")));
        }
        this.removeObjs(pyroMod, pyroMod.getDependencies(new IPyroObject[0]), arrayList);
        serialized.setDomain(null);
        IdentityHashSet identityHashSet = new IdentityHashSet();
        for (Object object : serialized.particles.flatten()) {
            if (((Particle)object).isMassless()) continue;
            identityHashSet.add(Quantity.PART_MPUV.create(new IPyroObject[]{object}));
        }
        ArrayList arrayList2 = new ArrayList();
        for (pyrosim.legacy_2012_1.domain.output.Isosurface isosurface : serialized.isosurfaces.flatten()) {
            IQuantity iQuantity = isosurface.getQuantity();
            if (!identityHashSet.contains(iQuantity)) continue;
            arrayList2.add(isosurface);
        }
        if (!arrayList2.isEmpty()) {
            serialized.isosurfaces.removeAll(arrayList2);
            this.d_warnings.addWarning(new Warning(Intl.intl("Starting with FDS version 5.2, Isosurfaces can no longer output particle quantities."), Intl.intl("Relevant Isosurfaces have been removed.")));
        }
    }

    private void initLegClasses() {
        this.addLegClass(23, "pyrosim.domain.measure.Measurement", Measurement.class);
        this.addLegClass(23, "pyrosim.domain.measure.ObjectMeasurement", ObjectMeasurement.class);
        this.addLegClass(27, "pyrosim.domain.output.AMeasurementStat", AMeasurementStat.class);
        this.addLegClass(27, "pyrosim.domain.output.GasMeasurementStat", GasMeasurementStat.class);
        this.addLegClass(27, "pyrosim.domain.output.SolidMeasurementStat", SolidMeasurementStat.class);
        this.addLegClass(28, "pyrosim.domain.output.Isosurface", Isosurface.class);
        this.addLegClass(28, "pyrosim.domain.output.IsosurfaceMgr", pyrosim.legacy_2012_1.legacy.v28.domain.output.IsosurfaceMgr.class);
        this.addLegClass(29, "pyrosim.domain.devices.measurers.LayerMeasurer", LayerMeasurer.class);
        this.addLegClass(31, "pyrosim.domain.output.GasMsrStat$AreaGeom", GasMsrStat.AreaGeom.class);
        this.addLegClass(31, "pyrosim.domain.output.GasMsrStat$VolumeGeom", GasMsrStat.VolumeGeom.class);
        this.addLegClass(31, "pyrosim.domain.output.GasMsrStat$GridGeom", GasMsrStat.GridGeom.class);
        this.addLegClass(31, "pyrosim.domain.output.AMsrStat", AMsrStat.class);
        this.addLegClass(31, "pyrosim.domain.output.SolidMsrStat", SolidMsrStat.class);
        this.addLegClass(31, "pyrosim.domain.output.GasMsrStat", GasMsrStat.class);
        this.addLegClass(31, "pyrosim.geom.Polygon", Polygon.class);
        this.addLegClass(31, "pyrosim.geom.Quad", Quad.class);
        this.addLegClass(31, "pyrosim.domain.geom.AAlignedFDSObject", AAlignedFDSObject.class);
        this.addLegClass(31, "pyrosim.domain.geom.AAlignedFDSObject$AAlignedFDSObjectFace", AAlignedFDSObject.AAlignedFDSObjectFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.AARectangle", pyrosim.legacy_2012_1.legacy.v31.domain.geom.AARectangle.class);
        this.addLegClass(31, "pyrosim.domain.geom.AbstractFace", AbstractFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.AbstractFDSObject", AbstractFDSObject.class);
        this.addLegClass(31, "pyrosim.domain.geom.AlignedBlock", AlignedBlock.class);
        this.addLegClass(31, "pyrosim.domain.geom.AlignedHole", AlignedHole.class);
        this.addLegClass(31, "pyrosim.domain.geom.AUnalignedFDSObject", AUnalignedFDSObject.class);
        this.addLegClass(31, "pyrosim.domain.geom.AUnalignedFDSObject$BlockFace", AUnalignedFDSObject.BlockFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.FDSConvexPoly", FDSConvexPoly.class);
        this.addLegClass(31, "pyrosim.domain.geom.FDSConvexPoly$ConvexPolyFace", FDSConvexPoly.ConvexPolyFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.Hole", Hole.class);
        this.addLegClass(31, "pyrosim.domain.geom.Hole$BlockFace", Hole.BlockFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.IFace", IFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.PartCloud", PartCloud.class);
        this.addLegClass(31, "pyrosim.domain.geom.Slab", Slab.class);
        this.addLegClass(31, "pyrosim.domain.geom.Slab$SlabFace", Slab.SlabFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.Vent", Vent.class);
        this.addLegClass(31, "pyrosim.domain.geom.Vent$VentFace", Vent.VentFace.class);
        this.addLegClass(31, "pyrosim.domain.geom.Wall", Wall.class);
        this.addLegClass(31, "pyrosim.domain.geom.FDSComposite", pyrosim.legacy_2012_1.legacy.v31.domain.geom.FDSComposite.class);
        this.addLegClass(31, "pyrosim.domain.texture.ModelImage", pyrosim.legacy_2012_1.legacy.v31.domain.texture.ModelImage.class);
        this.addLegClass(31, "pyrosim.domain.texture.BufferModelImage", BufferModelImage.class);
        this.addLegClass(31, "pyrosim.domain.texture.FileModelImage", FileModelImage.class);
        this.addLegClass(31, "pyrosim.domain.boundcond.surf.LayeredSurfDesc", LayeredSurfDesc.class);
        this.addLegClass(33, "pyrosim.geom.AABoxGeom", AABoxGeom.class);
        this.addLegClass(33, "pyrosim.geom.AARectangle", AARectangle.class);
        this.addLegClass(33, "pyrosim.geom.BlockGeom", BlockGeom.class);
        this.addLegClass(33, "pyrosim.geom.EmptyGeom", EmptyGeom.class);
        this.addLegClass(33, "pyrosim.geom.ExtrudedPoly", ExtrudedPoly.class);
        this.addLegClass(33, "pyrosim.geom.GeomGroup", GeomGroup.class);
        this.addLegClass(33, "pyrosim.geom.IGeom", IGeom.class);
        this.addLegClass(33, "pyrosim.geom.IPolygon", IPolygon.class);
        this.addLegClass(33, "pyrosim.geom.LineSeg", LineSeg.class);
        this.addLegClass(33, "pyrosim.geom.Mesh", Mesh.class);
        this.addLegClass(33, "pyrosim.geom.NGon", NGon.class);
        this.addLegClass(33, "pyrosim.geom.Point", Point.class);
        this.addLegClass(33, "pyrosim.geom.PolyLine", PolyLine.class);
        this.addLegClass(33, "pyrosim.geom.Quad", pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad.class);
        this.addLegClass(33, "pyrosim.geom.TransformedGeom", TransformedGeom.class);
        this.addLegClass(33, "pyrosim.geom.Triangle", Triangle.class);
        this.addLegClass(33, "pyrosim.geom.WallGeom", WallGeom.class);
        this.addLegClass(37, "pyrosim.domain.Ramp", Ramp.class);
        this.addLegClass(37, "pyrosim.domain.Ramp$Entry", Ramp.Entry.class);
        this.addLegClass(40, "pyrosim.domain.texture.ModelImage", ModelImage.class);
        this.addLegClass(43, "pyrosim.domain.ExSpecList", ExSpecList.class);
        this.addLegClass(43, "pyrosim.domain.geom.FDSObjectManager", FDSObjectManager.class);
        this.addLegClass(43, "pyrosim.domain.FloorManager", FloorManager.class);
        this.addLegClass(43, "pyrosim.domain.GridList", GridList.class);
        this.addLegClass(43, "pyrosim.domain.boundcond.mat.MaterialManager", MaterialManager.class);
        this.addLegClass(43, "pyrosim.domain.boundcond.surf.SurfaceManager", SurfaceManager.class);
        this.addLegClass(43, "pyrosim.domain.controls.ControlMgr", ControlMgr.class);
        this.addLegClass(43, "pyrosim.domain.devices.DeviceManager", DeviceManager.class);
        this.addLegClass(43, "pyrosim.domain.devices.detectors.HeatLinkModelMgr", HeatLinkModelMgr.class);
        this.addLegClass(43, "pyrosim.domain.devices.detectors.SmokeLinkModelMgr", SmokeLinkModelMgr.class);
        this.addLegClass(43, "pyrosim.domain.devices.detectors.SprinklerLinkModelMgr", SprinklerLinkModelMgr.class);
        this.addLegClass(43, "pyrosim.domain.devices.sprayers.SprayModelMgr", SprayModelMgr.class);
        this.addLegClass(43, "pyrosim.domain.evac.CorrList", pyrosim.legacy_2012_1.legacy.v42.domain.evac.CorrList.class);
        this.addLegClass(43, "pyrosim.domain.evac.DoorList", pyrosim.legacy_2012_1.legacy.v42.domain.evac.DoorList.class);
        this.addLegClass(43, "pyrosim.domain.evac.EntrList", EntrList.class);
        this.addLegClass(43, "pyrosim.domain.evac.EvacList", EvacList.class);
        this.addLegClass(43, "pyrosim.domain.evac.EvhoList", EvhoList.class);
        this.addLegClass(43, "pyrosim.domain.evac.EvssList", EvssList.class);
        this.addLegClass(43, "pyrosim.domain.evac.ExitList", ExitList.class);
        this.addLegClass(43, "pyrosim.domain.evac.PersList", pyrosim.legacy_2012_1.legacy.v42.domain.evac.PersList.class);
        this.addLegClass(43, "pyrosim.domain.geom.FDSComposite", FDSComposite.class);
        this.addLegClass(43, "pyrosim.domain.hvac.HvacList", HvacList.class);
        this.addLegClass(43, "pyrosim.domain.managers.ADepPyroList", ADepPyroList.class);
        this.addLegClass(43, "pyrosim.domain.managers.ADepPyroSet", ADepPyroSet.class);
        this.addLegClass(43, "pyrosim.domain.managers.ADepPyroUniqueMap", ADepPyroUniqueMap.class);
        this.addLegClass(43, "pyrosim.domain.managers.APyroList", APyroList.class);
        this.addLegClass(43, "pyrosim.domain.managers.APyroManager", APyroManager.class);
        this.addLegClass(43, "pyrosim.domain.managers.APyroMap", APyroMap.class);
        this.addLegClass(43, "pyrosim.domain.managers.APyroSet", APyroSet.class);
        this.addLegClass(43, "pyrosim.domain.managers.APyroUniqueMap", APyroUniqueMap.class);
        this.addLegClass(43, "pyrosim.domain.output.IsosurfaceMgr", pyrosim.legacy_2012_1.legacy.v42.domain.output.IsosurfaceMgr.class);
        this.addLegClass(43, "pyrosim.domain.output.ProfList", ProfList.class);
        this.addLegClass(43, "pyrosim.domain.output.SliceList", SliceList.class);
        this.addLegClass(43, "pyrosim.domain.output.StatisticMgr", StatisticMgr.class);
        this.addLegClass(43, "pyrosim.domain.particle.ParticleList", ParticleList.class);
        this.addLegClass(43, "pyrosim.domain.reaction.ReactionList", ReactionList.class);
        this.addLegClass(43, "pyrosim.domain.zones.LeakMgr", LeakMgr.class);
        this.addLegClass(43, "pyrosim.domain.zones.ZoneMgr", pyrosim.legacy_2012_1.legacy.v42.domain.zones.ZoneMgr.class);
        this.addLegClass(44, "pyrosim.domain.Floor", Floor.class);
        this.addLegClass(45, "pyrosim.domain.geom.FDSComposite", pyrosim.legacy_2012_1.legacy.v44.domain.geom.FDSComposite.class);
        this.addLegClass(46, "pyrosim.domain.measure.AMeasurement", AMeasurement.class);
        this.addLegClass(46, "pyrosim.domain.measure.ObjectMsr", ObjectMsr.class);
        this.addLegClass(46, "pyrosim.domain.measure.StaticMsr", StaticMsr.class);
        this.addLegClass(46, "pyrosim.domain.measure.Measurements$VelocitySign", Measurements.VelocitySign.class);
    }

    private void addLegClass(int n, String string, Class clazz) {
        HashMap<String, Class> hashMap = (HashMap<String, Class>)this.d_classLookup.get(n);
        if (hashMap == null) {
            hashMap = new HashMap<String, Class>();
            this.d_classLookup.put(n, hashMap);
        }
        hashMap.put(string, clazz);
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        Collection collection = this.d_classLookup.tailMap(this.d_version, false).values();
        for (Object object : collection) {
            Class clazz = (Class)object.get(string);
            if (clazz == null) continue;
            return clazz;
        }
        Class clazz = this.d_teciio.resolveClass(objectStreamClass);
        if (clazz != null) {
            return clazz;
        }
        if (string.startsWith("pyrosim.") || string.startsWith("[Lpyrosim.")) {
            Object object;
            object = string;
            object = ((String)object).replaceFirst("pyrosim.", "pyrosim.legacy_2012_1.");
            return Class.forName((String)object);
        }
        return super.resolveClass(objectStreamClass);
    }

    @Override
    protected Object resolveObject(Object object) {
        Serializable serializable;
        Object object2;
        if (this.d_version < 22 && Clock.isClock(object)) {
            return Clock.INSTANCE;
        }
        if (this.d_version == 22 && object instanceof SolidPointMeasurer && ((SolidPointMeasurer)object).getQuantity().get().quantityType == QuantityType.GAS) {
            SolidPointMeasurer solidPointMeasurer = (SolidPointMeasurer)object;
            return new GasPointMeasurer(solidPointMeasurer.getName(), solidPointMeasurer.getQuantity(), solidPointMeasurer.getLocation());
        }
        if (this.d_version < 23) {
            if (object instanceof ObjectMeasurement) {
                object2 = (ObjectMeasurement)object;
                object = ((ObjectMeasurement)object2).fromLegacy();
            } else if (object instanceof Measurement) {
                object2 = (Measurement)object;
                object = this.d_pre23MsrMap.get(((Measurement)object2).getDescription());
                assert (object != null);
            }
        }
        if (this.d_version < 27 && object instanceof AMeasurementStat) {
            object = ((AMeasurementStat)object).convert();
        }
        if (this.d_version < 28) {
            if (object instanceof Isosurface) {
                object = ((Isosurface)object).convert();
            } else if (object instanceof pyrosim.legacy_2012_1.legacy.v28.domain.output.IsosurfaceMgr) {
                object = ((pyrosim.legacy_2012_1.legacy.v28.domain.output.IsosurfaceMgr)object).convert();
            }
        }
        if (this.d_version < 29) {
            if (object instanceof UnitDouble) {
                object2 = (UnitDouble)object;
                if (((UnitDouble)object2).getUnit().equals(this.d_pre29AspirationUnit)) {
                    object = new UnitDouble(((UnitDouble)object2).getValueNoUnit(), SIUS.unit(57));
                } else if (((UnitDouble)object2).getUnit().equals(this.d_pre29ObscurationUnitSIUS)) {
                    object = new UnitDouble(((UnitDouble)object2).getValueNoUnit(), SIUS.unit(31));
                } else if (((UnitDouble)object2).getUnit().equals(this.d_pre29ObscurationUnitEnglish)) {
                    object = new UnitDouble(((UnitDouble)object2).getValueNoUnit(), EnglishUS.unit(31));
                }
            } else if (object instanceof LayerMeasurer) {
                object = ((LayerMeasurer)object).convert();
            } else if (object instanceof LayerMeasurer.LayerPin && ((NamedPyroObject)(object2 = (LayerMeasurer.LayerPin)object)).getName().equals(Intl.intl("LTEMP"))) {
                object = new LayerMeasurer.LayerPin(((AOutPin)object2).getAttachedSource(), ((NamedPyroObject)object2).getName(), Quantity.LOWER_TEMPERATURE.create());
            }
        }
        if (this.d_version < 30) {
            if (object instanceof GasMsrStat) {
                object = ((GasMsrStat)object).convert();
            } else if (object instanceof SolidMsrStat) {
                object = ((SolidMsrStat)object).convert();
            }
        }
        if (this.d_version < 31) {
            if (object instanceof pyrosim.legacy_2012_1.legacy.v31.domain.geom.AARectangle) {
                object = ((pyrosim.legacy_2012_1.legacy.v31.domain.geom.AARectangle)object).convert();
            } else if (object instanceof pyrosim.legacy_2012_1.legacy.v31.domain.texture.ModelImage) {
                object = ((pyrosim.legacy_2012_1.legacy.v31.domain.texture.ModelImage)object).convert();
            } else if (object instanceof LayeredSurfDesc) {
                object = ((LayeredSurfDesc)object).convert();
            }
        }
        if (this.d_version < 32) {
            if (object instanceof SolidReaction.Rate.RefSpec) {
                this.d_pre32RefSpecs.add((SolidReaction.Rate.RefSpec)object);
            } else if (object instanceof LiquidReaction) {
                object2 = (LiquidReaction)object;
                if (((LiquidReaction)object2).d_byproducts.d_heat == null) {
                    object2 = new LiquidReaction(((LiquidReaction)object2).d_rate, new ReacByproducts(((LiquidReaction)object2).d_byproducts.d_nuFuel, ((LiquidReaction)object2).d_byproducts.d_nuWater, ((LiquidReaction)object2).d_byproducts.d_nuResidue, ((LiquidReaction)object2).d_byproducts.getResidue(), SIUS.newud(0.0, 46)));
                    this.d_pre32InvalidReacs.add((LiquidReaction)object2);
                    object = object2;
                }
            }
        }
        if (this.d_version < 33 && object instanceof SizeDistribution) {
            object2 = (SizeDistribution)object;
            if (((SizeDistribution)object2).d_medianDiameter.equals(new UnitDouble(100.0, SI.MICRO(SI.METER)))) {
                object = new SizeDistribution(new UnitDouble(500.0, SI.MICRO(SI.METER)), ((SizeDistribution)object2).d_type);
            }
        }
        if (this.d_version < 37 && object instanceof Ramp) {
            object = ((Ramp)object).fromLegacy();
        }
        if (this.d_version < 40 && object instanceof ModelImage) {
            object = ((ModelImage)object).fromLegacy();
        }
        if (this.d_version < 42) {
            if (object instanceof ISignalSource) {
                this.d_pre42SignalSources.add((ISignalSource)object);
            }
            if (object instanceof ISignalSink) {
                this.d_pre42SignalSinks.add((ISignalSink)object);
            }
        }
        if (this.d_version < 43 && object instanceof IPyroManager) {
            object = ((IPyroManager)object).convert();
        }
        if (this.d_version < 44 && object instanceof Floor) {
            object = ((Floor)object).fromLegacy();
        }
        if (this.d_version < 45 && object instanceof pyrosim.legacy_2012_1.legacy.v44.domain.geom.FDSComposite) {
            object = ((pyrosim.legacy_2012_1.legacy.v44.domain.geom.FDSComposite)object).fromLegacy();
        }
        if (this.d_version < 46) {
            if (object instanceof Measurements.VelocitySign) {
                object = ((Measurements.VelocitySign)((Object)object)).fromLegacy();
            } else if (object instanceof pyrosim.legacy_2012_1.legacy.v45.domain.measure.Measurement) {
                object = ((pyrosim.legacy_2012_1.legacy.v45.domain.measure.Measurement)object).fromLegacy();
            } else if (object instanceof Set) {
                object2 = (Set)object;
                if (!object2.isEmpty() && object2.iterator().next() instanceof IQuantity) {
                    serializable = new ArrayList(object2);
                    object2.clear();
                    object2.addAll(serializable);
                }
            } else if (object instanceof Map && !(object2 = (Map)object).isEmpty() && object2.keySet().iterator().next() instanceof IQuantity) {
                serializable = new ArrayList(object2.entrySet());
                object2.clear();
                Iterator iterator = serializable.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    object2.put(entry.getKey(), entry.getValue());
                }
            }
        }
        if (this.d_version < 47) {
            if (object instanceof UnitDouble) {
                object2 = (UnitDouble)object;
                if (this.isObscurationUnit(((UnitDouble)object2).getUnit())) {
                    object = ((UnitDouble)object2).reinterpret(SIUS.unit(80));
                }
            } else if (object instanceof SmokeLinkModel) {
                object2 = (SmokeLinkModel)object;
                serializable = ((SmokeLinkModel)object2).getActivationObscuration().reinterpret(SIUS.unit(31));
                ((SmokeLinkModel)object2).setActivationObscuration((UnitDouble)serializable);
            }
        }
        if (object instanceof Color) {
            object = this.getExisting((Color)object, this.d_colorMap);
        } else if (object instanceof UnitPoint3D) {
            object = this.getExisting((UnitPoint3D)object, this.d_pointMap);
        } else if (object instanceof String) {
            object = this.getExisting((String)object, this.d_strMap);
        } else if (object instanceof Point3d) {
            object = this.getExisting((Point3d)object, this.d_point3dMap);
        }
        object = this.d_teciio.resolveObject(object);
        return object;
    }

    private boolean isObscurationUnit(Unit unit) {
        if (this.d_obscurationUnits == null) {
            this.d_obscurationUnits = new HashSet<Unit>();
            for (Object e : Unit.getInstances()) {
                Unit unit2 = (Unit)e;
                if (!unit2.isCompatible(SI.METER)) continue;
                this.d_obscurationUnits.add(NonSI.PERCENT.divide(unit2));
            }
        }
        return this.d_obscurationUnits.contains(unit);
    }

    private <T> T getExisting(T t, Map<T, T> map) {
        if (!map.containsKey(t)) {
            map.put(t, t);
            return t;
        }
        return map.get(t);
    }

    static {
        String string = String.format("PSM%04d", 48);
        assert (string.length() <= 7);
        FORMAT_CODE = string.getBytes();
    }

    private static class Pre29DevcWrapper {
        private final IMeasurer devc;
        private final Map<AlarmInfo, List<PinReplacement>>[] alarmMaps;

        public Pre29DevcWrapper(IMeasurer iMeasurer) {
            this.devc = iMeasurer;
            this.alarmMaps = new Map[iMeasurer.getNumMeasurements()];
            for (int i = 0; i < iMeasurer.getNumMeasurements(); ++i) {
                this.alarmMaps[i] = new HashMap<AlarmInfo, List<PinReplacement>>();
            }
        }
    }

    private static class PinReplacement
    extends Pair<IOutPin, IInPin> {
        private static final long serialVersionUID = 6895485069285052817L;

        public PinReplacement(IOutPin iOutPin, IInPin iInPin) {
            super(iOutPin, iInPin);
        }
    }
}

