/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.FDSVersion;
import pyrosim.Version;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.util.theTimer;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class GE1File {
    public static boolean writeFile(String string, PyroMod pyroMod) throws IOException {
        return GE1File.writeFile(string, pyroMod, Version.FDS_DESIGN);
    }

    public static boolean writeFile(String string, PyroMod pyroMod, FDSVersion fDSVersion) throws IOException {
        System.out.println("Writing GE1 File...");
        theTimer theTimer2 = new theTimer();
        ArrayList<PolyInfo> arrayList = new ArrayList<PolyInfo>();
        ArrayList<Appearance> arrayList2 = new ArrayList<Appearance>();
        GE1File.getPolys(pyroMod, arrayList2, arrayList);
        System.out.println(String.format("   %d polys", arrayList.size()));
        System.out.println(String.format("   %d appearances", arrayList2.size()));
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        printWriter.println("[APPEARANCE]");
        printWriter.println(arrayList2.size());
        GE1File.writeAppearances(printWriter, arrayList2, fDSVersion);
        printWriter.println("[FACES]");
        printWriter.println(arrayList.size());
        GE1File.writePrims(printWriter, arrayList);
        printWriter.close();
        System.out.println("GE1 Written in " + theTimer2.curr() * 1000.0 + " ms");
        return true;
    }

    private static void getPolys(PyroMod pyroMod, List<Appearance> list, List<PolyInfo> list2) {
        LinkedHashMap<Appearance, Integer> linkedHashMap = new LinkedHashMap<Appearance, Integer>();
        for (IPyroGeomSrc iPyroGeomSrc : pyroMod.getObstructions().flatten()) {
            DisplayGeom displayGeom = iPyroGeomSrc.getDisplayGeom(null);
            IPropsSrc iPropsSrc = displayGeom.props;
            List list3 = pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.explode(displayGeom.geom, IPrimitive.class);
            for (int i = 0; i < list3.size(); ++i) {
                IPrimitive iPrimitive = (IPrimitive)list3.get(i);
                if (!(iPrimitive instanceof IFace)) continue;
                IFace iFace = (IFace)iPrimitive;
                IPrimProps iPrimProps = iPropsSrc.get(i);
                int n = GE1File.getAppearance(iPrimProps, linkedHashMap);
                List<IPolygon> list4 = GeomUtil.toPolys(iFace, 0.1, false);
                for (IPolygon iPolygon : list4) {
                    if (iPolygon.getNumLoops() > 1 || iPolygon.getNumPoints(0) > 4) {
                        Mesh mesh = iPolygon.triangulate(0.1);
                        int n2 = 0;
                        while (n2 < mesh.indices.length) {
                            Point3d point3d = mesh.vertices[mesh.indices[n2++]];
                            Point3d point3d2 = mesh.vertices[mesh.indices[n2++]];
                            Point3d point3d3 = mesh.vertices[mesh.indices[n2++]];
                            list2.add(new PolyInfo(new Triangle(point3d, point3d2, point3d3), n));
                        }
                        continue;
                    }
                    list2.add(new PolyInfo(iPolygon, n));
                }
            }
        }
        list.addAll(linkedHashMap.keySet());
    }

    private static void writeAppearances(PrintWriter printWriter, Collection<Appearance> collection, FDSVersion fDSVersion) {
        Unit unit = SIUS.getInstance().getLengthUnit();
        float[] fArray = new float[3];
        Iterator<Appearance> iterator = collection.iterator();
        for (int i = 0; i < collection.size(); ++i) {
            Appearance appearance = iterator.next();
            Surface surface = appearance.d_surf;
            Color color = appearance.d_color;
            printWriter.println(appearance.toString());
            TextureInfo textureInfo = null;
            if (surface != null) {
                textureInfo = surface.getTextureInfo();
            }
            double d = 0.0;
            double d2 = 0.0;
            String string = "";
            if (textureInfo != null) {
                d = textureInfo.getWidth().getValue(unit);
                d2 = textureInfo.getHeight().getValue(unit);
                string = textureInfo.getTexID();
            }
            printWriter.print(i);
            printWriter.print(' ');
            if (fDSVersion.major < 6) {
                color.getColorComponents(fArray);
                printWriter.printf("%f %f %f", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]));
            } else {
                printWriter.printf("%d %d %d", color.getRed(), color.getGreen(), color.getBlue());
            }
            printWriter.printf(" %f, %f", d, d2);
            if (color.getAlpha() < 255) {
                printWriter.print(", ");
                printWriter.print((float)color.getAlpha() / 255.0f);
            }
            printWriter.println();
            printWriter.println(string);
        }
    }

    private static void writePrims(PrintWriter printWriter, List<PolyInfo> list) {
        for (int i = 0; i < list.size(); ++i) {
            PolyInfo polyInfo = list.get(i);
            int n = polyInfo.poly.getNumPoints(0);
            if (n == 3) {
                GE1File.writeQuad(printWriter, polyInfo.appearanceIx, polyInfo.poly.getPoint(0, 0), polyInfo.poly.getPoint(0, 1), polyInfo.poly.getPoint(0, 2), polyInfo.poly.getPoint(0, 2));
                continue;
            }
            if (n != 4) continue;
            GE1File.writeQuad(printWriter, polyInfo.appearanceIx, polyInfo.poly.getPoint(0, 0), polyInfo.poly.getPoint(0, 1), polyInfo.poly.getPoint(0, 2), polyInfo.poly.getPoint(0, 3));
        }
    }

    private static void writeQuad(PrintWriter printWriter, int n, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        GE1File.writePoint(printWriter, point3d);
        GE1File.writePoint(printWriter, point3d2);
        GE1File.writePoint(printWriter, point3d3);
        GE1File.writePoint(printWriter, point3d4);
        printWriter.println(n);
    }

    private static void writePoint(PrintWriter printWriter, Point3d point3d) {
        printWriter.print((float)point3d.x);
        printWriter.print(" ");
        printWriter.print((float)point3d.y);
        printWriter.print(" ");
        printWriter.print((float)point3d.z);
        printWriter.print(" ");
    }

    private static int getAppearance(IPrimProps iPrimProps, Map<Appearance, Integer> map) {
        Surface surface = (Surface)iPrimProps.getMaterial();
        Appearance appearance = new Appearance(surface, GE1File.getColor(iPrimProps));
        Integer n = map.get(appearance);
        if (n == null) {
            n = map.size();
            map.put(appearance, n);
        }
        return n;
    }

    private static Color getColor(IPrimProps iPrimProps) {
        if (iPrimProps.getColor() != null) {
            return iPrimProps.getColor();
        }
        if (iPrimProps.getMaterial() != null) {
            return (Color)iPrimProps.getMaterial().getDiffuse().v1;
        }
        return null;
    }

    private static class Appearance {
        public final Surface d_surf;
        public final Color d_color;

        public Appearance(Surface surface, Color color) {
            this.d_surf = surface;
            this.d_color = color;
        }

        public int hashCode() {
            return 35912251 + theUtil.hashCode(this.d_surf) + theUtil.hashCode(this.d_color);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Appearance)) {
                return false;
            }
            Appearance appearance = (Appearance)object;
            return theUtil.equal(appearance.d_color, this.d_color) && theUtil.equal(appearance.d_surf, this.d_surf);
        }

        public String toString() {
            String string = this.d_surf != null ? this.d_surf.getName() : "";
            String string2 = this.d_color != null ? String.format("r=%d,g=%d,b=%d,a=%d", this.d_color.getRed(), this.d_color.getGreen(), this.d_color.getBlue(), this.d_color.getAlpha()) : "";
            return String.format("Appearance[%s,%s]", string, string2);
        }
    }

    private static class PolyInfo {
        public final IPolygon poly;
        public final int appearanceIx;

        public PolyInfo(IPolygon iPolygon, int n) {
            this.poly = iPolygon;
            this.appearanceIx = n;
        }
    }
}

