/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.Serialized;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.Hole;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;

public class BimImporter {
    private static final int PT_GROUPS = 0;
    private static final int PT_MATERIALS = 1;
    private static final int PT_WALLS = 2;
    private static final int PT_SLABS = 3;
    private static final int PT_FURNISHINGS = 4;
    private static final int PT_HOLES = 5;

    public static void open(Serialized serialized, String string) throws IOException {
        Object object;
        Surface surface = (Surface)serialized.surfmgr.get(PredefSurf.INERT.name());
        int n = -1;
        IdentityHashMap<ModelComposite, Integer> identityHashMap = new IdentityHashMap<ModelComposite, Integer>();
        ArrayList<ModelComposite> arrayList = new ArrayList<ModelComposite>();
        ArrayList<Surface> arrayList2 = new ArrayList<Surface>();
        ArrayList<Surface> arrayList3 = new ArrayList<Surface>();
        ArrayList<Surface> arrayList4 = new ArrayList<Surface>();
        ArrayList<Surface> arrayList5 = new ArrayList<Surface>();
        ArrayList<Surface> arrayList6 = new ArrayList<Surface>();
        int n2 = 0;
        try {
            object = new BufferedReader(new FileReader(string));
            Object object2 = null;
            try {
                String throwable;
                while ((throwable = ((BufferedReader)object).readLine()) != null) {
                    ++n2;
                    String object3 = throwable.trim();
                    if (object3.equals("[groups]")) {
                        n = 0;
                        continue;
                    }
                    if (object3.equals("[materials]")) {
                        n = 1;
                        continue;
                    }
                    if (object3.equals("[walls]")) {
                        n = 2;
                        continue;
                    }
                    if (object3.equals("[slabs]")) {
                        n = 3;
                        continue;
                    }
                    if (object3.equals("[furnishings]")) {
                        n = 4;
                        continue;
                    }
                    if (object3.equals("[holes]")) {
                        n = 5;
                        continue;
                    }
                    if (object3.length() <= 0) continue;
                    switch (n) {
                        case 0: {
                            INamed iNamed = BimImporter.parseGroup(object3, identityHashMap);
                            if (iNamed == null) break;
                            arrayList.add((ModelComposite)iNamed);
                            break;
                        }
                        case 1: {
                            INamed iNamed = BimImporter.parseMaterial(object3);
                            if (iNamed == null) break;
                            arrayList2.add((Surface)iNamed);
                            break;
                        }
                        case 2: {
                            INamed iNamed = BimImporter.parseSolid(object3, arrayList, surface, arrayList2);
                            if (iNamed == null) break;
                            arrayList3.add((Surface)iNamed);
                            break;
                        }
                        case 3: {
                            INamed iNamed = BimImporter.parseSolid(object3, arrayList, surface, arrayList2);
                            if (iNamed == null) break;
                            arrayList6.add((Surface)iNamed);
                            break;
                        }
                        case 4: {
                            INamed iNamed = BimImporter.parseSolid(object3, arrayList, surface, arrayList2);
                            if (iNamed == null) break;
                            arrayList5.add((Surface)iNamed);
                            break;
                        }
                        case 5: {
                            INamed iNamed = BimImporter.parseHole(object3, arrayList);
                            if (iNamed == null) break;
                            arrayList4.add((Surface)iNamed);
                            break;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new IOException(String.format(Intl.intl("Error on line %d: %s"), n2, iOException.getMessage()));
        }
        object = new ArrayList();
        for (Map.Entry entry : identityHashMap.entrySet()) {
            if ((Integer)entry.getValue() == -1) {
                object.add(entry.getKey());
                continue;
            }
            ((ModelComposite)arrayList.get((Integer)entry.getValue())).add((IPyroObject)entry.getKey());
        }
        serialized.surfmgr.addAll(arrayList2);
        serialized.obstructions.addAll((Collection<IPyroObject>)object);
    }

    private static StreamTokenizer newTokenizer(String string) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.lowerCaseMode(false);
        streamTokenizer.parseNumbers();
        streamTokenizer.quoteChar(34);
        return streamTokenizer;
    }

    private static void checkToken(StreamTokenizer streamTokenizer, int n) throws IOException {
        int n2 = streamTokenizer.nextToken();
        if (n2 != n) {
            throw new IOException(Intl.intl("Could not read file"));
        }
    }

    private static String readString(StreamTokenizer streamTokenizer) throws IOException {
        BimImporter.checkToken(streamTokenizer, 34);
        return streamTokenizer.sval;
    }

    private static double readDouble(StreamTokenizer streamTokenizer) throws IOException {
        BimImporter.checkToken(streamTokenizer, -2);
        return streamTokenizer.nval;
    }

    private static int readInt(StreamTokenizer streamTokenizer) throws IOException {
        BimImporter.checkToken(streamTokenizer, -2);
        return (int)streamTokenizer.nval;
    }

    private static void skipChar(StreamTokenizer streamTokenizer, char c) throws IOException {
        BimImporter.checkToken(streamTokenizer, c);
    }

    private static ModelComposite parseGroup(String string, Map<ModelComposite, Integer> map) throws IOException {
        StreamTokenizer streamTokenizer = BimImporter.newTokenizer(string);
        BimImporter.readInt(streamTokenizer);
        BimImporter.skipChar(streamTokenizer, ':');
        int n = BimImporter.readInt(streamTokenizer);
        String string2 = BimImporter.readString(streamTokenizer);
        ModelComposite modelComposite = new ModelComposite(string2);
        map.put(modelComposite, n);
        return modelComposite;
    }

    private static Surface parseMaterial(String string) throws IOException {
        StreamTokenizer streamTokenizer = BimImporter.newTokenizer(string);
        BimImporter.readInt(streamTokenizer);
        BimImporter.skipChar(streamTokenizer, ':');
        String string2 = BimImporter.readString(streamTokenizer);
        Surface surface = new Surface(string2);
        return surface;
    }

    private static AABoxGeom readGeom(StreamTokenizer streamTokenizer) throws IOException {
        double d = BimImporter.readDouble(streamTokenizer);
        double d2 = BimImporter.readDouble(streamTokenizer);
        double d3 = BimImporter.readDouble(streamTokenizer);
        double d4 = BimImporter.readDouble(streamTokenizer);
        double d5 = BimImporter.readDouble(streamTokenizer);
        double d6 = BimImporter.readDouble(streamTokenizer);
        return new AABoxGeom(new Point3d(d, d3, d5), new Point3d(d2, d4, d6), 0);
    }

    private static FDSObject parseSolid(String string, List<ModelComposite> list, Surface surface, List<Surface> list2) throws IOException {
        StreamTokenizer streamTokenizer = BimImporter.newTokenizer(string);
        BimImporter.readInt(streamTokenizer);
        BimImporter.skipChar(streamTokenizer, ':');
        int n = BimImporter.readInt(streamTokenizer);
        String string2 = BimImporter.readString(streamTokenizer);
        int n2 = BimImporter.readInt(streamTokenizer);
        AABoxGeom aABoxGeom = BimImporter.readGeom(streamTokenizer);
        Surface surface2 = n2 != -1 ? list2.get(n2) : surface;
        Obstruction obstruction = new Obstruction(string2, aABoxGeom, new Surface[]{surface2});
        if (n != -1) {
            list.get(n).add(obstruction);
            return obstruction;
        }
        return null;
    }

    private static FDSObject parseHole(String string, List<ModelComposite> list) throws IOException {
        StreamTokenizer streamTokenizer = BimImporter.newTokenizer(string);
        BimImporter.readInt(streamTokenizer);
        BimImporter.skipChar(streamTokenizer, ':');
        int n = BimImporter.readInt(streamTokenizer);
        String string2 = BimImporter.readString(streamTokenizer);
        AABoxGeom aABoxGeom = BimImporter.readGeom(streamTokenizer);
        Hole hole = new Hole(string2, aABoxGeom);
        if (n != -1) {
            list.get(n).add(hole);
            return hole;
        }
        return null;
    }
}

