/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.geom.rasterization;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3i;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.geom.rasterization.IRaster3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.EdgeUse;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.FaceLoop;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Model;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Raster3D_V2
implements IRaster3D {
    private static final double EPSILON = 1.0E-9;
    private static final Vector3d XPOS = new Vector3d(1.0, 0.0, 0.0);
    private static final Vector3d YPOS = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d ZPOS = new Vector3d(0.0, 0.0, 1.0);
    private static final Matrix3i s_xyLWXform = new Matrix3i(1, 0, 0, 0, 1, 0, 0, 0, 1);
    private static final Matrix3i s_xzLWXform = new Matrix3i(1, 0, 0, 0, 0, 1, 0, 1, 0);
    private static final Matrix3i s_yzLWXform = new Matrix3i(0, 0, 1, 1, 0, 0, 0, 1, 0);
    private ConvexVolume d_rastVolume;
    private double[] d_xDiv;
    private double[] d_yDiv;
    private double[] d_zDiv;
    private int d_currGroup;
    private final Map<Point3i, Integer> d_cells;
    private final CellList d_xyCells = new CellList(Dir.Z);
    private final CellList d_xzCells = new CellList(Dir.Y);
    private final CellList d_yzCells = new CellList(Dir.X);
    private static final Point3i[] s_cellAdjCell = new Point3i[]{new Point3i(-1, -1, -1), new Point3i(-1, 0, -1), new Point3i(-1, 1, -1), new Point3i(0, -1, -1), new Point3i(0, 0, -1), new Point3i(0, 1, -1), new Point3i(1, -1, -1), new Point3i(1, 0, -1), new Point3i(1, 1, -1), new Point3i(-1, -1, 0), new Point3i(-1, 0, 0), new Point3i(-1, 1, 0), new Point3i(0, -1, 0), new Point3i(0, 1, 0), new Point3i(1, -1, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0), new Point3i(-1, -1, 1), new Point3i(-1, 0, 1), new Point3i(-1, 1, 1), new Point3i(0, -1, 1), new Point3i(0, 0, 1), new Point3i(0, 1, 1), new Point3i(1, -1, 1), new Point3i(1, 0, 1), new Point3i(1, 1, 1)};
    private static final Point3i[] s_cellAdjXY = new Point3i[]{new Point3i(-1, -1, 0), new Point3i(-1, 0, 0), new Point3i(-1, 1, 0), new Point3i(0, -1, 0), new Point3i(0, 1, 0), new Point3i(1, -1, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0), new Point3i(-1, -1, 1), new Point3i(-1, 0, 1), new Point3i(-1, 1, 1), new Point3i(0, -1, 1), new Point3i(0, 1, 1), new Point3i(1, -1, 1), new Point3i(1, 0, 1), new Point3i(1, 1, 1)};
    private static final Point3i[] s_cellAdjXZ = new Point3i[]{new Point3i(-1, 0, -1), new Point3i(0, 0, -1), new Point3i(1, 0, -1), new Point3i(-1, 0, 0), new Point3i(1, 0, 0), new Point3i(-1, 0, 1), new Point3i(0, 0, 1), new Point3i(1, 0, 1), new Point3i(-1, 1, -1), new Point3i(0, 1, -1), new Point3i(1, 1, -1), new Point3i(-1, 1, 0), new Point3i(1, 1, 0), new Point3i(-1, 1, 1), new Point3i(0, 1, 1), new Point3i(1, 1, 1)};
    private static final Point3i[] s_cellAdjYZ = new Point3i[]{new Point3i(0, -1, -1), new Point3i(0, 0, -1), new Point3i(0, 1, -1), new Point3i(0, -1, 0), new Point3i(0, 1, 0), new Point3i(0, -1, 1), new Point3i(0, 0, 1), new Point3i(0, 1, 1), new Point3i(1, -1, -1), new Point3i(1, 0, -1), new Point3i(1, 1, -1), new Point3i(1, -1, 0), new Point3i(1, 1, 0), new Point3i(1, -1, 1), new Point3i(1, 0, 1), new Point3i(1, 1, 1)};
    private static final Point3i[] s_xyAdjCell = Raster3D_V2.calcCellAdj(null);
    private static final Point3i[] s_xyAdjXY = Raster3D_V2.calcXYAdj(null);
    private static final Point3i[] s_xyAdjXZ = Raster3D_V2.calcXZAdj(null);
    private static final Point3i[] s_xyAdjYZ = Raster3D_V2.calcYZAdj(null);
    private static final Point3i[] s_xzAdjCell = Raster3D_V2.calcCellAdj(s_xzLWXform);
    private static final Point3i[] s_xzAdjXY = Raster3D_V2.calcXZAdj(s_xzLWXform);
    private static final Point3i[] s_xzAdjXZ = Raster3D_V2.calcXYAdj(s_xzLWXform);
    private static final Point3i[] s_xzAdjYZ = Raster3D_V2.calcYZAdj(s_xzLWXform);
    private static final Point3i[] s_yzAdjCell = Raster3D_V2.calcCellAdj(s_yzLWXform);
    private static final Point3i[] s_yzAdjXY = Raster3D_V2.calcXZAdj(s_yzLWXform);
    private static final Point3i[] s_yzAdjXZ = Raster3D_V2.calcYZAdj(s_yzLWXform);
    private static final Point3i[] s_yzAdjYZ = Raster3D_V2.calcXYAdj(s_yzLWXform);

    public Raster3D_V2(double[] dArray, double[] dArray2, double[] dArray3) {
        this(dArray, dArray2, dArray3, 0);
    }

    public Raster3D_V2(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        assert (dArray.length > 0 && dArray2.length > 0 && dArray3.length > 0);
        this.setCurrentGroup(n);
        this.d_cells = new HashMap<Point3i, Integer>();
        this.setDivisions(dArray, dArray2, dArray3);
    }

    private static double[] getCenters(double[] dArray) {
        double[] dArray2 = new double[dArray.length - 1];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = (dArray[i] + dArray[i + 1]) * 0.5;
        }
        return dArray2;
    }

    @Override
    public void setDivisions(double[] dArray, double[] dArray2, double[] dArray3) {
        this.clear();
        if (dArray == null || dArray2 == null || dArray3 == null) {
            return;
        }
        this.d_xDiv = dArray;
        this.d_yDiv = dArray2;
        this.d_zDiv = dArray3;
        double d = this.d_xDiv[0];
        double d2 = this.d_xDiv[this.d_xDiv.length - 1];
        double d3 = this.d_yDiv[0];
        double d4 = this.d_yDiv[this.d_yDiv.length - 1];
        double d5 = this.d_zDiv[0];
        double d6 = this.d_zDiv[this.d_zDiv.length - 1];
        assert (d <= d2 && d3 <= d4 && d5 <= d6) : "Inside out raster error";
        Point3d point3d = new Point3d(d, d3, d5);
        Point3d point3d2 = new Point3d(d, d3, d6);
        Point3d point3d3 = new Point3d(d, d4, d5);
        Point3d point3d4 = new Point3d(d, d4, d6);
        Point3d point3d5 = new Point3d(d2, d3, d5);
        Point3d point3d6 = new Point3d(d2, d3, d6);
        Point3d point3d7 = new Point3d(d2, d4, d5);
        Point3d point3d8 = new Point3d(d2, d4, d6);
        ConvexPolygon[] convexPolygonArray = new ConvexPolygon[]{new ConvexPolygon(point3d, point3d3, point3d4, point3d2), new ConvexPolygon(point3d5, point3d6, point3d8, point3d7), new ConvexPolygon(point3d, point3d2, point3d6, point3d5), new ConvexPolygon(point3d7, point3d8, point3d4, point3d3), new ConvexPolygon(point3d, point3d5, point3d7, point3d3), new ConvexPolygon(point3d2, point3d4, point3d8, point3d6)};
        this.d_rastVolume = new ConvexVolume(convexPolygonArray);
    }

    @Override
    public double[] getXDiv() {
        return this.d_xDiv;
    }

    @Override
    public double[] getYDiv() {
        return this.d_yDiv;
    }

    @Override
    public double[] getZDiv() {
        return this.d_zDiv;
    }

    public void setCurrentGroup(int n) {
        this.d_currGroup = n;
    }

    @Override
    public void clear() {
        this.d_cells.clear();
        this.d_xyCells.clear();
        this.d_xzCells.clear();
        this.d_yzCells.clear();
    }

    @Override
    public boolean merge(IRaster3D iRaster3D) {
        if (!(iRaster3D instanceof Raster3D_V2)) {
            return false;
        }
        Raster3D_V2 raster3D_V2 = (Raster3D_V2)iRaster3D;
        this.d_cells.putAll(raster3D_V2.d_cells);
        this.d_xyCells.merge(raster3D_V2.d_xyCells);
        this.d_yzCells.merge(raster3D_V2.d_yzCells);
        this.d_xzCells.merge(raster3D_V2.d_xzCells);
        return true;
    }

    @Override
    public void finalizeData() {
        this.removeInternalFaces();
    }

    @Override
    public IRaster3D.CellListing[] getListings(boolean bl) {
        IRaster3D.CellListing cellListing;
        if (this.d_cells.isEmpty() && this.d_xyCells.d_cells.isEmpty() && this.d_xzCells.d_cells.isEmpty() && this.d_yzCells.d_cells.isEmpty()) {
            return new IRaster3D.CellListing[0];
        }
        if (!bl) {
            IRaster3D.CellListing cellListing2 = new IRaster3D.CellListing();
            cellListing2.cell = this.getCellListings();
            cellListing2.xy = this.d_xyCells.getCellListings();
            cellListing2.xz = this.d_xzCells.getCellListings();
            cellListing2.yz = this.d_yzCells.getCellListings();
            return new IRaster3D.CellListing[]{cellListing2};
        }
        ArrayList<IRaster3D.CellListing> arrayList = new ArrayList<IRaster3D.CellListing>();
        HashSet<Point3i> hashSet = new HashSet<Point3i>();
        HashSet<Point3i> hashSet2 = new HashSet<Point3i>();
        HashSet<Point3i> hashSet3 = new HashSet<Point3i>();
        HashSet<Point3i> hashSet4 = new HashSet<Point3i>();
        for (Point3i point3i : this.d_cells.keySet()) {
            cellListing = this.getTouchingCells(point3i, null, null, null, hashSet, hashSet2, hashSet3, hashSet4);
            if (cellListing == null) continue;
            arrayList.add(cellListing);
        }
        for (Point3i point3i : this.d_xyCells.d_cells.keySet()) {
            cellListing = this.getTouchingCells(null, point3i, null, null, hashSet, hashSet2, hashSet3, hashSet4);
            if (cellListing == null) continue;
            arrayList.add(cellListing);
        }
        for (Point3i point3i : this.d_xzCells.d_cells.keySet()) {
            cellListing = this.getTouchingCells(null, null, point3i, null, hashSet, hashSet2, hashSet3, hashSet4);
            if (cellListing == null) continue;
            arrayList.add(cellListing);
        }
        for (Point3i point3i : this.d_yzCells.d_cells.keySet()) {
            cellListing = this.getTouchingCells(null, null, null, point3i, hashSet, hashSet2, hashSet3, hashSet4);
            if (cellListing == null) continue;
            arrayList.add(cellListing);
        }
        return arrayList.toArray(new IRaster3D.CellListing[arrayList.size()]);
    }

    private static Point3i[] calcCellAdj(Matrix3i matrix3i) {
        return Raster3D_V2.xform(matrix3i, new Point3i(-1, -1, -1), new Point3i(-1, 0, -1), new Point3i(-1, 1, -1), new Point3i(0, -1, -1), new Point3i(0, 1, -1), new Point3i(1, -1, -1), new Point3i(1, 0, -1), new Point3i(1, 1, -1), new Point3i(-1, -1, 0), new Point3i(-1, 0, 0), new Point3i(-1, 1, 0), new Point3i(0, -1, 0), new Point3i(0, 1, 0), new Point3i(1, -1, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0));
    }

    private static Point3i[] calcXYAdj(Matrix3i matrix3i) {
        return Raster3D_V2.xform(matrix3i, new Point3i(-1, -1, 0), new Point3i(-1, 0, 0), new Point3i(-1, 1, 0), new Point3i(0, -1, 0), new Point3i(0, 1, 0), new Point3i(1, -1, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0));
    }

    private static Point3i[] calcXZAdj(Matrix3i matrix3i) {
        return Raster3D_V2.xform(matrix3i, new Point3i(-1, 0, -1), new Point3i(0, 0, -1), new Point3i(1, 0, -1), new Point3i(-1, 0, 0), new Point3i(0, 0, 0), new Point3i(1, 0, 0), new Point3i(-1, 1, -1), new Point3i(0, 1, -1), new Point3i(1, 1, -1), new Point3i(-1, 1, 0), new Point3i(0, 1, 0), new Point3i(1, 1, 0));
    }

    private static Point3i[] calcYZAdj(Matrix3i matrix3i) {
        return Raster3D_V2.xform(matrix3i, new Point3i(0, -1, -1), new Point3i(0, 0, -1), new Point3i(0, 1, -1), new Point3i(0, -1, 0), new Point3i(0, 0, 0), new Point3i(0, 1, 0), new Point3i(1, -1, -1), new Point3i(1, 0, -1), new Point3i(1, 1, -1), new Point3i(1, -1, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0));
    }

    private static Point3i[] xform(Matrix3i matrix3i, Point3i ... point3iArray) {
        if (matrix3i == null) {
            return point3iArray;
        }
        for (int i = 0; i < point3iArray.length; ++i) {
            point3iArray[i] = matrix3i.transform(point3iArray[i]);
        }
        return point3iArray;
    }

    private IRaster3D.CellListing getTouchingCells(Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4, Set<Point3i> set, Set<Point3i> set2, Set<Point3i> set3, Set<Point3i> set4) {
        Object object;
        ArrayDeque<Point3i> arrayDeque = new ArrayDeque<Point3i>();
        ArrayDeque<Point3i> arrayDeque2 = new ArrayDeque<Point3i>();
        ArrayDeque<Point3i> arrayDeque3 = new ArrayDeque<Point3i>();
        ArrayDeque<Point3i> arrayDeque4 = new ArrayDeque<Point3i>();
        if (point3i != null) {
            if (!set.add(point3i)) {
                return null;
            }
            arrayDeque.push(point3i);
        } else if (point3i2 != null) {
            if (!set2.add(point3i2)) {
                return null;
            }
            arrayDeque2.push(point3i2);
        } else if (point3i3 != null) {
            if (!set3.add(point3i3)) {
                return null;
            }
            arrayDeque3.push(point3i3);
        } else if (point3i4 != null) {
            if (!set4.add(point3i4)) {
                return null;
            }
            arrayDeque4.push(point3i4);
        } else assert (false);
        ArrayList<Point3i> arrayList = new ArrayList<Point3i>();
        ArrayList<Point3i> arrayList2 = new ArrayList<Point3i>();
        ArrayList<Point3i> arrayList3 = new ArrayList<Point3i>();
        ArrayList<Point3i> arrayList4 = new ArrayList<Point3i>();
        Point3i point3i5 = new Point3i();
        while (!(arrayDeque.isEmpty() && arrayDeque2.isEmpty() && arrayDeque3.isEmpty() && arrayDeque4.isEmpty())) {
            Point3i[] point3iArray;
            Point3i[] point3iArray2;
            Point3i[] point3iArray3;
            Point3i[] point3iArray4;
            if (!arrayDeque.isEmpty()) {
                object = (Point3i)arrayDeque.pop();
                arrayList.add((Point3i)object);
                point3iArray4 = s_cellAdjCell;
                point3iArray3 = s_cellAdjXY;
                point3iArray2 = s_cellAdjXZ;
                point3iArray = s_cellAdjYZ;
            } else if (!arrayDeque2.isEmpty()) {
                object = (Point3i)arrayDeque2.pop();
                arrayList2.add((Point3i)object);
                point3iArray4 = s_xyAdjCell;
                point3iArray3 = s_xyAdjXY;
                point3iArray2 = s_xyAdjXZ;
                point3iArray = s_xyAdjYZ;
            } else if (!arrayDeque3.isEmpty()) {
                object = (Point3i)arrayDeque3.pop();
                arrayList3.add((Point3i)object);
                point3iArray4 = s_xzAdjCell;
                point3iArray3 = s_xzAdjXY;
                point3iArray2 = s_xzAdjXZ;
                point3iArray = s_xzAdjYZ;
            } else {
                object = (Point3i)arrayDeque4.pop();
                arrayList4.add((Point3i)object);
                point3iArray4 = s_yzAdjCell;
                point3iArray3 = s_yzAdjXY;
                point3iArray2 = s_yzAdjXZ;
                point3iArray = s_yzAdjYZ;
            }
            Raster3D_V2.addAdjCells((Point3i)object, point3iArray4, set, arrayDeque, this.d_cells, point3i5);
            Raster3D_V2.addAdjCells((Point3i)object, point3iArray3, set2, arrayDeque2, this.d_xyCells.d_cells, point3i5);
            Raster3D_V2.addAdjCells((Point3i)object, point3iArray2, set3, arrayDeque3, this.d_xzCells.d_cells, point3i5);
            Raster3D_V2.addAdjCells((Point3i)object, point3iArray, set4, arrayDeque4, this.d_yzCells.d_cells, point3i5);
        }
        if (arrayList.isEmpty() && arrayList2.isEmpty() && arrayList3.isEmpty() && arrayList4.isEmpty()) {
            return null;
        }
        object = new IRaster3D.CellListing();
        ((IRaster3D.CellListing)object).cell = this.getCellListings(arrayList);
        ((IRaster3D.CellListing)object).xy = this.d_xyCells.getCellListings(arrayList2);
        ((IRaster3D.CellListing)object).xz = this.d_xzCells.getCellListings(arrayList3);
        ((IRaster3D.CellListing)object).yz = this.d_yzCells.getCellListings(arrayList4);
        if (((IRaster3D.CellListing)object).cell.length == 0 && ((IRaster3D.CellListing)object).xy.length == 0 && ((IRaster3D.CellListing)object).xz.length == 0 && ((IRaster3D.CellListing)object).yz.length == 0) {
            return null;
        }
        return object;
    }

    private static void addAdjCells(Point3i point3i, Point3i[] point3iArray, Set<Point3i> set, Deque<Point3i> deque, Map<Point3i, ?> map, Point3i point3i2) {
        for (Point3i point3i3 : point3iArray) {
            point3i2.add(point3i, point3i3);
            if (!map.containsKey(point3i2) || set.contains(point3i2)) continue;
            Point3i point3i4 = new Point3i(point3i2);
            set.add(point3i4);
            deque.push(point3i4);
        }
    }

    private Pair<Point3i, int[]>[] getCellListings() {
        return this.getCellListings(this.d_cells.keySet());
    }

    private Pair<Point3i, int[]>[] getCellListings(Collection<Point3i> collection) {
        Point3i point3i = new Point3i();
        ArrayList<Pair<Point3i, int[]>> arrayList = new ArrayList<Pair<Point3i, int[]>>(collection.size());
        for (Point3i point3i2 : collection) {
            int n = this.d_cells.get(point3i2);
            point3i.set(point3i2);
            Cell cell = (Cell)this.d_xyCells.d_cells.get(point3i);
            Cell cell2 = (Cell)this.d_xzCells.d_cells.get(point3i);
            Cell cell3 = (Cell)this.d_yzCells.d_cells.get(point3i);
            point3i.set(point3i2.x, point3i2.y, point3i2.z + 1);
            Cell cell4 = (Cell)this.d_xyCells.d_cells.get(point3i);
            point3i.set(point3i2.x, point3i2.y + 1, point3i2.z);
            Cell cell5 = (Cell)this.d_xzCells.d_cells.get(point3i);
            point3i.set(point3i2.x + 1, point3i2.y, point3i2.z);
            Cell cell6 = (Cell)this.d_yzCells.d_cells.get(point3i);
            int n2 = cell3 != null ? cell3.minid : n;
            int n3 = cell6 != null ? cell6.maxid : n;
            int n4 = cell2 != null ? cell2.minid : n;
            int n5 = cell5 != null ? cell5.maxid : n;
            int n6 = cell != null ? cell.minid : n;
            int n7 = cell4 != null ? cell4.maxid : n;
            int[] nArray = new int[]{n2, n3, n4, n5, n6, n7};
            if (Raster3D_V2.areAllSame(nArray)) {
                nArray = new int[]{n2};
            }
            arrayList.add(new Pair<Point3i, int[]>(point3i2, nArray));
        }
        return arrayList.toArray(new Pair[arrayList.size()]);
    }

    private static boolean areAllSame(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            return false;
        }
        return true;
    }

    private void addCell(Point3i point3i, Integer n) {
        this.d_cells.put(new Point3i(point3i), n);
    }

    @Override
    public void rasterizePolygon(int n, Point3d ... point3dArray) {
        this.rasterizeSimplePolygon(2, n, point3dArray);
    }

    public void rasterizeSimplePolygon(int n, int n2, Point3d ... point3dArray) {
        this.setCurrentGroup(n2);
        Point3d[] point3dArray2 = this.clipPoly(point3dArray);
        point3dArray2 = Raster3D_V2.deleteAdjacentDuplicates(1.0E-9, point3dArray2);
        if (point3dArray2.length < 3) {
            return;
        }
        this.rasterizeClippedPoly(n, point3dArray2);
    }

    private Point3i getRoundedIx(Point3d point3d) {
        return new Point3i(Raster3D_V2.getRoundedCoord(this.d_xDiv, point3d.x), Raster3D_V2.getRoundedCoord(this.d_yDiv, point3d.y), Raster3D_V2.getRoundedCoord(this.d_zDiv, point3d.z));
    }

    private static int getRoundedCoord(double[] dArray, double d) {
        int n = Arrays.binarySearch(dArray, d);
        if (n < 0) {
            if ((n = -(n + 1)) == 0) {
                return 0;
            }
            if (n == dArray.length) {
                return dArray.length - 1;
            }
            double d2 = dArray[n - 1];
            double d3 = dArray[n];
            return theUtil.le(d - d2, d3 - d, 1.0E-9) ? n - 1 : n;
        }
        return n;
    }

    private static int compareNorm(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    private void rasterizeLineSeg(Point3d point3d, Point3d point3d2, Point3i point3i, Point3i point3i2, Point3i[] point3iArray, Point3d point3d3, Point3i point3i3, ScanLineBoundsAdder scanLineBoundsAdder) {
        if (point3d2.x < point3d.x || point3d2.x == point3d.x && point3d2.y < point3d.y || point3d2.x == point3d.x && point3d2.y == point3d.y && point3d2.z < point3d.z) {
            Point3d point3d4 = point3d;
            point3d = point3d2;
            point3d2 = point3d4;
            Point3i point3i4 = point3i;
            point3i = point3i2;
            point3i2 = point3i4;
        }
        this.rasterizeLineSeg(point3d, point3d2, point3i, point3i2, point3iArray, point3i3, point3d3, scanLineBoundsAdder);
    }

    private void rasterizeLineSeg(Point3d point3d, Point3d point3d2, Point3i point3i, Point3i point3i2, Point3i[] point3iArray, Point3i point3i3, Point3d point3d3, ScanLineBoundsAdder scanLineBoundsAdder) {
        int n = Raster3D_V2.compareNorm(point3i2.x, point3i.x);
        int n2 = Raster3D_V2.compareNorm(point3i2.y, point3i.y);
        int n3 = Raster3D_V2.compareNorm(point3i2.z, point3i.z);
        Point3i point3i4 = point3i;
        Point3i point3i5 = point3i3;
        point3i5.set(point3i4);
        while (!point3i4.equals(point3i2)) {
            boolean bl;
            boolean bl2 = point3i4.x != point3i2.x;
            boolean bl3 = point3i4.y != point3i2.y;
            boolean bl4 = bl = point3i4.z != point3i2.z;
            if (bl2 && !bl3 && !bl) {
                point3i5.x += n;
            } else if (!bl2 && bl3 && !bl) {
                point3i5.y += n2;
            } else if (!bl2 && !bl3 && bl) {
                point3i5.z += n3;
            } else {
                double d;
                double d2;
                boolean bl5;
                boolean bl6 = bl2 && bl3;
                boolean bl7 = bl2 && !bl3 && bl;
                boolean bl8 = bl5 = !bl2 && bl3 && bl;
                if (bl6) {
                    d2 = Inter2D.distSqToNearestPtOnLine2(point3d.x, point3d.y, point3d2.x, point3d2.y, this.d_xDiv[point3i4.x + n], this.d_yDiv[point3i4.y]);
                    d = Inter2D.distSqToNearestPtOnLine2(point3d.x, point3d.y, point3d2.x, point3d2.y, this.d_xDiv[point3i4.x], this.d_yDiv[point3i4.y + n2]);
                    if (bl) {
                        bl7 = theUtil.le(d2, d, 1.0E-12);
                        bl5 = !bl7;
                    } else if (theUtil.le(d2, d, 1.0E-12)) {
                        point3i5.x += n;
                    } else {
                        point3i5.y += n2;
                    }
                }
                if (bl7) {
                    d2 = Inter2D.distSqToNearestPtOnLine2(point3d.x, point3d.z, point3d2.x, point3d2.z, this.d_xDiv[point3i4.x + n], this.d_zDiv[point3i4.z]);
                    if (theUtil.le(d2, d = Inter2D.distSqToNearestPtOnLine2(point3d.x, point3d.z, point3d2.x, point3d2.z, this.d_xDiv[point3i4.x], this.d_zDiv[point3i4.z + n3]), 1.0E-12)) {
                        point3i5.x += n;
                    } else {
                        point3i5.z += n3;
                    }
                }
                if (bl5) {
                    d2 = Inter2D.distSqToNearestPtOnLine2(point3d.y, point3d.z, point3d2.y, point3d2.z, this.d_yDiv[point3i4.y + n2], this.d_zDiv[point3i4.z]);
                    if (theUtil.le(d2, d = Inter2D.distSqToNearestPtOnLine2(point3d.y, point3d.z, point3d2.y, point3d2.z, this.d_yDiv[point3i4.y], this.d_zDiv[point3i4.z + n3]), 1.0E-12)) {
                        point3i5.y += n2;
                    } else {
                        point3i5.z += n3;
                    }
                }
            }
            if (scanLineBoundsAdder != null) {
                scanLineBoundsAdder.add(point3i4, point3i5);
            }
            point3i4 = new Point3i(point3i5);
        }
    }

    private void rasterizeClippedPoly(int n, Point3d ... point3dArray) {
        Point3i point3i;
        Point3i point3i2 = new Point3i(this.d_xDiv.length - 1, this.d_yDiv.length - 1, this.d_zDiv.length - 1);
        Point3i point3i3 = new Point3i(0, 0, 0);
        Point3i[] point3iArray = new Point3i[point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            point3iArray[i] = point3i = this.getRoundedIx(point3dArray[i]);
            if (point3i.x < point3i2.x) {
                point3i2.x = point3i.x;
            }
            if (point3i.x > point3i3.x) {
                point3i3.x = point3i.x;
            }
            if (point3i.y < point3i2.y) {
                point3i2.y = point3i.y;
            }
            if (point3i.y > point3i3.y) {
                point3i3.y = point3i.y;
            }
            if (point3i.z < point3i2.z) {
                point3i2.z = point3i.z;
            }
            if (point3i.z <= point3i3.z) continue;
            point3i3.z = point3i.z;
        }
        Point3i[] point3iArray2 = new Point3i[]{new Point3i(), new Point3i(), new Point3i()};
        point3i = new Point3i();
        Point3d point3d = new Point3d();
        Plane3d plane3d = new Plane3d(point3dArray);
        ScanLineBoundsAdder scanLineBoundsAdder = new ScanLineBoundsAdder(plane3d, point3i2, point3i3);
        for (int i = 0; i < point3dArray.length; ++i) {
            int n2 = (i + 1) % point3dArray.length;
            Point3d point3d2 = point3dArray[i];
            Point3d point3d3 = point3dArray[n2];
            Point3i point3i4 = point3iArray[i];
            Point3i point3i5 = point3iArray[n2];
            this.rasterizeLineSeg(point3d2, point3d3, point3i4, point3i5, point3iArray2, point3d, point3i, scanLineBoundsAdder);
        }
        scanLineBoundsAdder.sortScans();
        if (scanLineBoundsAdder.d_planeAlign == 0) {
            Raster3D_V2.rasterizeLocalPoly(n, this.d_currGroup, this.d_xDiv, this.d_yDiv, this.d_zDiv, plane3d, point3i2.x, point3i3.x, point3i2.y, point3i3.y, scanLineBoundsAdder.xScanBounds, scanLineBoundsAdder.yScanBounds, this.d_xyCells, this.d_xzCells, this.d_yzCells, s_xyLWXform, new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0));
        } else if (scanLineBoundsAdder.d_planeAlign == 1) {
            Raster3D_V2.rasterizeLocalPoly(n, this.d_currGroup, this.d_xDiv, this.d_zDiv, this.d_yDiv, plane3d, point3i2.x, point3i3.x, point3i2.z, point3i3.z, scanLineBoundsAdder.xScanBounds, scanLineBoundsAdder.yScanBounds, this.d_xzCells, this.d_xyCells, this.d_yzCells, s_xzLWXform, new Matrix3d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0));
        } else {
            Raster3D_V2.rasterizeLocalPoly(n, this.d_currGroup, this.d_yDiv, this.d_zDiv, this.d_xDiv, plane3d, point3i2.y, point3i3.y, point3i2.z, point3i3.z, scanLineBoundsAdder.xScanBounds, scanLineBoundsAdder.yScanBounds, this.d_yzCells, this.d_xyCells, this.d_xzCells, s_yzLWXform, new Matrix3d(0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0));
        }
    }

    private static void rasterizeLocalPoly(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3, Plane3d plane3d, int n3, int n4, int n5, int n6, List<int[]>[] listArray, List<int[]>[] listArray2, CellList cellList, CellList cellList2, CellList cellList3, Matrix3i matrix3i, Matrix3d matrix3d) {
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int[] nArray;
        int[] nArray2;
        int n15;
        int n16;
        List<int[]> list;
        int n17;
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3i[] point3iArray = new Point3i[]{new Point3i(), new Point3i()};
        int[][] nArray3 = new int[n4 - n3 + 2][n6 - n5 + 2];
        for (n17 = 0; n17 < nArray3.length; ++n17) {
            Arrays.fill(nArray3[n17], -1);
        }
        for (n17 = 0; n17 < listArray2.length; ++n17) {
            list = listArray2[n17];
            if (list == null) continue;
            n16 = n17 + n5;
            assert (list.size() % 2 == 0);
            n15 = 0;
            while (n15 + 1 < list.size()) {
                nArray2 = list.get(n15);
                nArray = list.get(n15 + 1);
                n14 = nArray2[0];
                n13 = nArray2[1];
                n12 = nArray[0];
                n11 = nArray[1];
                n10 = Raster3D_V2.compareNorm(n11, n13);
                if (n14 != n12 && n10 == 0) {
                    for (n9 = n14; n9 < n12; ++n9) {
                        cellList.addCell(n, matrix3i.transform(new Point3i(n9, n16, n13)), n2, plane3d);
                        nArray3[n9 - n3 + 1][n16 - n5 + 1] = n13;
                    }
                } else if (n14 == n12 && n10 != 0) {
                    for (n9 = n13; n9 != n11; n9 += n10) {
                        cellList3.addCell(n, matrix3i.transform(new Point3i(n14, n16, Math.min(n9, n9 + n10))), n2, plane3d);
                    }
                } else if (n14 != n12 || n10 != 0) {
                    point3iArray[0].set(1, 0, 0);
                    point3iArray[1].set(0, 0, n10);
                    point3d.y = (dArray2[n16] + dArray2[n16 + 1]) * 0.5;
                    n9 = n14;
                    for (n7 = n13; n9 != n12 || n7 != n11; n9 += point3iArray[n8].x, n7 += point3iArray[n8].z) {
                        n8 = -1;
                        double d = Double.MAX_VALUE;
                        for (int i = 0; i < 2; ++i) {
                            Point3i point3i = point3iArray[i];
                            int n18 = n9 + point3i.x;
                            int n19 = n7 + point3i.z;
                            if (point3i.x != 0 && n9 == n12 || point3i.z != 0 && n7 == n11) continue;
                            point3d.x = dArray[n18];
                            point3d.z = dArray3[n19];
                            matrix3d.transform(point3d, point3d2);
                            double d2 = plane3d.distance(point3d2);
                            if (!theUtil.lt(d2, d, 1.0E-12)) continue;
                            n8 = i;
                            d = d2;
                        }
                        assert (d != Double.MAX_VALUE);
                        if (n8 == 0) {
                            cellList.addCell(n, matrix3i.transform(new Point3i(n9, n16, n7)), n2, plane3d);
                            nArray3[n9 - n3 + 1][n16 - n5 + 1] = n7;
                            continue;
                        }
                        cellList3.addCell(n, matrix3i.transform(new Point3i(n9, n16, Math.min(n7, n7 + point3iArray[n8].z))), n2, plane3d);
                    }
                }
                n15 += 2;
            }
        }
        for (n17 = 0; n17 < listArray.length; ++n17) {
            list = listArray[n17];
            if (list == null) continue;
            n16 = n17 + n3;
            assert (list.size() % 2 == 0);
            n15 = 0;
            while (n15 + 1 < list.size()) {
                nArray2 = list.get(n15);
                nArray = list.get(n15 + 1);
                n14 = nArray2[0];
                n13 = nArray2[1];
                n12 = nArray[0];
                n11 = nArray[1];
                n10 = n14;
                n9 = n13;
                while (n10 != n12 || n9 != n11) {
                    n7 = n10 == n12 ? n11 : nArray3[n16 - n3 + 1][n10 - n5 + 1];
                    n8 = Raster3D_V2.compareNorm(n7, n9);
                    assert (n7 >= 0);
                    if (n8 == 0) {
                        ++n10;
                        continue;
                    }
                    cellList2.addCell(n, matrix3i.transform(new Point3i(n16, n10, Math.min(n9, n9 + n8))), n2, plane3d);
                    n9 += n8;
                }
                n15 += 2;
            }
        }
    }

    private int[] getFaceBounds() {
        int[] nArray = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE};
        this.d_xyCells.getBounds(nArray);
        this.d_yzCells.getBounds(nArray);
        this.d_xzCells.getBounds(nArray);
        return nArray;
    }

    @Override
    public void thicken(int n) {
        int[] nArray = this.getFaceBounds();
        this.thicken(n, new int[]{0, 1, 2}, this.d_zDiv.length, this.d_xyCells, this.d_xzCells, this.d_yzCells, new int[]{nArray[0], nArray[1]}, new int[]{nArray[2], nArray[3]}, new int[]{nArray[4], nArray[5]});
        this.thicken(n, new int[]{0, 2, 1}, this.d_yDiv.length, this.d_xzCells, this.d_xyCells, this.d_yzCells, new int[]{nArray[0], nArray[1]}, new int[]{nArray[4], nArray[5]}, new int[]{nArray[2], nArray[3]});
        this.thicken(n, new int[]{1, 2, 0}, this.d_xDiv.length, this.d_yzCells, this.d_xyCells, this.d_xzCells, new int[]{nArray[2], nArray[3]}, new int[]{nArray[4], nArray[5]}, new int[]{nArray[0], nArray[1]});
        this.removeInternalFaces();
    }

    private void thicken(int n, int[] nArray, int n2, CellList cellList, CellList cellList2, CellList cellList3, int[] nArray2, int[] nArray3, int[] nArray4) {
        Integer n3 = n;
        int[] nArray5 = new int[3];
        Point3i point3i = new Point3i();
        for (int i = nArray4[0]; i <= nArray4[1]; ++i) {
            for (int j = nArray3[0]; j <= nArray3[1]; ++j) {
                for (int k = nArray2[0]; k <= nArray2[1]; ++k) {
                    int n4;
                    int n5;
                    Raster3D_V2.swizzle(nArray, k, j, i, nArray5, point3i);
                    Cell cell = (Cell)cellList.d_cells.get(point3i);
                    if (cell == null || cell.count % 2 != 0) continue;
                    boolean bl = this.d_cells.containsKey(point3i);
                    Raster3D_V2.swizzle(nArray, k, j, i - 1, nArray5, point3i);
                    boolean bl2 = this.d_cells.containsKey(point3i);
                    if (bl || bl2) continue;
                    if (i == 0) {
                        n5 = 1;
                        n4 = cell.maxid;
                    } else if (i == n2 - 1) {
                        n5 = -1;
                        n4 = cell.minid;
                    } else if (cell.maxdist >= 0.0 && cell.mindist >= 0.0) {
                        n5 = 1;
                        n4 = cell.maxid;
                    } else if (cell.maxdist <= 0.0 && cell.mindist <= 0.0) {
                        n5 = -1;
                        n4 = cell.minid;
                    } else {
                        n5 = Math.abs(cell.maxdist) >= Math.abs(cell.mindist) ? 1 : -1;
                        n4 = n5 == 1 ? cell.maxid : cell.minid;
                    }
                    cell.addPhantom();
                    Raster3D_V2.swizzle(nArray, k, j, i + n5, nArray5, point3i);
                    cellList.addPhantom(point3i, n4);
                    int n6 = n5 < 0 ? i + n5 : i;
                    Raster3D_V2.swizzle(nArray, k, j, n6, nArray5, point3i);
                    cellList3.addPhantom(point3i, n4);
                    cellList2.addPhantom(point3i, n4);
                    Raster3D_V2.swizzle(nArray, k + 1, j, n6, nArray5, point3i);
                    cellList3.addPhantom(point3i, n4);
                    Raster3D_V2.swizzle(nArray, k, j + 1, n6, nArray5, point3i);
                    cellList2.addPhantom(point3i, n4);
                    int n7 = cell.maxid == cell.minid ? cell.maxid : n3;
                    Raster3D_V2.swizzle(nArray, k, j, n6, nArray5, point3i);
                    this.addCell(point3i, n7);
                }
            }
        }
    }

    private static void swizzle(int[] nArray, int n, int n2, int n3, int[] nArray2, Point3i point3i) {
        Raster3D_V2.swizzle(nArray, n, n2, n3, nArray2);
        point3i.set(nArray2);
    }

    private static void swizzle(int[] nArray, int n, int n2, int n3, int[] nArray2) {
        nArray2[nArray[0]] = n;
        nArray2[nArray[1]] = n2;
        nArray2[nArray[2]] = n3;
    }

    public void fill(int n) {
        Integer n2 = n;
        Point3i point3i = new Point3i();
        int[] nArray = this.getFaceBounds();
        for (int i = nArray[2]; i <= nArray[3]; ++i) {
            for (int j = nArray[0]; j <= nArray[1]; ++j) {
                int n3 = -1;
                for (int k = nArray[4]; k <= nArray[5]; ++k) {
                    point3i.set(j, i, k);
                    Cell cell = (Cell)this.d_xyCells.d_cells.get(point3i);
                    if (cell == null || cell.count % 2 == 0) continue;
                    if (n3 == -1) {
                        n3 = k;
                        continue;
                    }
                    for (int i2 = n3; i2 < k; ++i2) {
                        this.d_cells.put(new Point3i(j, i, i2), n2);
                    }
                    n3 = -1;
                }
            }
        }
    }

    public void removeInternalFaces() {
        this.removeInternalFaces(this.d_xyCells, new int[]{0, 0, 1});
        this.removeInternalFaces(this.d_xzCells, new int[]{0, 1, 0});
        this.removeInternalFaces(this.d_yzCells, new int[]{1, 0, 0});
    }

    private void removeInternalFaces(CellList cellList, int[] nArray) {
        Point3i point3i = new Point3i();
        Iterator iterator = cellList.d_cells.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Point3i point3i2 = (Point3i)entry.getKey();
            boolean bl = this.d_cells.containsKey(point3i2);
            point3i.set(point3i2.x - nArray[0], point3i2.y - nArray[1], point3i2.z - nArray[2]);
            boolean bl2 = this.d_cells.containsKey(point3i);
            if (!bl || !bl2) continue;
            iterator.remove();
        }
    }

    @Override
    public void rasterizeSolid(int n, int[] nArray, Point3d[][] point3dArray) {
        Pair<Point3d[][], int[]> pair = this.clipVolume(point3dArray, nArray, n);
        if (pair == null) {
            return;
        }
        point3dArray = (Point3d[][])pair.v1;
        nArray = (int[])pair.v2;
        for (int i = 0; i < point3dArray.length; ++i) {
            this.setCurrentGroup(nArray[i]);
            this.rasterizeClippedPoly(1, point3dArray[i]);
        }
        this.fill(n);
        this.removeInternalFaces();
    }

    private Pair<Point3d[][], int[]> clipVolume(Point3d[][] point3dArray, int[] nArray, int n) {
        Random random = new Random(1L);
        Point3d[][] point3dArray2 = point3dArray;
        Plane3d[] plane3dArray = null;
        for (ConvexPolygon convexPolygon : this.d_rastVolume.d_polys) {
            ArrayList<Plane3d> arrayList;
            Object object;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(nArray.length);
            ArrayList<Point3d[]> arrayList3 = new ArrayList<Point3d[]>(point3dArray.length);
            ArrayList<Point3d> arrayList4 = new ArrayList<Point3d>();
            for (int i = 0; i < point3dArray.length; ++i) {
                object = point3dArray[i];
                object = Raster3D_V2.clipPolyToPoly(arrayList4, convexPolygon, (Point3d[])object);
                if (((Point3d[])(object = Raster3D_V2.deleteAdjacentDuplicates(1.0E-9, (Point3d[])object))).length < 3) continue;
                arrayList3.add((Point3d[])object);
                arrayList2.add(nArray[i]);
            }
            if (arrayList4.isEmpty()) {
                if (!arrayList3.isEmpty()) continue;
                return new Pair<Point3d[][], int[]>(new Point3d[0][0], new int[0]);
            }
            assert (arrayList4.size() % 2 == 0);
            ArrayList<LineSeg3D> arrayList5 = new ArrayList<LineSeg3D>(arrayList4.size() / 2);
            int n2 = 0;
            while (n2 + 1 < arrayList4.size()) {
                arrayList = (Point3d)arrayList4.get(n2);
                Point3d point3d = (Point3d)arrayList4.get(n2 + 1);
                arrayList5.add(new LineSeg3D((Point3d)((Object)arrayList), point3d));
                n2 += 2;
            }
            object = new Model();
            ((Model)object).addFace(0, convexPolygon.d_plane, arrayList5);
            if (plane3dArray == null && !((Model)object).getFaces().isEmpty()) {
                arrayList = new ArrayList<Plane3d>(point3dArray2.length);
                ArrayList<Point3d[]> arrayList6 = new ArrayList<Point3d[]>(point3dArray2.length);
                for (int i = 0; i < point3dArray2.length; ++i) {
                    Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(point3dArray2[i]));
                    if (plane3d == null) continue;
                    arrayList.add(plane3d);
                    arrayList6.add(point3dArray2[i]);
                }
                plane3dArray = arrayList.toArray(new Plane3d[arrayList.size()]);
                point3dArray2 = (Point3d[][])arrayList6.toArray((T[])new Point3d[arrayList6.size()][]);
            }
            for (Face face : ((Model)object).getFaces()) {
                Point3d[] point3dArray3;
                if (!Raster3D_V2.faceInSolid((Model)object, face, point3dArray2, plane3dArray, random) || (point3dArray3 = Raster3D_V2.toPointFace(face)).length < 3) continue;
                arrayList3.add(point3dArray3);
                arrayList2.add(n);
            }
            point3dArray = (Point3d[][])arrayList3.toArray((T[])new Point3d[arrayList3.size()][]);
            nArray = theUtil.toIntArray(arrayList2);
        }
        return new Pair<Point3d[][], int[]>(point3dArray, nArray);
    }

    private static Point3d[] toPointFace(Face face) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        for (FaceLoop faceLoop : face.edgeLoops) {
            for (EdgeUse edgeUse : faceLoop.edges) {
                arrayList.add(edgeUse.v1().loc);
            }
            if (faceLoop.edges.isEmpty()) continue;
            arrayList.add(faceLoop.edges.get((int)0).v1().loc);
        }
        Point3d[] point3dArray = arrayList.toArray(new Point3d[arrayList.size()]);
        point3dArray = Raster3D_V2.deleteAdjacentDuplicates(1.0E-9, point3dArray);
        return point3dArray;
    }

    private static boolean faceInSolid(Model model, Face face, Point3d[][] point3dArray, Plane3d[] plane3dArray, Random random) {
        Point3d point3d = model.findPointInFace(face);
        if (point3d == null) {
            return false;
        }
        Vector3d vector3d = Raster3D_V2.newRandomVec3D(random);
        int n = 0;
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d[] point3dArray2 = point3dArray[i];
            double d = Raster3D_V2.isect(point3d, vector3d, point3dArray2, plane3dArray[i], random);
            if (Double.isNaN(d)) continue;
            Point3d point3d2 = Util3D.linePoint(point3d, vector3d, d);
            if (point3d2.epsilonEquals(point3d, 1.0E-6)) {
                return true;
            }
            ++n;
        }
        return n % 2 != 0;
    }

    private static double isect(Point3d point3d, Vector3d vector3d, Point3d[] point3dArray, Plane3d plane3d, Random random) {
        double d = Inter3D.linePlaneIntersectionT(point3d, vector3d, plane3d, 1.0E-6);
        if (Double.isNaN(d) || theUtil.lt0(d, 1.0E-6)) {
            return Double.NaN;
        }
        Point3d point3d2 = Util3D.linePoint(point3d, vector3d, d);
        return Raster3D_V2.pointInFace(point3d2, point3dArray, plane3d, random) ? d : Double.NaN;
    }

    private static boolean pointInFace(Point3d point3d, Point3d[] point3dArray, Plane3d plane3d, Random random) {
        Vector3d vector3d = plane3d.getNormal();
        Vector3d vector3d2 = Raster3D_V2.newRandomVec3D(random);
        vector3d2.normalize();
        for (int i = 0; i < 3 && vector3d2.equals(vector3d); ++i) {
            vector3d2 = Raster3D_V2.newRandomVec3D(random);
            vector3d2.normalize();
        }
        Point3d point3d2 = plane3d.projectOntoPlane(Util3D.add(point3d, (Tuple3d)vector3d2));
        vector3d2.sub(point3d2, point3d);
        vector3d2.normalize();
        int n = 0;
        double[] dArray = new double[2];
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d point3d3 = point3dArray[i];
            Point3d point3d4 = point3dArray[(i + 1) % point3dArray.length];
            if (!Inter3D.copLineLineSeg(point3d, vector3d2, point3d3, point3d4, dArray, 1.0E-6, 1.0E-6) || !theUtil.ge0(dArray[0], 1.0E-6)) continue;
            if (theUtil.eq0(dArray[0], 1.0E-6)) {
                return true;
            }
            ++n;
        }
        return n % 2 != 0;
    }

    private static double randomVecComp(Random random) {
        return random.nextDouble() * 2.0 - 1.0;
    }

    private static Vector3d newRandomVec3D(Random random) {
        return new Vector3d(Raster3D_V2.randomVecComp(random), Raster3D_V2.randomVecComp(random), Raster3D_V2.randomVecComp(random));
    }

    private Point3d[] clipPoly(Point3d ... point3dArray) {
        Point3d[] point3dArray2 = point3dArray;
        for (ConvexPolygon convexPolygon : this.d_rastVolume.d_polys) {
            point3dArray2 = Raster3D_V2.clipPolyToPoly(null, convexPolygon, point3dArray2);
        }
        return point3dArray2;
    }

    private static Point3d[] clipPolyToPoly(List<Point3d> list, ConvexPolygon convexPolygon, Point3d ... point3dArray) {
        LinkedList<Point3d> linkedList = new LinkedList<Point3d>();
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d point3d;
            Point3d point3d2 = point3dArray[i];
            Point3d point3d3 = point3dArray[(i + 1) % point3dArray.length];
            boolean bl = theUtil.ge0(convexPolygon.d_plane.dot(point3d2), 1.0E-6);
            boolean bl2 = theUtil.ge0(convexPolygon.d_plane.dot(point3d3), 1.0E-6);
            if (bl) {
                linkedList.add(point3d2);
            }
            if (bl && bl2 || !bl && !bl2 || !Inter3D.linePlaneIntersection(point3d = new Point3d(), point3d2, point3d3, convexPolygon.d_plane, 0.0)) continue;
            linkedList.add(point3d);
            if (list == null) continue;
            list.add(point3d);
        }
        return linkedList.toArray(new Point3d[linkedList.size()]);
    }

    private static <T> T[] deleteAdjacentDuplicates(Class<T> clazz, T ... TArray) {
        if (TArray.length <= 1) {
            return TArray;
        }
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            T t = TArray[i];
            T t2 = TArray[(i + 1) % TArray.length];
            if (t.equals(t2)) continue;
            arrayList.add(t);
        }
        if (arrayList.size() != TArray.length) {
            Object[] objectArray = (Object[])Array.newInstance(clazz, arrayList.size());
            return arrayList.toArray(objectArray);
        }
        return TArray;
    }

    private static Point3d[] deleteAdjacentDuplicates(double d, Point3d ... point3dArray) {
        if (point3dArray.length <= 1) {
            return point3dArray;
        }
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(point3dArray.length);
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d point3d = point3dArray[i];
            Point3d point3d2 = point3dArray[(i + 1) % point3dArray.length];
            if (point3d.epsilonEquals(point3d2, d)) continue;
            arrayList.add(point3d);
        }
        if (arrayList.size() != point3dArray.length) {
            return arrayList.toArray(new Point3d[arrayList.size()]);
        }
        return point3dArray;
    }

    private static class Cell {
        public int minid;
        public int maxid;
        public double mindist;
        public double maxdist;
        public int count;

        public Cell(int n, int n2, double d) {
            this.minid = this.maxid = n2;
            this.mindist = this.maxdist = d;
            this.count = n;
        }

        public void add(int n, int n2, double d) {
            if (d >= this.maxdist) {
                this.maxdist = d;
                this.maxid = n2;
            } else if (d < this.mindist) {
                this.mindist = d;
                this.minid = n2;
            }
            this.count += n;
        }

        public void addPhantom() {
            ++this.count;
        }

        public void merge(Cell cell) {
            if (cell.maxdist >= this.maxdist) {
                this.maxdist = cell.maxdist;
                this.maxid = cell.maxid;
            }
            if (cell.mindist <= this.mindist) {
                this.mindist = cell.mindist;
                this.minid = cell.minid;
            }
            this.count += cell.count;
        }
    }

    public class CellList {
        private final int[] d_adds;
        private final Vector3d d_dir;
        private Map<Point3i, Cell> d_cells;

        public CellList(Dir dir) {
            switch (dir) {
                case X: {
                    this.d_dir = new Vector3d(1.0, 0.0, 0.0);
                    this.d_adds = new int[]{0, 1, 1};
                    break;
                }
                case Y: {
                    this.d_dir = new Vector3d(0.0, 1.0, 0.0);
                    this.d_adds = new int[]{1, 0, 1};
                    break;
                }
                default: {
                    this.d_dir = new Vector3d(0.0, 0.0, 1.0);
                    this.d_adds = new int[]{1, 1, 0};
                }
            }
            this.d_cells = new HashMap<Point3i, Cell>();
        }

        public void clear() {
            this.d_cells.clear();
        }

        public Pair<Point3i, int[]>[] getCellListings() {
            return this.getCellListings(this.d_cells.keySet());
        }

        public Pair<Point3i, int[]>[] getCellListings(Collection<Point3i> collection) {
            Point3i point3i = new Point3i((int)this.d_dir.x, (int)this.d_dir.y, (int)this.d_dir.z);
            Point3i point3i2 = new Point3i();
            ArrayList<Pair<Point3i, int[]>> arrayList = new ArrayList<Pair<Point3i, int[]>>();
            for (Point3i point3i3 : collection) {
                boolean bl = Raster3D_V2.this.d_cells.containsKey(point3i3);
                point3i2.sub(point3i3, point3i);
                boolean bl2 = Raster3D_V2.this.d_cells.containsKey(point3i2);
                if (bl || bl2) continue;
                Cell cell = this.d_cells.get(point3i3);
                arrayList.add(new Pair<Point3i, int[]>(point3i3, new int[]{cell.minid, cell.maxid}));
            }
            return arrayList.toArray(new Pair[arrayList.size()]);
        }

        private double calcDist(Point3i point3i, Plane3d plane3d) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6 = Raster3D_V2.this.d_xDiv[point3i.x];
            Point3d point3d = Util3D.getMidPoint(new Point3d(d6, d5 = Raster3D_V2.this.d_yDiv[point3i.y], d4 = Raster3D_V2.this.d_zDiv[point3i.z]), new Point3d(d3 = Raster3D_V2.this.d_xDiv[point3i.x + this.d_adds[0]], d2 = Raster3D_V2.this.d_yDiv[point3i.y + this.d_adds[1]], d = Raster3D_V2.this.d_zDiv[point3i.z + this.d_adds[2]]));
            double d7 = Inter3D.linePlaneIntersectionT(point3d, this.d_dir, plane3d, 1.0E-6);
            return Double.isNaN(d7) ? 0.0 : d7;
        }

        public void addCell(int n, Point3i point3i, int n2, Plane3d plane3d) {
            double d = this.calcDist(point3i, plane3d);
            Cell cell = this.d_cells.get(point3i);
            if (cell == null) {
                cell = new Cell(n, n2, d);
                this.d_cells.put(new Point3i(point3i), cell);
            } else {
                cell.add(n, n2, d);
            }
        }

        public void addPhantom(Point3i point3i, int n) {
            Cell cell = this.d_cells.get(point3i);
            if (cell == null) {
                cell = new Cell(1, n, 0.0);
                this.d_cells.put(new Point3i(point3i), cell);
            } else {
                cell.addPhantom();
            }
        }

        public void getBounds(int[] nArray) {
            for (Point3i point3i : this.d_cells.keySet()) {
                if (point3i.x < nArray[0]) {
                    nArray[0] = point3i.x;
                }
                if (point3i.x > nArray[1]) {
                    nArray[1] = point3i.x;
                }
                if (point3i.y < nArray[2]) {
                    nArray[2] = point3i.y;
                }
                if (point3i.y > nArray[3]) {
                    nArray[3] = point3i.y;
                }
                if (point3i.z < nArray[4]) {
                    nArray[4] = point3i.z;
                }
                if (point3i.z <= nArray[5]) continue;
                nArray[5] = point3i.z;
            }
        }

        public void merge(CellList cellList) {
            for (Map.Entry<Point3i, Cell> entry : cellList.d_cells.entrySet()) {
                Point3i point3i = entry.getKey();
                Cell cell = entry.getValue();
                Cell cell2 = this.d_cells.get(point3i);
                if (cell2 == null) {
                    this.d_cells.put(point3i, cell);
                    continue;
                }
                cell2.merge(cell);
            }
        }
    }

    private static class ConvexVolume {
        public final ConvexPolygon[] d_polys;

        public ConvexVolume(ConvexPolygon[] convexPolygonArray) {
            this.d_polys = convexPolygonArray;
        }
    }

    private class FillRange {
        public int localx;
        public int localy;
        public int localZBegin;
        public int localZEnd;

        public FillRange(int n, int n2, int n3, int n4) {
            this.localx = n;
            this.localy = n2;
            this.localZBegin = n3;
            this.localZEnd = n4;
        }
    }

    private static class Matrix3i {
        private int m00;
        private int m01;
        private int m02;
        private int m10;
        private int m11;
        private int m12;
        private int m20;
        private int m21;
        private int m22;

        public Matrix3i(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            this.m00 = n;
            this.m01 = n2;
            this.m02 = n3;
            this.m10 = n4;
            this.m11 = n5;
            this.m12 = n6;
            this.m20 = n7;
            this.m21 = n8;
            this.m22 = n9;
        }

        public <T extends Tuple3i> T transform(T t) {
            int n = this.m00 * t.x + this.m01 * t.y + this.m02 * t.z;
            int n2 = this.m10 * t.x + this.m11 * t.y + this.m12 * t.z;
            int n3 = this.m20 * t.x + this.m21 * t.y + this.m22 * t.z;
            t.set(n, n2, n3);
            return t;
        }
    }

    private class ScanLineBoundsAdder {
        private final Plane3d d_plane;
        private final int d_planeAlign;
        private final Point3i d_min;
        private final Point3i d_max;
        private final List<int[]>[] xScanBounds;
        private final List<int[]>[] yScanBounds;
        private final Comparator<int[]> d_comp = new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                return nArray[0] - nArray2[0];
            }
        };

        public ScanLineBoundsAdder(Plane3d plane3d, Point3i point3i, Point3i point3i2) {
            int n;
            this.d_plane = plane3d;
            this.d_min = point3i;
            this.d_max = point3i2;
            int n2 = point3i2.x - point3i.x;
            int n3 = point3i2.y - point3i.y;
            int n4 = point3i2.z - point3i.z;
            if (n4 <= n2 && n4 <= n3) {
                n = 0;
                this.xScanBounds = new ArrayList[n2];
                this.yScanBounds = new ArrayList[n3];
            } else if (n3 <= n2 && n3 <= n4) {
                n = 1;
                this.xScanBounds = new ArrayList[n2];
                this.yScanBounds = new ArrayList[n4];
            } else {
                n = 2;
                this.xScanBounds = new ArrayList[n3];
                this.yScanBounds = new ArrayList[n4];
            }
            this.d_planeAlign = n;
        }

        public void add(Point3i point3i, Point3i point3i2) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            switch (this.d_planeAlign) {
                case 0: {
                    n7 = point3i.x;
                    n6 = point3i.y;
                    n5 = point3i.z;
                    n4 = point3i2.x;
                    n3 = point3i2.y;
                    n2 = this.d_min.x;
                    n = this.d_min.y;
                    break;
                }
                case 1: {
                    n7 = point3i.x;
                    n6 = point3i.z;
                    n5 = point3i.y;
                    n4 = point3i2.x;
                    n3 = point3i2.z;
                    n2 = this.d_min.x;
                    n = this.d_min.z;
                    break;
                }
                default: {
                    n7 = point3i.y;
                    n6 = point3i.z;
                    n5 = point3i.x;
                    n4 = point3i2.y;
                    n3 = point3i2.z;
                    n2 = this.d_min.y;
                    n = this.d_min.z;
                }
            }
            if (n6 != n3) {
                int n8 = Math.min(n6, n3) - n;
                List<int[]> list = this.yScanBounds[n8];
                if (list == null) {
                    this.yScanBounds[n8] = list = new ArrayList<int[]>(2);
                }
                list.add(new int[]{n7, n5});
            } else if (n7 != n4) {
                int n9 = Math.min(n7, n4) - n2;
                List<int[]> list = this.xScanBounds[n9];
                if (list == null) {
                    this.xScanBounds[n9] = list = new ArrayList<int[]>(2);
                }
                list.add(new int[]{n6, n5});
            }
        }

        public void sortScans() {
            this.sortScans(this.xScanBounds);
            this.sortScans(this.yScanBounds);
        }

        private void sortScans(List<int[]>[] listArray) {
            for (int i = 0; i < listArray.length; ++i) {
                List<int[]> list = listArray[i];
                if (list == null) continue;
                int[][] nArray = (int[][])list.toArray((T[])new int[list.size()][]);
                Arrays.sort(nArray, this.d_comp);
                ArrayList<int[]> arrayList = new ArrayList<int[]>(nArray.length);
                for (int j = 0; j < nArray.length; ++j) {
                    arrayList.add(nArray[j]);
                }
                listArray[i] = arrayList;
            }
        }
    }

    private static enum Dir {
        X,
        Y,
        Z;

    }
}

