/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.geom;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;

public class TexCoordGenerator
implements ITexCoordGenerator,
Serializable {
    static final long serialVersionUID = 1L;
    private final Point3d d_texOrigin;

    public TexCoordGenerator(IGeom iGeom, TexOrigin texOrigin) {
        this(texOrigin != null ? texOrigin.getWorld(iGeom).getValue(Geometry.LU) : GeomConstants.PNT3D_ORIGIN);
    }

    public TexCoordGenerator(Point3d point3d) {
        this.d_texOrigin = point3d;
    }

    @Override
    public IElemSource<Point2d> fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        PlanarCoordMapper planarCoordMapper = pyrosim.geom.TexCoordGenerator.newGenerator(this.d_texOrigin);
        return planarCoordMapper.equals(pyrosim.geom.TexCoordGenerator.DEFAULT_OBJ) ? pyrosim.geom.TexCoordGenerator.DEFAULT_OBJ : planarCoordMapper;
    }

    @Override
    public void generate(int n, IPolygon iPolygon, IPrimProps iPrimProps, List<Point2d> list) {
        Surface surface = (Surface)iPrimProps.getMaterial();
        TextureInfo textureInfo = surface.getTextureInfo();
        double d = 1.0 / textureInfo.getWidth().getValue(Geometry.LU);
        double d2 = 1.0 / textureInfo.getHeight().getValue(Geometry.LU);
        Vector3d[] vector3dArray = TexCoordGenerator.generateLocalVecs(iPolygon.getNormal());
        int n2 = iPolygon.getNumLoops();
        for (int i = 0; i < n2; ++i) {
            int n3 = iPolygon.getNumPoints(i);
            for (int j = 0; j < n3; ++j) {
                Point3d point3d = iPolygon.getPoint(i, j);
                Point2d point2d = TexCoordGenerator.generateTexUV(this.d_texOrigin, d, d2, vector3dArray[0], vector3dArray[1], point3d);
                list.add(point2d);
            }
        }
    }

    @Override
    public void generate(int n, IFace iFace, IPrimProps iPrimProps, Mesh mesh, List<Point2d> list) {
        assert (mesh.primtype == 2);
        Point3d[] point3dArray = new Point3d[3];
        List<Point3d> list2 = Arrays.asList(point3dArray);
        Vector3d vector3d = new Vector3d(0.0, 0.0, 0.0);
        int n2 = 0;
        while (n2 < mesh.indices.length) {
            point3dArray[0] = mesh.vertices[mesh.indices[n2++]];
            point3dArray[1] = mesh.vertices[mesh.indices[n2++]];
            point3dArray[2] = mesh.vertices[mesh.indices[n2++]];
            Vector3d vector3d2 = Util3D.simplePolygonNormal(list2);
            if (vector3d2 == null) continue;
            vector3d.add(vector3d2);
        }
        double d = vector3d.length();
        if (d > 0.0) {
            int n3 = mesh.getNumPrims(1);
            vector3d.scale(1 / n3);
            vector3d.normalize();
        } else {
            vector3d = GeomConstants.VEC3D_ZPOS;
        }
        Vector3d[] vector3dArray = TexCoordGenerator.generateLocalVecs(vector3d);
        Surface surface = (Surface)iPrimProps.getMaterial();
        TextureInfo textureInfo = surface.getTextureInfo();
        double d2 = 1.0 / textureInfo.getWidth().getValue(Geometry.LU);
        double d3 = 1.0 / textureInfo.getHeight().getValue(Geometry.LU);
        for (Point3d point3d : mesh.vertices) {
            Point2d point2d = TexCoordGenerator.generateTexUV(this.d_texOrigin, d2, d3, vector3dArray[0], vector3dArray[1], point3d);
            list.add(point2d);
        }
    }

    private static Point2d generateTexUV(Point3d point3d, double d, double d2, Vector3d vector3d, Vector3d vector3d2, Point3d point3d2) {
        double d3 = point3d2.x - point3d.x;
        double d4 = point3d2.y - point3d.y;
        double d5 = point3d2.z - point3d.z;
        double d6 = vector3d.x * d3 + vector3d.y * d4 + vector3d.z * d5;
        double d7 = vector3d2.x * d3 + vector3d2.y * d4 + vector3d2.z * d5;
        return new Point2d(d6 * d, d7 * d2);
    }

    private static Vector3d[] generateLocalVecs(Vector3d vector3d) {
        Vector3d vector3d2;
        if (vector3d.x == 0.0 && vector3d.y == 0.0) {
            vector3d2 = new Vector3d(1.0, 0.0, 0.0);
        } else {
            vector3d2 = new Vector3d(-vector3d.y, vector3d.x, 0.0);
            vector3d2.normalize();
        }
        Vector3d vector3d3 = Util3D.cross(vector3d, vector3d2);
        vector3d3.normalize();
        return new Vector3d[]{vector3d2, vector3d3};
    }
}

