/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.zones;

import java.awt.Color;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;

public class Zone
extends NamedPyroObject
implements IPyroGeomSrc {
    static final long serialVersionUID = 1L;
    public static final Color DEF_COLOR = new Color(0.8f, 0.1f, 0.1f, 0.4f);
    private UnitAABox d_box;
    private boolean d_visible;
    private Color d_color;

    public Zone(String string, UnitAABox unitAABox) {
        super(string);
        this.d_box = unitAABox;
        this.d_visible = true;
        this.d_color = DEF_COLOR;
    }

    public boolean isOuter() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Zone)) {
            return false;
        }
        Zone zone = (Zone)object;
        return this.getName().equals(zone.getName()) && this.d_box.equals(zone.d_box) && this.d_color.equals(zone.d_color);
    }

    @Override
    public Object clone() {
        Zone zone = (Zone)super.clone();
        return zone;
    }

    public void getBounds(AABox aABox) {
        aABox.add(this.d_box.getValue(Geometry.LU));
    }

    public UnitAABox getBox() {
        return this.d_box;
    }

    public void setBox(UnitAABox unitAABox) {
        if (!this.d_box.equals(unitAABox)) {
            this.d_box = unitAABox;
            this.changedEvt(new Object[0]);
        }
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        if (!this.d_color.equals(color)) {
            this.d_color = color;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IGeom getGeom() {
        return new BlockGeom(this.d_box.getMin(Geometry.LU), this.d_box.getMax(Geometry.LU), 0);
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if ((iGeom = Geometry.finalize(iGeom, bl)) instanceof AABoxGeom) {
            AABoxGeom aABoxGeom = (AABoxGeom)iGeom;
            this.d_box = new UnitAABox(aABoxGeom.min, aABoxGeom.max, Geometry.LU);
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Face(this.d_color, null, true));
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.d_visible != bl) {
            this.d_visible = bl;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public AABox getBounds() {
        return this.getGeom().getBoundingBox(new AABox());
    }

    @Override
    public void getAll(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter) {
        if (iIsectFilter.acceptPickObject(this)) {
            iBoxCollector.add(this);
        }
    }

    @Override
    public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        if (this.getGeom().intersectsBox(this, iIsectFilter, convexHull)) {
            iBoxCollector.add(this);
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        this.getGeom().pickPoints(iIsectCollector, iIsectFilter, this, point3d, point3d2, vector3d, iTest);
    }
}

