/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.texture;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.texture.Texture;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.thunderheadeng.gui.IDomainObject;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;

public class TextureDB
implements IDomainObject<PyroMod>,
Serializable {
    private static final long serialVersionUID = 1L;
    private PyroMod d_domain;
    private Map<String, TextureInfo> d_defaults = new HashMap<String, TextureInfo>();
    private Map<String, Texture> d_textures = new HashMap<String, Texture>();

    @Override
    public void setDomain(PyroMod pyroMod) {
        this.d_domain = pyroMod;
    }

    @Override
    public PyroMod getDomain() {
        return this.d_domain;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ArrayList<Texture> arrayList = new ArrayList<Texture>();
        ArrayList<TextureInfo> arrayList2 = new ArrayList<TextureInfo>();
        if (this.d_domain != null) {
            for (Texture texture : this.d_textures.values()) {
                if (!texture.usedIn(this.d_domain)) continue;
                arrayList.add(texture);
                arrayList2.add(this.d_defaults.get(texture.getImageID()));
            }
        }
        objectOutputStream.writeInt(2);
        objectOutputStream.writeObject(arrayList);
        objectOutputStream.writeObject(arrayList2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.d_textures = new HashMap<String, Texture>();
        this.d_defaults = new HashMap<String, TextureInfo>();
        if (n < 2) {
            List list = (List)objectInputStream.readObject();
            for (TextureData textureData : list) {
                Image image;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                if (!ImageIO.write((RenderedImage)textureData.img, "jpg", byteArrayOutputStream) || (image = Image.load(textureData.id, byteArrayOutputStream.toByteArray())) == null) continue;
                this.d_textures.put(textureData.id, new Texture(textureData.id, image));
            }
        } else {
            Object object2;
            List list = (List)objectInputStream.readObject();
            for (Object object2 : list) {
                this.d_textures.put(((Texture)object2).getImageID(), (Texture)object2);
            }
            List list2 = (List)objectInputStream.readObject();
            object2 = list2.iterator();
            while (object2.hasNext()) {
                TextureInfo textureInfo = (TextureInfo)object2.next();
                this.d_defaults.put(textureInfo.getTexID(), textureInfo);
            }
        }
    }

    public Set<String> names() {
        return this.d_textures.keySet();
    }

    public Texture getTexture(String string) {
        return this.d_textures.get(string);
    }

    public void setTexture(String string, Texture texture) {
        this.d_textures.put(string, texture);
    }

    public void removeTexture(String string) {
        this.d_textures.remove(string);
    }

    public void setDefaultInfo(String string, TextureInfo textureInfo) {
        this.d_defaults.put(string, textureInfo);
    }

    public TextureInfo getDefaultInfo(String string) {
        return this.d_defaults.get(string);
    }

    public void removeDefaultInfo(String string) {
        this.d_defaults.remove(string);
    }

    private static class TextureData
    implements Serializable {
        static final long serialVersionUID = 6282794853364214105L;
        private static final int VERSION = 1;
        public String id;
        public BufferedImage img;

        public TextureData(String string, BufferedImage bufferedImage) {
            this.id = string;
            this.img = bufferedImage;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeInt(1);
            objectOutputStream.writeObject(this.id);
            if (this.img != null) {
                ImageIO.write((RenderedImage)this.img, "jpg", objectOutputStream);
            } else {
                objectOutputStream.writeObject(null);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.readInt();
            this.id = (String)objectInputStream.readObject();
            this.img = ImageIO.read(objectInputStream);
        }
    }
}

