/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.texture;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;

public class Texture
implements Serializable {
    static final long serialVersionUID = 1L;
    private Image d_image;
    private String d_texName;

    public Texture(String string, Image image) {
        this.d_texName = string;
        this.d_image = image;
    }

    public String getImageID() {
        return this.d_texName;
    }

    public Image getImage() {
        return this.d_image;
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage = this.d_image.toBufferedImage();
        return bufferedImage;
    }

    public boolean isValid() {
        return this.d_image.isValid();
    }

    public static BufferedImage makeSafe(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[[TextureInfo]");
        stringBuffer.append("filename=");
        stringBuffer.append(this.getImageID());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Texture) {
            return ((Texture)object).getImageID().equals(this.getImageID());
        }
        return false;
    }

    public int hashCode() {
        return this.getImageID().hashCode();
    }

    public boolean usedIn(PyroMod pyroMod) {
        SurfaceManager surfaceManager = pyroMod.getSurfaceMgr();
        for (Surface surface : surfaceManager.flatten()) {
            TextureInfo textureInfo = surface.getTextureInfo();
            if (textureInfo == null || !textureInfo.getTexID().equals(this.getImageID())) continue;
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeObject(this.d_texName);
        Image image = this.d_image.toCachedImage();
        if (image == null) {
            image = this.d_image;
        }
        objectOutputStream.writeObject(image);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.readInt();
        this.d_texName = (String)objectInputStream.readObject();
        this.d_image = (Image)objectInputStream.readObject();
    }
}

