/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.tasks.AddTask;
import pyrosim.legacy_2012_1.domain.tasks.AutoRenameTask;
import pyrosim.legacy_2012_1.domain.tasks.SelectTask;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theTimer;
import pyrosim.legacy_2012_1.util.Util;

public abstract class TransformTask
extends AUndoableTask {
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_objs;
    private List<IGeom> d_oldGeom = null;
    private Task d_copyTask = null;
    private final int d_n;

    public abstract Matrix4d getXFormForIteration(int var1);

    public TransformTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection, int n) {
        this.d_mediator = pyroMod;
        this.d_objs = new ArrayList<IPyroObject>(collection);
        this.d_n = n;
    }

    @Override
    public int getEst() {
        return 1;
    }

    private static String generateName(INamed iNamed, int n) {
        return iNamed.getName() + "[" + (n + 1) + "]";
    }

    private void runCopyTask() {
        Object object;
        if (this.d_copyTask != null) {
            this.d_copyTask.run();
            return;
        }
        theTimer theTimer2 = new theTimer();
        System.out.print("Transforming/Copying...");
        CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(this.d_mediator);
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        arrayList.addAll(this.d_objs);
        ArrayList<Pair<Composite, INamed>> arrayList2 = new ArrayList<Pair<Composite, INamed>>();
        for (int i = 0; i < this.d_n; ++i) {
            Matrix4d matrix4d = this.getXFormForIteration(i + 1);
            for (IPyroObject cloneable2 : this.d_objs) {
                IPyroObject iPyroObject = Hierarchy.getCategoryRoot(cloneable2);
                if (!(iPyroObject instanceof Composite)) continue;
                Composite composite = cloneable2.getParent() instanceof Composite ? (Composite)cloneable2.getParent() : (Composite)iPyroObject;
                object = this.copy((Composite)iPyroObject, composite, cloneable2, i, matrix4d, true, compositeTask, arrayList2);
                arrayList.add((Cloneable)object);
            }
        }
        double d = theTimer2.curr();
        System.out.printf("done (%g s)%n", d);
        SelectTask selectTask = new SelectTask(this.d_mediator, arrayList);
        LinkedIdentityHashMap linkedIdentityHashMap = new LinkedIdentityHashMap();
        for (Pair pair : arrayList2) {
            object = (List)linkedIdentityHashMap.get(pair.v1);
            if (object == null) {
                object = new ArrayList();
                linkedIdentityHashMap.put(pair.v1, object);
            }
            object.add(pair.v2);
        }
        for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
            object = new AutoRenameTask((Composite)entry.getKey(), (Collection)entry.getValue());
            selectTask.addTask((Task)object);
        }
        selectTask.addTask(compositeTask);
        this.d_copyTask = selectTask;
        this.d_copyTask.run();
    }

    private IPyroObject copy(Composite composite, Composite composite2, IPyroObject iPyroObject, int n, Matrix4d matrix4d, boolean bl, CompositeTask compositeTask, List<Pair<Composite, INamed>> list) {
        if (iPyroObject instanceof Composite) {
            Composite composite3 = (Composite)iPyroObject;
            Composite composite4 = composite3.clone(false);
            if (bl) {
                composite4.setName(TransformTask.generateName(composite3, n));
            }
            for (IPyroObject iPyroObject2 : composite3.getMembers()) {
                this.copy(composite, composite4, iPyroObject2, n, matrix4d, false, compositeTask, list);
            }
            compositeTask.addTask(new AddTask(composite2, new IPyroObject[]{composite4}));
            return composite4;
        }
        IPyroGeomSrc iPyroGeomSrc = (IPyroGeomSrc)iPyroObject.clone();
        iPyroGeomSrc.setGeom(iPyroGeomSrc.getGeom().transform(matrix4d, IGeom.XformOp.RETAINED), true);
        if (iPyroGeomSrc instanceof INamed) {
            INamed iNamed = (INamed)((Object)iPyroGeomSrc);
            if (this.isKeyedByName(iPyroGeomSrc)) {
                list.add(new Pair<Composite, INamed>(composite, iNamed));
            } else if (bl) {
                iNamed.setName(iNamed.getName() + "[" + (n + 1) + "]");
            }
        }
        compositeTask.addTask(new AddTask(composite2, new IPyroObject[]{iPyroGeomSrc}));
        return iPyroGeomSrc;
    }

    private boolean isKeyedByName(Object object) {
        return Util.isKeyedByName(this.d_mediator, object);
    }

    private void undoCopyTask() {
        assert (this.d_copyTask != null);
        this.d_copyTask.undo();
    }

    private void runMoveTask() {
        Collection<IPyroGeomSrc> collection = Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class);
        if (this.d_oldGeom == null) {
            this.d_oldGeom = new ArrayList<IGeom>(collection.size());
            for (IPyroGeomSrc object : collection) {
                this.d_oldGeom.add(object.getGeom());
            }
        }
        Matrix4d matrix4d = this.getXFormForIteration(1);
        for (IPyroGeomSrc iPyroGeomSrc : collection) {
            IGeom iGeom = iPyroGeomSrc.getGeom().transform(matrix4d, IGeom.XformOp.RETAINED);
            iPyroGeomSrc.setGeom(iGeom, true);
        }
    }

    private void undoMoveTask() {
        assert (this.d_oldGeom != null);
        int n = 0;
        Collection<IPyroGeomSrc> collection = Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class);
        for (IPyroGeomSrc iPyroGeomSrc : collection) {
            iPyroGeomSrc.setGeom(this.d_oldGeom.get(n++), false);
        }
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        if (this.d_n == 0) {
            this.runMoveTask();
        } else {
            this.runCopyTask();
        }
        this.d_mediator.resumeUpdates();
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        if (this.d_n == 0) {
            this.undoMoveTask();
        } else {
            this.undoCopyTask();
        }
        this.d_mediator.resumeUpdates();
    }
}

