/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.tasks.TransformTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class ScaleTask
extends TransformTask {
    private final Point3d d_base;
    private final Tuple3d d_scale;

    public ScaleTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection, int n, UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        super(pyroMod, collection, n);
        this.d_base = unitPoint3D.getPoint3dValue(Geometry.LU);
        this.d_scale = new Vector3d(tuple3d);
    }

    @Override
    public Matrix4d getXFormForIteration(int n) {
        double d = Math.pow(this.d_scale.x, n);
        double d2 = Math.pow(this.d_scale.y, n);
        double d3 = Math.pow(this.d_scale.z, n);
        Matrix4d matrix4d = Util.translateMat(this.d_base.x, this.d_base.y, this.d_base.z);
        matrix4d.mul(Util.scaleMat(d, d2, d3));
        matrix4d.mul(Util.translateMat(-this.d_base.x, -this.d_base.y, -this.d_base.z));
        return matrix4d;
    }

    private static class Transform {
        private Tuple3d d_scale;
        private Matrix4d d_matrix;

        private Transform() {
        }
    }
}

