/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.tasks.TransformTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class RotateTask
extends TransformTask {
    private final Point3d d_base;
    private final Vector3d d_rotateAxis;
    private final double d_angle;

    public RotateTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection, int n, UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        super(pyroMod, collection, n);
        this.d_base = unitPoint3D.getPoint3dValue(Geometry.LU);
        this.d_rotateAxis = new Vector3d(vector3d);
        this.d_angle = unitDouble.getValue(SI.RADIAN);
    }

    @Override
    public Matrix4d getXFormForIteration(int n) {
        double d = this.d_angle * (double)n;
        Matrix4d matrix4d = Util.translateMat(this.d_base.x, this.d_base.y, this.d_base.z);
        matrix4d.mul(Util.rotMat(this.d_rotateAxis.x, this.d_rotateAxis.y, this.d_rotateAxis.z, d));
        matrix4d.mul(Util.translateMat(-this.d_base.x, -this.d_base.y, -this.d_base.z));
        return matrix4d;
    }
}

