/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;

class ReplacePreserveTask
extends AUndoableTask {
    private final ReplaceRecord[] d_replacements;

    public ReplacePreserveTask(List<? extends IPyroObject> list, List<? extends IPyroObject> list2) {
        this.d_replacements = new ReplaceRecord[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.d_replacements[i] = new ReplaceRecord(list.get(i), list2.get(i));
        }
    }

    @Override
    public void run() {
        if (this.d_replacements.length > 0 && this.d_replacements[0].index == -1) {
            IdentityHashMap<IPyroObject, ReplaceRecord> identityHashMap = new IdentityHashMap<IPyroObject, ReplaceRecord>();
            IdentityHashSet identityHashSet = new IdentityHashSet();
            for (ReplaceRecord replaceRecord : this.d_replacements) {
                identityHashMap.put(replaceRecord.original, replaceRecord);
                identityHashSet.add((Composite)replaceRecord.original.getParent());
            }
            for (Composite composite : identityHashSet) {
                int n = 0;
                for (IPyroObject iPyroObject : composite.getMembers()) {
                    ReplaceRecord replaceRecord = (ReplaceRecord)identityHashMap.get(iPyroObject);
                    if (replaceRecord != null) {
                        replaceRecord.index = n;
                    }
                    ++n;
                }
            }
        }
        this.runReplacements();
    }

    @Override
    public void undo() {
        this.runReplacements();
    }

    private void runReplacements() {
        LinkedIdentityHashMap<Composite, ArrayList<ReplaceRecord>> linkedIdentityHashMap = new LinkedIdentityHashMap<Composite, ArrayList<ReplaceRecord>>();
        for (ReplaceRecord object : this.d_replacements) {
            Composite composite = (Composite)object.original.getParent();
            ArrayList<ReplaceRecord> arrayList2 = (ArrayList<ReplaceRecord>)linkedIdentityHashMap.get(composite);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<ReplaceRecord>();
                linkedIdentityHashMap.put(composite, arrayList2);
            }
            arrayList2.add(object);
        }
        for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
            Composite composite = (Composite)entry.getKey();
            ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>(composite.getMembers());
            for (ArrayList<ReplaceRecord> arrayList2 : (List)entry.getValue()) {
                composite.remove(((ReplaceRecord)((Object)arrayList2)).original);
                composite.add(((ReplaceRecord)((Object)arrayList2)).replacement);
                arrayList.set(((ReplaceRecord)((Object)arrayList2)).index, ((ReplaceRecord)((Object)arrayList2)).replacement);
                ((ReplaceRecord)((Object)arrayList2)).swap();
            }
            composite.reorder(arrayList);
        }
    }

    private static class ReplaceRecord {
        public IPyroObject original;
        public IPyroObject replacement;
        public int index;

        public ReplaceRecord(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
            this.original = iPyroObject;
            this.replacement = iPyroObject2;
            this.index = -1;
        }

        public void swap() {
            IPyroObject iPyroObject = this.original;
            this.original = this.replacement;
            this.replacement = iPyroObject;
        }
    }
}

