/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.tasks.DeletePreserveTask;
import pyrosim.legacy_2012_1.domain.tasks.InsertTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;

public class ReorderObjectsTask
extends DeletePreserveTask {
    private final Composite<? extends IPyroObject> d_target;
    private final int d_insertPt;

    public ReorderObjectsTask(Composite<? extends IPyroObject> composite, int n, IPyroObject ... iPyroObjectArray) {
        this(composite, n, Arrays.asList(iPyroObjectArray));
    }

    public ReorderObjectsTask(Composite<? extends IPyroObject> composite, int n, Collection<? extends IPyroObject> collection) {
        super(collection);
        this.d_target = composite;
        this.d_insertPt = n;
    }

    @Override
    public void undo() {
        this.run(false);
    }

    @Override
    public void run() {
        this.run(true);
    }

    public void run(boolean bl) {
        ((PyroMod)this.d_target.getDomain()).pauseUpdates(false);
        if (bl) {
            this.doAction();
        } else {
            this.undoAction();
        }
        ((PyroMod)this.d_target.getDomain()).resumeUpdates();
        ((PyroMod)this.d_target.getDomain()).pauseUpdates();
        this.d_target.changedEvt(PyroMod.EVT_CHILDREN_CHANGED);
        for (DeletePreserveTask.MoveRecord moveRecord : this.getRecords()) {
            moveRecord.oldParent.changedEvt(PyroMod.EVT_CHILDREN_CHANGED);
            moveRecord.moveObj.changedEvt(PyroMod.EVT_PARENT_CHANGED);
        }
        ((PyroMod)this.d_target.getDomain()).resumeUpdates();
    }

    public void doAction() {
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        for (DeletePreserveTask.MoveRecord moveRecord : this.getRecords()) {
            linkedIdentityHashSet.add(moveRecord.moveObj);
        }
        Object object = null;
        Iterator<IPyroObject> iterator = this.d_target.getMembers().iterator();
        for (int i = 0; iterator.hasNext() && i < this.d_insertPt; ++i) {
            IPyroObject iPyroObject = iterator.next();
            if (linkedIdentityHashSet.contains(iPyroObject)) continue;
            object = iPyroObject;
        }
        super.run();
        int n = 0;
        if (object != null) {
            n = 1;
            for (IPyroObject iPyroObject : this.d_target.getMembers()) {
                if (iPyroObject == object) break;
                ++n;
            }
        }
        new InsertTask<IPyroObject>(this.d_target, n, linkedIdentityHashSet).run();
    }

    public void undoAction() {
        List<DeletePreserveTask.MoveRecord> list = this.getRecords();
        for (int i = list.size() - 1; i >= 0; --i) {
            DeletePreserveTask.MoveRecord moveRecord = list.get(i);
            this.d_target.remove(moveRecord.moveObj);
        }
        super.undo();
    }
}

