/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2012_1.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.domain.tasks.AddTask;
import pyrosim.legacy_2012_1.domain.tasks.Tasks;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public class RasterizeTask
extends CompositeTask<PyroMod> {
    private final PyroMod d_pyMod;
    private final RasterizationOptions d_props;
    private final Collection<? extends FDSObject> d_objs;

    public RasterizeTask(PyroMod pyroMod, Collection<? extends FDSObject> collection, RasterizationOptions rasterizationOptions) {
        super(pyroMod);
        this.d_pyMod = pyroMod;
        this.d_objs = new ArrayList<FDSObject>(collection);
        this.d_props = rasterizationOptions;
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    protected void queueBeginRuntimeTasks() {
        this.d_pyMod.pauseUpdates();
        RasterizationOptions rasterizationOptions = this.d_pyMod.getRastOptions();
        this.d_pyMod.pauseUpdates(false);
        this.d_pyMod.setRastProps(this.d_props);
        this.d_pyMod.resumeUpdates();
        if (this.d_props.mergeIdentical) {
            this.rasterizeAsOne();
        } else {
            this.rasterizeSeparately();
        }
        this.d_pyMod.pauseUpdates(false);
        this.d_pyMod.setRastProps(rasterizationOptions);
        this.d_pyMod.resumeUpdates();
        this.d_pyMod.resumeUpdates();
    }

    private static boolean isEmptyParent(IPyroObject iPyroObject) {
        if (!(iPyroObject instanceof Composite)) {
            return false;
        }
        Composite composite = (Composite)iPyroObject;
        for (IPyroObject iPyroObject2 : composite.getMembers()) {
            if (RasterizeTask.isEmptyParent(iPyroObject2)) continue;
            return false;
        }
        return true;
    }

    private void rasterizeAsOne() {
        FDSRasterization fDSRasterization = this.d_pyMod.getRasterizations();
        FDSObjectRasterization[] fDSObjectRasterizationArray = fDSRasterization.rasterize(this.d_objs);
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        ArrayList<Pair<FDSObject, IPyroObject>> arrayList = new ArrayList<Pair<FDSObject, IPyroObject>>();
        ArrayList<AddTask> arrayList2 = new ArrayList<AddTask>();
        for (FDSObjectRasterization fDSObjectRasterization : fDSObjectRasterizationArray) {
            IPyroObject iPyroObject = fDSObjectRasterization.getFrags(this.d_props.geomGroups);
            if (fDSObjectRasterization.sources.size() == 1) {
                arrayList.add(new Pair<FDSObject, IPyroObject>(fDSObjectRasterization.sources.get(0), iPyroObject));
                continue;
            }
            for (FDSObject fDSObject : fDSObjectRasterization.sources) {
                linkedIdentityHashSet.add(fDSObject);
            }
            if (iPyroObject == null) continue;
            Object object = Hierarchy.getCommonParent(fDSObjectRasterization.sources);
            if (!(object instanceof ModelComposite)) {
                object = this.d_pyMod.getObstructions();
            }
            arrayList2.add(new AddTask((Composite)((ModelComposite)object), new IPyroObject[]{iPyroObject}));
        }
        this.addTask(Tasks.delete(linkedIdentityHashSet));
        this.addTask(RasterizeTask.newConvertTask(this.d_pyMod, arrayList));
        for (Task task : arrayList2) {
            this.addTask(task);
        }
    }

    private void rasterizeSeparately() {
        FDSRasterization fDSRasterization = this.d_pyMod.getRasterizations();
        ArrayList<Pair<FDSObject, IPyroObject>> arrayList = new ArrayList<Pair<FDSObject, IPyroObject>>();
        for (FDSObject fDSObject : this.d_objs) {
            FDSObjectRasterization fDSObjectRasterization = fDSRasterization.rasterize(fDSObject);
            if (fDSObjectRasterization == null) continue;
            IPyroObject iPyroObject = fDSObjectRasterization.getFrags(this.d_props.geomGroups);
            arrayList.add(new Pair<FDSObject, IPyroObject>(fDSObject, iPyroObject));
        }
        this.addTask(RasterizeTask.newConvertTask(this.d_pyMod, arrayList));
    }

    private static Task newConvertTask(PyroMod pyroMod, List<Pair<FDSObject, IPyroObject>> list) {
        CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
        ArrayList arrayList = new ArrayList();
        ArrayList<FDSObject> arrayList2 = new ArrayList<FDSObject>(list.size());
        ArrayList<IPyroObject> arrayList3 = new ArrayList<IPyroObject>(list.size());
        for (Pair<FDSObject, IPyroObject> pair : list) {
            FDSObject fDSObject = (FDSObject)pair.v1;
            IPyroObject iPyroObject = (IPyroObject)pair.v2;
            if (iPyroObject == null) {
                arrayList.add(pair.v1);
                continue;
            }
            if (iPyroObject instanceof ModelComposite) {
                arrayList2.add(fDSObject);
                arrayList3.add(iPyroObject);
                continue;
            }
            if (fDSObject instanceof IObstruction) {
                IObstruction iObstruction = (IObstruction)iPyroObject;
                compositeTask.addTask(new SetObstGeomTask((IObstruction)fDSObject, ((IObstruction)iPyroObject).getGeom(), iObstruction.getSurfaces(), iObstruction.getColors()));
                continue;
            }
            if (!(fDSObject instanceof IHole)) continue;
            compositeTask.addTask(new SetHoleGeomTask((IHole)fDSObject, ((IHole)iPyroObject).getGeom(), ((IHole)iPyroObject).getColors()));
        }
        if (!arrayList.isEmpty()) {
            compositeTask.addTask(Tasks.delete(arrayList));
        }
        if (!arrayList2.isEmpty()) {
            compositeTask.addTask(Tasks.replace(arrayList2, arrayList3, true));
        }
        return compositeTask;
    }

    private static class SetHoleGeomTask
    extends AUndoableTask {
        private final IHole d_hole;
        private IGeom d_newGeom;
        private Color[] d_newColors;

        public SetHoleGeomTask(IHole iHole, IGeom iGeom, Color[] colorArray) {
            this.d_hole = iHole;
            this.d_newGeom = iGeom;
            this.d_newColors = colorArray;
        }

        @Override
        public void run() {
            IGeom iGeom = this.d_newGeom;
            Color[] colorArray = this.d_newColors;
            this.d_newGeom = this.d_hole.getGeom();
            this.d_newColors = this.d_hole.getColors();
            if (this.d_hole.getDomain() != null) {
                ((PyroMod)this.d_hole.getDomain()).pauseUpdates();
            }
            this.d_hole.setGeom(iGeom, true);
            this.d_hole.setColors(colorArray);
            if (this.d_hole.getDomain() != null) {
                ((PyroMod)this.d_hole.getDomain()).resumeUpdates();
            }
        }

        @Override
        public void undo() {
            this.run();
        }
    }

    private static class SetObstGeomTask
    extends AUndoableTask {
        private final IObstruction d_obst;
        private IGeom d_newGeom;
        private Surface[] d_newSurfs;
        private Color[] d_newColors;

        public SetObstGeomTask(IObstruction iObstruction, IGeom iGeom, Surface[] surfaceArray, Color[] colorArray) {
            this.d_obst = iObstruction;
            this.d_newGeom = iGeom;
            this.d_newSurfs = surfaceArray;
            this.d_newColors = colorArray;
        }

        @Override
        public void run() {
            IGeom iGeom = this.d_newGeom;
            Surface[] surfaceArray = this.d_newSurfs;
            Color[] colorArray = this.d_newColors;
            this.d_newGeom = this.d_obst.getGeom();
            this.d_newSurfs = this.d_obst.getSurfaces();
            this.d_newColors = this.d_obst.getColors();
            if (this.d_obst.getDomain() != null) {
                ((PyroMod)this.d_obst.getDomain()).pauseUpdates();
            }
            this.d_obst.setGeom(iGeom, true);
            this.d_obst.setColors(colorArray);
            this.d_obst.setSurfaces(surfaceArray);
            if (this.d_obst.getDomain() != null) {
                ((PyroMod)this.d_obst.getDomain()).resumeUpdates();
            }
        }

        @Override
        public void undo() {
            this.run();
        }
    }
}

