/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Collection;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.tasks.TransformTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class MirrorTask
extends TransformTask {
    private final Matrix4d d_xform = new Matrix4d();

    public MirrorTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection, int n, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3) {
        super(pyroMod, collection, n);
        this.d_xform.setIdentity();
        if (unitDouble3 != null) {
            this.d_xform.mul(Util.mirrorMat(0.0, 0.0, 1.0, -unitDouble3.getValue(Geometry.LU)));
        }
        if (unitDouble2 != null) {
            this.d_xform.mul(Util.mirrorMat(0.0, 1.0, 0.0, -unitDouble2.getValue(Geometry.LU)));
        }
        if (unitDouble != null) {
            this.d_xform.mul(Util.mirrorMat(1.0, 0.0, 0.0, -unitDouble.getValue(Geometry.LU)));
        }
    }

    @Override
    public Matrix4d getXFormForIteration(int n) {
        return this.d_xform;
    }
}

